/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.SubstringReader;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;

abstract class AbstractSubstringMatchingRuleImpl
extends AbstractMatchingRuleImpl {
    AbstractSubstringMatchingRuleImpl() {
    }

    @Override
    public Assertion getAssertion(Schema schema, ByteSequence value) throws DecodeException {
        LinkedList<ByteString> anyStrings;
        ByteString finalString;
        ByteString initialString;
        block7: {
            if (value.length() == 0) {
                throw DecodeException.error(CoreMessages.WARN_ATTR_SYNTAX_SUBSTRING_EMPTY.get());
            }
            initialString = null;
            finalString = null;
            anyStrings = null;
            String valueString = value.toString();
            if (valueString.length() == 1 && valueString.charAt(0) == '*') {
                return this.getAssertion(schema, initialString, anyStrings, finalString);
            }
            SubstringReader reader = new SubstringReader(valueString);
            char[] escapeChars = new char[]{'*'};
            ByteString bytes = this.evaluateEscapes(reader, escapeChars, false);
            if (bytes.length() > 0) {
                initialString = this.normalizeSubString(schema, bytes);
            }
            if (reader.remaining() == 0) {
                throw DecodeException.error(CoreMessages.WARN_ATTR_SYNTAX_SUBSTRING_NO_WILDCARDS.get((Object)value.toString()));
            }
            while (true) {
                reader.read();
                bytes = this.evaluateEscapes(reader, escapeChars, false);
                if (reader.remaining() <= 0) break;
                if (bytes.length() == 0) {
                    throw DecodeException.error(CoreMessages.WARN_ATTR_SYNTAX_SUBSTRING_CONSECUTIVE_WILDCARDS.get((Object)value.toString(), (Object)reader.pos()));
                }
                if (anyStrings == null) {
                    anyStrings = new LinkedList<ByteString>();
                }
                anyStrings.add(this.normalizeSubString(schema, bytes));
            }
            if (bytes.length() <= 0) break block7;
            finalString = this.normalizeSubString(schema, bytes);
        }
        return this.getAssertion(schema, initialString, anyStrings, finalString);
    }

    @Override
    public Assertion getAssertion(Schema schema, ByteSequence subInitial, List<? extends ByteSequence> subAnyElements, ByteSequence subFinal) throws DecodeException {
        ByteString normInitial = subInitial == null ? null : this.normalizeSubString(schema, subInitial);
        ByteString[] normAnys = null;
        if (subAnyElements != null && !subAnyElements.isEmpty()) {
            normAnys = new ByteString[subAnyElements.size()];
            for (int i = 0; i < subAnyElements.size(); ++i) {
                normAnys[i] = this.normalizeSubString(schema, subAnyElements.get(i));
            }
        }
        ByteString normFinal = subFinal == null ? null : this.normalizeSubString(schema, subFinal);
        return new DefaultSubstringAssertion(normInitial, normAnys, normFinal);
    }

    ByteString normalizeSubString(Schema schema, ByteSequence value) throws DecodeException {
        return this.normalizeAttributeValue(schema, value);
    }

    private char evaluateEscapedChar(SubstringReader reader, char[] escapeChars) throws DecodeException {
        int b;
        char c1 = reader.read();
        switch (c1) {
            case '0': {
                b = 0;
                break;
            }
            case '1': {
                b = 16;
                break;
            }
            case '2': {
                b = 32;
                break;
            }
            case '3': {
                b = 48;
                break;
            }
            case '4': {
                b = 64;
                break;
            }
            case '5': {
                b = 80;
                break;
            }
            case '6': {
                b = 96;
                break;
            }
            case '7': {
                b = 112;
                break;
            }
            case '8': {
                b = -128;
                break;
            }
            case '9': {
                b = -112;
                break;
            }
            case 'A': 
            case 'a': {
                b = -96;
                break;
            }
            case 'B': 
            case 'b': {
                b = -80;
                break;
            }
            case 'C': 
            case 'c': {
                b = -64;
                break;
            }
            case 'D': 
            case 'd': {
                b = -48;
                break;
            }
            case 'E': 
            case 'e': {
                b = -32;
                break;
            }
            case 'F': 
            case 'f': {
                b = -16;
                break;
            }
            default: {
                if (c1 == '\\') {
                    return c1;
                }
                if (escapeChars != null) {
                    for (char escapeChar : escapeChars) {
                        if (c1 != escapeChar) continue;
                        return c1;
                    }
                }
                LocalizableMessage message = CoreMessages.ERR_INVALID_ESCAPE_CHAR.get((Object)reader.getString(), (Object)Character.valueOf(c1));
                throw DecodeException.error(message);
            }
        }
        if (reader.remaining() == 0) {
            LocalizableMessage message = CoreMessages.ERR_HEX_DECODE_INVALID_LENGTH.get((Object)reader.getString());
            throw DecodeException.error(message);
        }
        char c2 = reader.read();
        switch (c2) {
            case '0': {
                break;
            }
            case '1': {
                b = (byte)(b | 1);
                break;
            }
            case '2': {
                b = (byte)(b | 2);
                break;
            }
            case '3': {
                b = (byte)(b | 3);
                break;
            }
            case '4': {
                b = (byte)(b | 4);
                break;
            }
            case '5': {
                b = (byte)(b | 5);
                break;
            }
            case '6': {
                b = (byte)(b | 6);
                break;
            }
            case '7': {
                b = (byte)(b | 7);
                break;
            }
            case '8': {
                b = (byte)(b | 8);
                break;
            }
            case '9': {
                b = (byte)(b | 9);
                break;
            }
            case 'A': 
            case 'a': {
                b = (byte)(b | 0xA);
                break;
            }
            case 'B': 
            case 'b': {
                b = (byte)(b | 0xB);
                break;
            }
            case 'C': 
            case 'c': {
                b = (byte)(b | 0xC);
                break;
            }
            case 'D': 
            case 'd': {
                b = (byte)(b | 0xD);
                break;
            }
            case 'E': 
            case 'e': {
                b = (byte)(b | 0xE);
                break;
            }
            case 'F': 
            case 'f': {
                b = (byte)(b | 0xF);
                break;
            }
            default: {
                LocalizableMessage message = CoreMessages.ERR_HEX_DECODE_INVALID_CHARACTER.get((Object)new String(new char[]{c1, c2}), (Object)Character.valueOf(c1));
                throw DecodeException.error(message);
            }
        }
        return (char)b;
    }

    private ByteString evaluateEscapes(SubstringReader reader, char[] escapeChars, boolean trim) throws DecodeException {
        return this.evaluateEscapes(reader, escapeChars, escapeChars, trim);
    }

    private ByteString evaluateEscapes(SubstringReader reader, char[] escapeChars, char[] delimiterChars, boolean trim) throws DecodeException {
        int length = 0;
        int lengthWithoutSpace = 0;
        ByteStringBuilder valueBuffer = null;
        if (trim) {
            reader.skipWhitespaces();
        }
        reader.mark();
        while (reader.remaining() > 0) {
            char c = reader.read();
            if (c == '\\') {
                if (valueBuffer == null) {
                    valueBuffer = new ByteStringBuilder();
                }
                valueBuffer.append(reader.read(length));
                valueBuffer.append(this.evaluateEscapedChar(reader, escapeChars));
                reader.mark();
                lengthWithoutSpace = 0;
                length = 0;
            }
            if (delimiterChars != null) {
                for (char delimiterChar : delimiterChars) {
                    if (c != delimiterChar) continue;
                    reader.reset();
                    if (valueBuffer != null) {
                        if (trim) {
                            valueBuffer.append(reader.read(lengthWithoutSpace));
                        } else {
                            valueBuffer.append(reader.read(length));
                        }
                        return valueBuffer.toByteString();
                    }
                    if (trim) {
                        if (lengthWithoutSpace > 0) {
                            return ByteString.valueOf(reader.read(lengthWithoutSpace));
                        }
                        return ByteString.empty();
                    }
                    if (length > 0) {
                        return ByteString.valueOf(reader.read(length));
                    }
                    return ByteString.empty();
                }
            }
            ++length;
            if (c != ' ') {
                lengthWithoutSpace = length;
                continue;
            }
            ++lengthWithoutSpace;
        }
        reader.reset();
        if (valueBuffer != null) {
            if (trim) {
                valueBuffer.append(reader.read(lengthWithoutSpace));
            } else {
                valueBuffer.append(reader.read(length));
            }
            return valueBuffer.toByteString();
        }
        if (trim) {
            if (lengthWithoutSpace > 0) {
                return ByteString.valueOf(reader.read(lengthWithoutSpace));
            }
            return ByteString.empty();
        }
        if (length > 0) {
            return ByteString.valueOf(reader.read(length));
        }
        return ByteString.empty();
    }

    static class DefaultSubstringAssertion
    implements Assertion {
        private final ByteString normInitial;
        private final ByteString[] normAnys;
        private final ByteString normFinal;

        protected DefaultSubstringAssertion(ByteString normInitial, ByteString[] normAnys, ByteString normFinal) {
            this.normInitial = normInitial;
            this.normAnys = normAnys;
            this.normFinal = normFinal;
        }

        @Override
        public ConditionResult matches(ByteSequence attributeValue) {
            int pos;
            int valueLength = attributeValue.length();
            if (this.normInitial != null) {
                int initialLength = this.normInitial.length();
                if (initialLength > valueLength) {
                    return ConditionResult.FALSE;
                }
                for (pos = 0; pos < initialLength; ++pos) {
                    if (this.normInitial.byteAt(pos) == attributeValue.byteAt(pos)) continue;
                    return ConditionResult.FALSE;
                }
            }
            if (this.normAnys != null && this.normAnys.length != 0) {
                for (ByteString element : this.normAnys) {
                    int anyLength = element.length();
                    if (anyLength == 0) continue;
                    int end = valueLength - anyLength;
                    boolean match = false;
                    while (pos <= end) {
                        if (element.byteAt(0) == attributeValue.byteAt(pos)) {
                            boolean subMatch = true;
                            for (int i = 1; i < anyLength; ++i) {
                                if (element.byteAt(i) == attributeValue.byteAt(pos + i)) continue;
                                subMatch = false;
                                break;
                            }
                            if (subMatch) {
                                match = subMatch;
                                break;
                            }
                        }
                        ++pos;
                    }
                    if (match) {
                        pos += anyLength;
                        continue;
                    }
                    return ConditionResult.FALSE;
                }
            }
            if (this.normFinal != null) {
                int finalLength = this.normFinal.length();
                if (valueLength - finalLength < pos) {
                    return ConditionResult.FALSE;
                }
                pos = valueLength - finalLength;
                int i = 0;
                while (i < finalLength) {
                    if (this.normFinal.byteAt(i) != attributeValue.byteAt(pos)) {
                        return ConditionResult.FALSE;
                    }
                    ++i;
                    ++pos;
                }
            }
            return ConditionResult.TRUE;
        }
    }
}

