/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.Comparator;
import java.util.List;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.MatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;

abstract class AbstractMatchingRuleImpl
implements MatchingRuleImpl {
    private static final Assertion UNDEFINED_ASSERTION = new Assertion(){

        @Override
        public ConditionResult matches(ByteSequence attributeValue) {
            return ConditionResult.UNDEFINED;
        }
    };
    private static final Comparator<ByteSequence> DEFAULT_COMPARATOR = new Comparator<ByteSequence>(){

        @Override
        public int compare(ByteSequence o1, ByteSequence o2) {
            return o1.compareTo(o2);
        }
    };

    AbstractMatchingRuleImpl() {
    }

    @Override
    public Comparator<ByteSequence> comparator(Schema schema) {
        return DEFAULT_COMPARATOR;
    }

    @Override
    public Assertion getAssertion(Schema schema, ByteSequence value) throws DecodeException {
        return new DefaultEqualityAssertion(this.normalizeAttributeValue(schema, value));
    }

    @Override
    public Assertion getAssertion(Schema schema, ByteSequence subInitial, List<? extends ByteSequence> subAnyElements, ByteSequence subFinal) throws DecodeException {
        return UNDEFINED_ASSERTION;
    }

    @Override
    public Assertion getGreaterOrEqualAssertion(Schema schema, ByteSequence value) throws DecodeException {
        return UNDEFINED_ASSERTION;
    }

    @Override
    public Assertion getLessOrEqualAssertion(Schema schema, ByteSequence value) throws DecodeException {
        return UNDEFINED_ASSERTION;
    }

    static class DefaultEqualityAssertion
    implements Assertion {
        ByteSequence normalizedAssertionValue;

        protected DefaultEqualityAssertion(ByteSequence normalizedAssertionValue) {
            this.normalizedAssertionValue = normalizedAssertionValue;
        }

        @Override
        public ConditionResult matches(ByteSequence attributeValue) {
            return this.normalizedAssertionValue.equals(attributeValue) ? ConditionResult.TRUE : ConditionResult.FALSE;
        }
    }
}

