/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.responses;

import com.forgerock.opendj.util.Iterables;
import java.util.Collection;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.AttributeParser;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Function;
import org.forgerock.opendj.ldap.responses.AbstractUnmodifiableResponseImpl;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;

class UnmodifiableSearchResultEntryImpl
extends AbstractUnmodifiableResponseImpl<SearchResultEntry>
implements SearchResultEntry {
    private static final Function<Attribute, Attribute, Void> UNMODIFIABLE_ATTRIBUTE_FUNCTION = new Function<Attribute, Attribute, Void>(){

        @Override
        public Attribute apply(Attribute value, Void p) {
            return Attributes.unmodifiableAttribute(value);
        }
    };

    UnmodifiableSearchResultEntryImpl(SearchResultEntry impl) {
        super(impl);
    }

    @Override
    public boolean addAttribute(Attribute attribute) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAttribute(Attribute attribute, Collection<? super ByteString> duplicateValues) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResultEntry addAttribute(String attributeDescription, Object ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResultEntry clearAttributes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAttribute(Attribute attribute, Collection<? super ByteString> missingValues) {
        return ((SearchResultEntry)this.impl).containsAttribute(attribute, missingValues);
    }

    @Override
    public boolean containsAttribute(String attributeDescription, Object ... values) {
        return ((SearchResultEntry)this.impl).containsAttribute(attributeDescription, values);
    }

    @Override
    public Iterable<Attribute> getAllAttributes() {
        return Iterables.unmodifiableIterable(Iterables.transformedIterable(((SearchResultEntry)this.impl).getAllAttributes(), UNMODIFIABLE_ATTRIBUTE_FUNCTION));
    }

    @Override
    public Iterable<Attribute> getAllAttributes(AttributeDescription attributeDescription) {
        return Iterables.unmodifiableIterable(Iterables.transformedIterable(((SearchResultEntry)this.impl).getAllAttributes(attributeDescription), UNMODIFIABLE_ATTRIBUTE_FUNCTION));
    }

    @Override
    public Iterable<Attribute> getAllAttributes(String attributeDescription) {
        return Iterables.unmodifiableIterable(Iterables.transformedIterable(((SearchResultEntry)this.impl).getAllAttributes(attributeDescription), UNMODIFIABLE_ATTRIBUTE_FUNCTION));
    }

    @Override
    public Attribute getAttribute(AttributeDescription attributeDescription) {
        Attribute attribute = ((SearchResultEntry)this.impl).getAttribute(attributeDescription);
        if (attribute != null) {
            return Attributes.unmodifiableAttribute(attribute);
        }
        return null;
    }

    @Override
    public Attribute getAttribute(String attributeDescription) {
        Attribute attribute = ((SearchResultEntry)this.impl).getAttribute(attributeDescription);
        if (attribute != null) {
            return Attributes.unmodifiableAttribute(attribute);
        }
        return null;
    }

    @Override
    public int getAttributeCount() {
        return ((SearchResultEntry)this.impl).getAttributeCount();
    }

    @Override
    public DN getName() {
        return ((SearchResultEntry)this.impl).getName();
    }

    @Override
    public AttributeParser parseAttribute(AttributeDescription attributeDescription) {
        return ((SearchResultEntry)this.impl).parseAttribute(attributeDescription);
    }

    @Override
    public AttributeParser parseAttribute(String attributeDescription) {
        return ((SearchResultEntry)this.impl).parseAttribute(attributeDescription);
    }

    @Override
    public boolean removeAttribute(Attribute attribute, Collection<? super ByteString> missingValues) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAttribute(AttributeDescription attributeDescription) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResultEntry removeAttribute(String attributeDescription, Object ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean replaceAttribute(Attribute attribute) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResultEntry replaceAttribute(String attributeDescription, Object ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResultEntry setName(DN dn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SearchResultEntry setName(String dn) {
        throw new UnsupportedOperationException();
    }
}

