/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.responses;

import com.forgerock.opendj.util.StaticUtils;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.responses.AbstractResponseImpl;
import org.forgerock.opendj.ldap.responses.IntermediateResponse;

public abstract class AbstractIntermediateResponse<S extends IntermediateResponse>
extends AbstractResponseImpl<S>
implements IntermediateResponse {
    protected AbstractIntermediateResponse() {
    }

    protected AbstractIntermediateResponse(IntermediateResponse intermediateResponse) {
        super(intermediateResponse);
    }

    @Override
    public abstract String getOID();

    @Override
    public abstract ByteString getValue();

    @Override
    public abstract boolean hasValue();

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IntermediateResponse(responseName=");
        builder.append(this.getOID() == null ? "" : this.getOID());
        if (this.hasValue()) {
            builder.append(", responseValue=");
            StaticUtils.toHexPlusAscii(this.getValue(), builder, 4);
        }
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    @Override
    final S getThis() {
        return (S)this;
    }
}

