/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.Validator;
import javax.net.ssl.SSLContext;
import javax.security.auth.Subject;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entries;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AbandonRequestImpl;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.AddRequestImpl;
import org.forgerock.opendj.ldap.requests.AnonymousSASLBindRequest;
import org.forgerock.opendj.ldap.requests.AnonymousSASLBindRequestImpl;
import org.forgerock.opendj.ldap.requests.CRAMMD5SASLBindRequest;
import org.forgerock.opendj.ldap.requests.CRAMMD5SASLBindRequestImpl;
import org.forgerock.opendj.ldap.requests.CancelExtendedRequest;
import org.forgerock.opendj.ldap.requests.CancelExtendedRequestImpl;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.CompareRequestImpl;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequestImpl;
import org.forgerock.opendj.ldap.requests.DigestMD5SASLBindRequest;
import org.forgerock.opendj.ldap.requests.DigestMD5SASLBindRequestImpl;
import org.forgerock.opendj.ldap.requests.ExternalSASLBindRequest;
import org.forgerock.opendj.ldap.requests.ExternalSASLBindRequestImpl;
import org.forgerock.opendj.ldap.requests.GSSAPISASLBindRequest;
import org.forgerock.opendj.ldap.requests.GSSAPISASLBindRequestImpl;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequestImpl;
import org.forgerock.opendj.ldap.requests.GenericExtendedRequest;
import org.forgerock.opendj.ldap.requests.GenericExtendedRequestImpl;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequestImpl;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequestImpl;
import org.forgerock.opendj.ldap.requests.PasswordModifyExtendedRequest;
import org.forgerock.opendj.ldap.requests.PasswordModifyExtendedRequestImpl;
import org.forgerock.opendj.ldap.requests.PlainSASLBindRequest;
import org.forgerock.opendj.ldap.requests.PlainSASLBindRequestImpl;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.SearchRequestImpl;
import org.forgerock.opendj.ldap.requests.SimpleBindRequest;
import org.forgerock.opendj.ldap.requests.SimpleBindRequestImpl;
import org.forgerock.opendj.ldap.requests.StartTLSExtendedRequest;
import org.forgerock.opendj.ldap.requests.StartTLSExtendedRequestImpl;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiableAbandonRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiableAddRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiableAnonymousSASLBindRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiableCRAMMD5SASLBindRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiableCancelExtendedRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiableCompareRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiableDeleteRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiableDigestMD5SASLBindRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiableExternalSASLBindRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiableGSSAPISASLBindRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiableGenericBindRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiableGenericExtendedRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiableModifyDNRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiableModifyRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiablePasswordModifyExtendedRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiablePlainSASLBindRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiableSearchRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiableSimpleBindRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiableStartTLSExtendedRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiableUnbindRequestImpl;
import org.forgerock.opendj.ldap.requests.UnmodifiableWhoAmIExtendedRequestImpl;
import org.forgerock.opendj.ldap.requests.WhoAmIExtendedRequest;
import org.forgerock.opendj.ldap.requests.WhoAmIExtendedRequestImpl;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.LDIFChangeRecordReader;

public final class Requests {
    public static AbandonRequest copyOfAbandonRequest(AbandonRequest request) {
        return new AbandonRequestImpl(request);
    }

    public static AddRequest copyOfAddRequest(AddRequest request) {
        return new AddRequestImpl(request);
    }

    public static AnonymousSASLBindRequest copyOfAnonymousSASLBindRequest(AnonymousSASLBindRequest request) {
        return new AnonymousSASLBindRequestImpl(request);
    }

    public static CancelExtendedRequest copyOfCancelExtendedRequest(CancelExtendedRequest request) {
        return new CancelExtendedRequestImpl(request);
    }

    public static CompareRequest copyOfCompareRequest(CompareRequest request) {
        return new CompareRequestImpl(request);
    }

    public static CRAMMD5SASLBindRequest copyOfCRAMMD5SASLBindRequest(CRAMMD5SASLBindRequest request) {
        return new CRAMMD5SASLBindRequestImpl(request);
    }

    public static DeleteRequest copyOfDeleteRequest(DeleteRequest request) {
        return new DeleteRequestImpl(request);
    }

    public static DigestMD5SASLBindRequest copyOfDigestMD5SASLBindRequest(DigestMD5SASLBindRequest request) {
        return new DigestMD5SASLBindRequestImpl(request);
    }

    public static ExternalSASLBindRequest copyOfExternalSASLBindRequest(ExternalSASLBindRequest request) {
        return new ExternalSASLBindRequestImpl(request);
    }

    public static GenericBindRequest copyOfGenericBindRequest(GenericBindRequest request) {
        return new GenericBindRequestImpl(request);
    }

    public static GenericExtendedRequest copyOfGenericExtendedRequest(GenericExtendedRequest request) {
        return new GenericExtendedRequestImpl(request);
    }

    public static GSSAPISASLBindRequest copyOfGSSAPISASLBindRequest(GSSAPISASLBindRequest request) {
        return new GSSAPISASLBindRequestImpl(request);
    }

    public static ModifyDNRequest copyOfModifyDNRequest(ModifyDNRequest request) {
        return new ModifyDNRequestImpl(request);
    }

    public static ModifyRequest copyOfModifyRequest(ModifyRequest request) {
        return new ModifyRequestImpl(request);
    }

    public static PasswordModifyExtendedRequest copyOfPasswordModifyExtendedRequest(PasswordModifyExtendedRequest request) {
        return new PasswordModifyExtendedRequestImpl(request);
    }

    public static PlainSASLBindRequest copyOfPlainSASLBindRequest(PlainSASLBindRequest request) {
        return new PlainSASLBindRequestImpl(request);
    }

    public static SearchRequest copyOfSearchRequest(SearchRequest request) {
        return new SearchRequestImpl(request);
    }

    public static SimpleBindRequest copyOfSimpleBindRequest(SimpleBindRequest request) {
        return new SimpleBindRequestImpl(request);
    }

    public static StartTLSExtendedRequest copyOfStartTLSExtendedRequest(StartTLSExtendedRequest request) {
        return new StartTLSExtendedRequestImpl(request);
    }

    public static UnbindRequest copyOfUnbindRequest(UnbindRequest request) {
        return new UnbindRequestImpl(request);
    }

    public static WhoAmIExtendedRequest copyOfWhoAmIExtendedRequest(WhoAmIExtendedRequest request) {
        return new WhoAmIExtendedRequestImpl(request);
    }

    public static AbandonRequest newAbandonRequest(int requestID) {
        return new AbandonRequestImpl(requestID);
    }

    public static AddRequest newAddRequest(DN name) {
        Entry entry = new LinkedHashMapEntry().setName(name);
        return new AddRequestImpl(entry);
    }

    public static AddRequest newAddRequest(Entry entry) {
        Validator.ensureNotNull(entry);
        return new AddRequestImpl(entry);
    }

    public static AddRequest newAddRequest(String name) {
        Entry entry = new LinkedHashMapEntry().setName(name);
        return new AddRequestImpl(entry);
    }

    public static AddRequest newAddRequest(String ... ldifLines) {
        ChangeRecord record = LDIFChangeRecordReader.valueOfLDIFChangeRecord(ldifLines);
        if (record instanceof AddRequest) {
            return (AddRequest)record;
        }
        LocalizableMessage message = CoreMessages.WARN_READ_LDIF_RECORD_CHANGE_RECORD_WRONG_TYPE.get((Object)"add");
        throw new LocalizedIllegalArgumentException(message);
    }

    public static AnonymousSASLBindRequest newAnonymousSASLBindRequest(String traceString) {
        return new AnonymousSASLBindRequestImpl(traceString);
    }

    public static CancelExtendedRequest newCancelExtendedRequest(int requestID) {
        return new CancelExtendedRequestImpl(requestID);
    }

    public static ChangeRecord newChangeRecord(String ... ldifLines) {
        return LDIFChangeRecordReader.valueOfLDIFChangeRecord(ldifLines);
    }

    public static CompareRequest newCompareRequest(DN name, AttributeDescription attributeDescription, Object assertionValue) {
        Validator.ensureNotNull((Object)name, (Object)attributeDescription, assertionValue);
        return new CompareRequestImpl(name, attributeDescription, ByteString.valueOf(assertionValue));
    }

    public static CompareRequest newCompareRequest(String name, String attributeDescription, Object assertionValue) {
        Validator.ensureNotNull((Object)name, (Object)attributeDescription, assertionValue);
        return new CompareRequestImpl(DN.valueOf(name), AttributeDescription.valueOf(attributeDescription), ByteString.valueOf(assertionValue));
    }

    public static CRAMMD5SASLBindRequest newCRAMMD5SASLBindRequest(String authenticationID, byte[] password) {
        return new CRAMMD5SASLBindRequestImpl(authenticationID, password);
    }

    public static CRAMMD5SASLBindRequest newCRAMMD5SASLBindRequest(String authenticationID, char[] password) {
        return new CRAMMD5SASLBindRequestImpl(authenticationID, StaticUtils.getBytes(password));
    }

    public static DeleteRequest newDeleteRequest(DN name) {
        Validator.ensureNotNull(name);
        return new DeleteRequestImpl(name);
    }

    public static DeleteRequest newDeleteRequest(String name) {
        Validator.ensureNotNull(name);
        return new DeleteRequestImpl(DN.valueOf(name));
    }

    public static DigestMD5SASLBindRequest newDigestMD5SASLBindRequest(String authenticationID, byte[] password) {
        return new DigestMD5SASLBindRequestImpl(authenticationID, password);
    }

    public static DigestMD5SASLBindRequest newDigestMD5SASLBindRequest(String authenticationID, char[] password) {
        return new DigestMD5SASLBindRequestImpl(authenticationID, StaticUtils.getBytes(password));
    }

    public static ExternalSASLBindRequest newExternalSASLBindRequest() {
        return new ExternalSASLBindRequestImpl();
    }

    public static GenericBindRequest newGenericBindRequest(byte authenticationType, byte[] authenticationValue) {
        Validator.ensureNotNull(authenticationValue);
        return new GenericBindRequestImpl("", authenticationType, authenticationValue);
    }

    public static GenericBindRequest newGenericBindRequest(String name, byte authenticationType, byte[] authenticationValue) {
        Validator.ensureNotNull((Object)name, (Object)authenticationValue);
        return new GenericBindRequestImpl(name, authenticationType, authenticationValue);
    }

    public static GenericExtendedRequest newGenericExtendedRequest(String requestName) {
        Validator.ensureNotNull(requestName);
        return new GenericExtendedRequestImpl(requestName);
    }

    public static GenericExtendedRequest newGenericExtendedRequest(String requestName, Object requestValue) {
        Validator.ensureNotNull(requestName);
        return new GenericExtendedRequestImpl(requestName).setValue(requestValue);
    }

    public static GSSAPISASLBindRequest newGSSAPISASLBindRequest(String authenticationID, byte[] password) {
        return new GSSAPISASLBindRequestImpl(authenticationID, password);
    }

    public static GSSAPISASLBindRequest newGSSAPISASLBindRequest(String authenticationID, char[] password) {
        return new GSSAPISASLBindRequestImpl(authenticationID, StaticUtils.getBytes(password));
    }

    public static GSSAPISASLBindRequest newGSSAPISASLBindRequest(Subject subject) {
        return new GSSAPISASLBindRequestImpl(subject);
    }

    public static ModifyDNRequest newModifyDNRequest(DN name, RDN newRDN) {
        Validator.ensureNotNull((Object)name, (Object)newRDN);
        return new ModifyDNRequestImpl(name, newRDN);
    }

    public static ModifyDNRequest newModifyDNRequest(String name, String newRDN) {
        Validator.ensureNotNull((Object)name, (Object)newRDN);
        return new ModifyDNRequestImpl(DN.valueOf(name), RDN.valueOf(newRDN));
    }

    public static ModifyRequest newModifyRequest(DN name) {
        Validator.ensureNotNull(name);
        return new ModifyRequestImpl(name);
    }

    public static final ModifyRequest newModifyRequest(Entry fromEntry, Entry toEntry) {
        return Entries.diffEntries(fromEntry, toEntry);
    }

    public static ModifyRequest newModifyRequest(String name) {
        Validator.ensureNotNull(name);
        return new ModifyRequestImpl(DN.valueOf(name));
    }

    public static ModifyRequest newModifyRequest(String ... ldifLines) {
        ChangeRecord record = LDIFChangeRecordReader.valueOfLDIFChangeRecord(ldifLines);
        if (record instanceof ModifyRequest) {
            return (ModifyRequest)record;
        }
        LocalizableMessage message = CoreMessages.WARN_READ_LDIF_RECORD_CHANGE_RECORD_WRONG_TYPE.get((Object)"modify");
        throw new LocalizedIllegalArgumentException(message);
    }

    public static PasswordModifyExtendedRequest newPasswordModifyExtendedRequest() {
        return new PasswordModifyExtendedRequestImpl();
    }

    public static PlainSASLBindRequest newPlainSASLBindRequest(String authenticationID, byte[] password) {
        return new PlainSASLBindRequestImpl(authenticationID, password);
    }

    public static PlainSASLBindRequest newPlainSASLBindRequest(String authenticationID, char[] password) {
        return new PlainSASLBindRequestImpl(authenticationID, StaticUtils.getBytes(password));
    }

    public static SearchRequest newSearchRequest(DN name, SearchScope scope, Filter filter, String ... attributeDescriptions) {
        Validator.ensureNotNull((Object)name, (Object)scope, (Object)filter);
        SearchRequestImpl request = new SearchRequestImpl(name, scope, filter);
        for (String attributeDescription : attributeDescriptions) {
            request.addAttribute(attributeDescription);
        }
        return request;
    }

    public static SearchRequest newSearchRequest(String name, SearchScope scope, String filter, String ... attributeDescriptions) {
        Validator.ensureNotNull((Object)name, (Object)scope, (Object)filter);
        SearchRequestImpl request = new SearchRequestImpl(DN.valueOf(name), scope, Filter.valueOf(filter));
        for (String attributeDescription : attributeDescriptions) {
            request.addAttribute(attributeDescription);
        }
        return request;
    }

    public static SimpleBindRequest newSimpleBindRequest() {
        return new SimpleBindRequestImpl("", StaticUtils.EMPTY_BYTES);
    }

    public static SimpleBindRequest newSimpleBindRequest(String name, byte[] password) {
        Validator.ensureNotNull((Object)name, (Object)password);
        return new SimpleBindRequestImpl(name, password);
    }

    public static SimpleBindRequest newSimpleBindRequest(String name, char[] password) {
        Validator.ensureNotNull((Object)name, (Object)password);
        return new SimpleBindRequestImpl(name, StaticUtils.getBytes(password));
    }

    public static StartTLSExtendedRequest newStartTLSExtendedRequest(SSLContext sslContext) {
        return new StartTLSExtendedRequestImpl(sslContext);
    }

    public static UnbindRequest newUnbindRequest() {
        return new UnbindRequestImpl();
    }

    public static WhoAmIExtendedRequest newWhoAmIExtendedRequest() {
        return new WhoAmIExtendedRequestImpl();
    }

    public static AbandonRequest unmodifiableAbandonRequest(AbandonRequest request) {
        if (request instanceof UnmodifiableAbandonRequestImpl) {
            return request;
        }
        return new UnmodifiableAbandonRequestImpl(request);
    }

    public static AddRequest unmodifiableAddRequest(AddRequest request) {
        if (request instanceof UnmodifiableAddRequestImpl) {
            return request;
        }
        return new UnmodifiableAddRequestImpl(request);
    }

    public static AnonymousSASLBindRequest unmodifiableAnonymousSASLBindRequest(AnonymousSASLBindRequest request) {
        if (request instanceof UnmodifiableAnonymousSASLBindRequestImpl) {
            return request;
        }
        return new UnmodifiableAnonymousSASLBindRequestImpl(request);
    }

    public static CancelExtendedRequest unmodifiableCancelExtendedRequest(CancelExtendedRequest request) {
        if (request instanceof UnmodifiableCancelExtendedRequestImpl) {
            return request;
        }
        return new UnmodifiableCancelExtendedRequestImpl(request);
    }

    public static CompareRequest unmodifiableCompareRequest(CompareRequest request) {
        if (request instanceof UnmodifiableCompareRequestImpl) {
            return request;
        }
        return new UnmodifiableCompareRequestImpl(request);
    }

    public static CRAMMD5SASLBindRequest unmodifiableCRAMMD5SASLBindRequest(CRAMMD5SASLBindRequest request) {
        if (request instanceof UnmodifiableCRAMMD5SASLBindRequestImpl) {
            return request;
        }
        return new UnmodifiableCRAMMD5SASLBindRequestImpl(request);
    }

    public static DeleteRequest unmodifiableDeleteRequest(DeleteRequest request) {
        if (request instanceof UnmodifiableDeleteRequestImpl) {
            return request;
        }
        return new UnmodifiableDeleteRequestImpl(request);
    }

    public static DigestMD5SASLBindRequest unmodifiableDigestMD5SASLBindRequest(DigestMD5SASLBindRequest request) {
        if (request instanceof UnmodifiableDigestMD5SASLBindRequestImpl) {
            return request;
        }
        return new UnmodifiableDigestMD5SASLBindRequestImpl(request);
    }

    public static ExternalSASLBindRequest unmodifiableExternalSASLBindRequest(ExternalSASLBindRequest request) {
        if (request instanceof UnmodifiableExternalSASLBindRequestImpl) {
            return request;
        }
        return new UnmodifiableExternalSASLBindRequestImpl(request);
    }

    public static GenericBindRequest unmodifiableGenericBindRequest(GenericBindRequest request) {
        if (request instanceof UnmodifiableGenericBindRequestImpl) {
            return request;
        }
        return new UnmodifiableGenericBindRequestImpl(request);
    }

    public static GenericExtendedRequest unmodifiableGenericExtendedRequest(GenericExtendedRequest request) {
        if (request instanceof UnmodifiableGenericExtendedRequestImpl) {
            return request;
        }
        return new UnmodifiableGenericExtendedRequestImpl(request);
    }

    public static GSSAPISASLBindRequest unmodifiableGSSAPISASLBindRequest(GSSAPISASLBindRequest request) {
        if (request instanceof UnmodifiableGSSAPISASLBindRequestImpl) {
            return request;
        }
        return new UnmodifiableGSSAPISASLBindRequestImpl(request);
    }

    public static ModifyDNRequest unmodifiableModifyDNRequest(ModifyDNRequest request) {
        if (request instanceof UnmodifiableModifyDNRequestImpl) {
            return request;
        }
        return new UnmodifiableModifyDNRequestImpl(request);
    }

    public static ModifyRequest unmodifiableModifyRequest(ModifyRequest request) {
        if (request instanceof UnmodifiableModifyRequestImpl) {
            return request;
        }
        return new UnmodifiableModifyRequestImpl(request);
    }

    public static PasswordModifyExtendedRequest unmodifiablePasswordModifyExtendedRequest(PasswordModifyExtendedRequest request) {
        if (request instanceof UnmodifiablePasswordModifyExtendedRequestImpl) {
            return request;
        }
        return new UnmodifiablePasswordModifyExtendedRequestImpl(request);
    }

    public static PlainSASLBindRequest unmodifiablePlainSASLBindRequest(PlainSASLBindRequest request) {
        if (request instanceof UnmodifiablePlainSASLBindRequestImpl) {
            return request;
        }
        return new UnmodifiablePlainSASLBindRequestImpl(request);
    }

    public static SearchRequest unmodifiableSearchRequest(SearchRequest request) {
        if (request instanceof UnmodifiableSearchRequestImpl) {
            return request;
        }
        return new UnmodifiableSearchRequestImpl(request);
    }

    public static SimpleBindRequest unmodifiableSimpleBindRequest(SimpleBindRequest request) {
        if (request instanceof UnmodifiableSimpleBindRequestImpl) {
            return request;
        }
        return new UnmodifiableSimpleBindRequestImpl(request);
    }

    public static StartTLSExtendedRequest unmodifiableStartTLSExtendedRequest(StartTLSExtendedRequest request) {
        if (request instanceof UnmodifiableStartTLSExtendedRequestImpl) {
            return request;
        }
        return new UnmodifiableStartTLSExtendedRequestImpl(request);
    }

    public static UnbindRequest unmodifiableUnbindRequest(UnbindRequest request) {
        if (request instanceof UnmodifiableUnbindRequestImpl) {
            return request;
        }
        return new UnmodifiableUnbindRequestImpl(request);
    }

    public static WhoAmIExtendedRequest unmodifiableWhoAmIExtendedRequest(WhoAmIExtendedRequest request) {
        if (request instanceof UnmodifiableWhoAmIExtendedRequestImpl) {
            return request;
        }
        return new UnmodifiableWhoAmIExtendedRequestImpl(request);
    }

    private Requests() {
    }
}

