/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.asn1.ASN1;
import org.forgerock.opendj.asn1.ASN1Reader;
import org.forgerock.opendj.asn1.ASN1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.requests.AbstractExtendedRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequestDecoder;
import org.forgerock.opendj.ldap.requests.PasswordModifyExtendedRequest;
import org.forgerock.opendj.ldap.responses.AbstractExtendedResultDecoder;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.ExtendedResultDecoder;
import org.forgerock.opendj.ldap.responses.PasswordModifyExtendedResult;
import org.forgerock.opendj.ldap.responses.Responses;

final class PasswordModifyExtendedRequestImpl
extends AbstractExtendedRequest<PasswordModifyExtendedRequest, PasswordModifyExtendedResult>
implements PasswordModifyExtendedRequest {
    private static final ExtendedResultDecoder<PasswordModifyExtendedResult> RESULT_DECODER = new ResultDecoder();
    private static final byte TYPE_PASSWORD_MODIFY_GENERATED_PASSWORD = -128;
    private static final byte TYPE_PASSWORD_MODIFY_NEW_PASSWORD = -126;
    private static final byte TYPE_PASSWORD_MODIFY_OLD_PASSWORD = -127;
    private static final byte TYPE_PASSWORD_MODIFY_USER_ID = -128;
    private byte[] newPassword = null;
    private byte[] oldPassword = null;
    private ByteString userIdentity = null;

    PasswordModifyExtendedRequestImpl() {
    }

    PasswordModifyExtendedRequestImpl(PasswordModifyExtendedRequest passwordModifyExtendedRequest) {
        super(passwordModifyExtendedRequest);
        this.userIdentity = passwordModifyExtendedRequest.getUserIdentity();
        this.oldPassword = passwordModifyExtendedRequest.getOldPassword();
        this.newPassword = passwordModifyExtendedRequest.getNewPassword();
    }

    @Override
    public byte[] getNewPassword() {
        return this.newPassword;
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.4203.1.11.1";
    }

    @Override
    public byte[] getOldPassword() {
        return this.oldPassword;
    }

    @Override
    public ExtendedResultDecoder<PasswordModifyExtendedResult> getResultDecoder() {
        return RESULT_DECODER;
    }

    @Override
    public ByteString getUserIdentity() {
        return this.userIdentity;
    }

    @Override
    public String getUserIdentityAsString() {
        return this.userIdentity != null ? this.userIdentity.toString() : null;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            if (this.userIdentity != null) {
                writer.writeOctetString((byte)-128, this.userIdentity);
            }
            if (this.oldPassword != null) {
                writer.writeOctetString((byte)-127, this.oldPassword);
            }
            if (this.newPassword != null) {
                writer.writeOctetString((byte)-126, this.newPassword);
            }
            writer.writeEndSequence();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return buffer.toByteString();
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public PasswordModifyExtendedRequest setNewPassword(byte[] newPassword) {
        this.newPassword = newPassword;
        return this;
    }

    @Override
    public PasswordModifyExtendedRequest setNewPassword(char[] newPassword) {
        this.newPassword = newPassword != null ? StaticUtils.getBytes(newPassword) : null;
        return this;
    }

    @Override
    public PasswordModifyExtendedRequest setOldPassword(byte[] oldPassword) {
        this.oldPassword = oldPassword;
        return this;
    }

    @Override
    public PasswordModifyExtendedRequest setOldPassword(char[] oldPassword) {
        this.oldPassword = oldPassword != null ? StaticUtils.getBytes(oldPassword) : null;
        return this;
    }

    @Override
    public PasswordModifyExtendedRequest setUserIdentity(Object userIdentity) {
        this.userIdentity = userIdentity != null ? ByteString.valueOf(userIdentity) : null;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PasswordModifyExtendedRequest(requestName=");
        builder.append(this.getOID());
        builder.append(", userIdentity=");
        builder.append(this.userIdentity);
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    private static final class ResultDecoder
    extends AbstractExtendedResultDecoder<PasswordModifyExtendedResult> {
        private ResultDecoder() {
        }

        @Override
        public PasswordModifyExtendedResult decodeExtendedResult(ExtendedResult result, DecodeOptions options) throws DecodeException {
            if (result instanceof PasswordModifyExtendedResult) {
                return (PasswordModifyExtendedResult)result;
            }
            ResultCode resultCode = result.getResultCode();
            PasswordModifyExtendedResult newResult = Responses.newPasswordModifyExtendedResult(resultCode).setMatchedDN(result.getMatchedDN()).setDiagnosticMessage(result.getDiagnosticMessage());
            ByteString responseValue = result.getValue();
            if (resultCode == ResultCode.SUCCESS && responseValue != null) {
                try {
                    ASN1Reader asn1Reader = ASN1.getReader(responseValue);
                    asn1Reader.readStartSequence();
                    if (asn1Reader.peekType() == -128) {
                        newResult.setGeneratedPassword(asn1Reader.readOctetString().toByteArray());
                    }
                    asn1Reader.readEndSequence();
                }
                catch (IOException e) {
                    LocalizableMessage message = CoreMessages.ERR_EXTOP_PASSMOD_CANNOT_DECODE_REQUEST.get((Object)StaticUtils.getExceptionMessage(e));
                    throw DecodeException.error(message, e);
                }
            }
            for (Control control : result.getControls()) {
                newResult.addControl(control);
            }
            return newResult;
        }

        @Override
        public PasswordModifyExtendedResult newExtendedErrorResult(ResultCode resultCode, String matchedDN, String diagnosticMessage) {
            return Responses.newPasswordModifyExtendedResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
        }
    }

    static final class RequestDecoder
    implements ExtendedRequestDecoder<PasswordModifyExtendedRequest, PasswordModifyExtendedResult> {
        RequestDecoder() {
        }

        @Override
        public PasswordModifyExtendedRequest decodeExtendedRequest(ExtendedRequest<?> request, DecodeOptions options) throws DecodeException {
            PasswordModifyExtendedRequestImpl newRequest = new PasswordModifyExtendedRequestImpl();
            if (request.getValue() != null) {
                try {
                    ASN1Reader reader = ASN1.getReader(request.getValue());
                    reader.readStartSequence();
                    if (reader.hasNextElement() && reader.peekType() == -128) {
                        newRequest.setUserIdentity(reader.readOctetStringAsString());
                    }
                    if (reader.hasNextElement() && reader.peekType() == -127) {
                        newRequest.setOldPassword(reader.readOctetString().toByteArray());
                    }
                    if (reader.hasNextElement() && reader.peekType() == -126) {
                        newRequest.setNewPassword(reader.readOctetString().toByteArray());
                    }
                    reader.readEndSequence();
                }
                catch (IOException e) {
                    LocalizableMessage message = CoreMessages.ERR_EXTOP_PASSMOD_CANNOT_DECODE_REQUEST.get((Object)StaticUtils.getExceptionMessage(e));
                    throw DecodeException.error(message, e);
                }
            }
            for (Control control : request.getControls()) {
                newRequest.addControl(control);
            }
            return newRequest;
        }
    }
}

