/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.util.Validator;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.requests.AbstractRequestImpl;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldif.ChangeRecordVisitor;

final class ModifyDNRequestImpl
extends AbstractRequestImpl<ModifyDNRequest>
implements ModifyDNRequest {
    private boolean deleteOldRDN = false;
    private DN name;
    private RDN newRDN;
    private DN newSuperior = null;

    ModifyDNRequestImpl(DN name, RDN newRDN) {
        this.name = name;
        this.newRDN = newRDN;
    }

    ModifyDNRequestImpl(ModifyDNRequest modifyDNRequest) {
        super(modifyDNRequest);
        this.name = modifyDNRequest.getName();
        this.newSuperior = modifyDNRequest.getNewSuperior();
        this.newRDN = modifyDNRequest.getNewRDN();
        this.deleteOldRDN = modifyDNRequest.isDeleteOldRDN();
    }

    @Override
    public <R, P> R accept(ChangeRecordVisitor<R, P> v, P p) {
        return v.visitChangeRecord(p, this);
    }

    @Override
    public DN getName() {
        return this.name;
    }

    @Override
    public RDN getNewRDN() {
        return this.newRDN;
    }

    @Override
    public DN getNewSuperior() {
        return this.newSuperior;
    }

    @Override
    public boolean isDeleteOldRDN() {
        return this.deleteOldRDN;
    }

    @Override
    public ModifyDNRequestImpl setDeleteOldRDN(boolean deleteOldRDN) {
        this.deleteOldRDN = deleteOldRDN;
        return this;
    }

    @Override
    public ModifyDNRequest setName(DN dn) {
        Validator.ensureNotNull(dn);
        this.name = dn;
        return this;
    }

    @Override
    public ModifyDNRequest setName(String dn) {
        Validator.ensureNotNull(dn);
        this.name = DN.valueOf(dn);
        return this;
    }

    @Override
    public ModifyDNRequest setNewRDN(RDN rdn) {
        Validator.ensureNotNull(rdn);
        this.newRDN = rdn;
        return this;
    }

    @Override
    public ModifyDNRequest setNewRDN(String rdn) {
        Validator.ensureNotNull(rdn);
        this.newRDN = RDN.valueOf(rdn);
        return this;
    }

    @Override
    public ModifyDNRequest setNewSuperior(DN dn) {
        this.newSuperior = dn;
        return this;
    }

    @Override
    public ModifyDNRequest setNewSuperior(String dn) {
        this.newSuperior = dn != null ? DN.valueOf(dn) : null;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ModifyDNRequest(name=");
        builder.append(this.getName());
        builder.append(", newRDN=");
        builder.append(this.getNewRDN());
        builder.append(", deleteOldRDN=");
        builder.append(this.isDeleteOldRDN());
        builder.append(", newSuperior=");
        builder.append(String.valueOf(this.getNewSuperior()));
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    @Override
    ModifyDNRequest getThis() {
        return this;
    }
}

