/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.Validator;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.requests.AbstractBindRequest;
import org.forgerock.opendj.ldap.requests.BindClient;
import org.forgerock.opendj.ldap.requests.BindClientImpl;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;

final class GenericBindRequestImpl
extends AbstractBindRequest<GenericBindRequest>
implements GenericBindRequest {
    private byte authenticationType;
    private byte[] authenticationValue;
    private final BindClient bindClient;
    private String name;

    GenericBindRequestImpl(GenericBindRequest genericBindRequest) {
        super(genericBindRequest);
        this.name = genericBindRequest.getName();
        this.authenticationType = genericBindRequest.getAuthenticationType();
        this.authenticationValue = StaticUtils.copyOfBytes(genericBindRequest.getAuthenticationValue());
        this.bindClient = null;
    }

    GenericBindRequestImpl(String name, byte authenticationType, byte[] authenticationValue) {
        this.name = name;
        this.authenticationType = authenticationType;
        this.authenticationValue = authenticationValue;
        this.bindClient = null;
    }

    GenericBindRequestImpl(String name, byte authenticationType, byte[] authenticationValue, BindClient bindClient) {
        this.name = name;
        this.authenticationType = authenticationType;
        this.authenticationValue = authenticationValue;
        this.bindClient = bindClient;
    }

    @Override
    public BindClient createBindClient(String serverName) throws ErrorResultException {
        if (this.bindClient == null) {
            return new BindClientImpl(this).setNextAuthenticationValue(this.authenticationValue);
        }
        return this.bindClient;
    }

    @Override
    public byte getAuthenticationType() {
        return this.authenticationType;
    }

    @Override
    public byte[] getAuthenticationValue() {
        return this.authenticationValue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public GenericBindRequest setAuthenticationType(byte type) {
        this.authenticationType = type;
        return this;
    }

    @Override
    public GenericBindRequest setAuthenticationValue(byte[] bytes) {
        Validator.ensureNotNull(bytes);
        this.authenticationValue = bytes;
        return this;
    }

    @Override
    public GenericBindRequest setName(String name) {
        Validator.ensureNotNull(name);
        this.name = name;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GenericBindRequest(name=");
        builder.append(this.getName());
        builder.append(", authenticationType=");
        builder.append(this.getAuthenticationType());
        builder.append(", authenticationValue=");
        builder.append(ByteString.wrap(this.getAuthenticationValue()));
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }
}

