/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.util.Validator;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.requests.Request;

abstract class AbstractRequestImpl<R extends Request>
implements Request {
    private final List<Control> controls = new LinkedList<Control>();

    static Control getControl(List<Control> controls, String oid) {
        if (!controls.isEmpty()) {
            for (Control control : controls) {
                if (!control.getOID().equals(oid)) continue;
                return control;
            }
        }
        return null;
    }

    AbstractRequestImpl() {
    }

    AbstractRequestImpl(Request request) {
        Validator.ensureNotNull(request);
        for (Control control : request.getControls()) {
            this.controls.add(GenericControl.newControl(control));
        }
    }

    public final R addControl(Control control) {
        Validator.ensureNotNull(control);
        this.controls.add(control);
        return this.getThis();
    }

    @Override
    public boolean containsControl(String oid) {
        return AbstractRequestImpl.getControl(this.controls, oid) != null;
    }

    @Override
    public final <C extends Control> C getControl(ControlDecoder<C> decoder, DecodeOptions options) throws DecodeException {
        Validator.ensureNotNull(decoder, (Object)options);
        Control control = AbstractRequestImpl.getControl(this.controls, decoder.getOID());
        return control != null ? (C)decoder.decodeControl(control, options) : null;
    }

    @Override
    public final List<Control> getControls() {
        return this.controls;
    }

    public abstract String toString();

    abstract R getThis();
}

