/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.Validator;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.asn1.ASN1;
import org.forgerock.opendj.asn1.ASN1Reader;
import org.forgerock.opendj.asn1.ASN1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;

public final class SimplePagedResultsControl
implements Control {
    public static final String OID = "1.2.840.113556.1.4.319";
    public static final ControlDecoder<SimplePagedResultsControl> DECODER = new ControlDecoder<SimplePagedResultsControl>(){

        @Override
        public SimplePagedResultsControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            ByteString cookie;
            int size;
            Validator.ensureNotNull(control);
            if (control instanceof SimplePagedResultsControl) {
                return (SimplePagedResultsControl)control;
            }
            if (!control.getOID().equals(SimplePagedResultsControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_LDAP_PAGED_RESULTS_CONTROL_BAD_OID.get((Object)control.getOID(), (Object)SimplePagedResultsControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_LDAP_PAGED_RESULTS_DECODE_NULL.get();
                throw DecodeException.error(message);
            }
            ASN1Reader reader = ASN1.getReader(control.getValue());
            try {
                reader.readStartSequence();
            }
            catch (Exception e) {
                StaticUtils.DEBUG_LOG.throwing("PagedResultsControl.Decoder", "decode", e);
                LocalizableMessage message = CoreMessages.ERR_LDAP_PAGED_RESULTS_DECODE_SEQUENCE.get((Object)String.valueOf(e));
                throw DecodeException.error(message, e);
            }
            try {
                size = (int)reader.readInteger();
            }
            catch (Exception e) {
                StaticUtils.DEBUG_LOG.throwing("PagedResultsControl.Decoder", "decode", e);
                LocalizableMessage message = CoreMessages.ERR_LDAP_PAGED_RESULTS_DECODE_SIZE.get((Object)String.valueOf(e));
                throw DecodeException.error(message, e);
            }
            try {
                cookie = reader.readOctetString();
            }
            catch (Exception e) {
                StaticUtils.DEBUG_LOG.throwing("PagedResultsControl.Decoder", "decode", e);
                LocalizableMessage message = CoreMessages.ERR_LDAP_PAGED_RESULTS_DECODE_COOKIE.get((Object)String.valueOf(e));
                throw DecodeException.error(message, e);
            }
            try {
                reader.readEndSequence();
            }
            catch (Exception e) {
                StaticUtils.DEBUG_LOG.throwing("PagedResultsControl.Decoder", "decode", e);
                LocalizableMessage message = CoreMessages.ERR_LDAP_PAGED_RESULTS_DECODE_SEQUENCE.get((Object)String.valueOf(e));
                throw DecodeException.error(message, e);
            }
            return new SimplePagedResultsControl(control.isCritical(), size, cookie);
        }

        @Override
        public String getOID() {
            return SimplePagedResultsControl.OID;
        }
    };
    private final int size;
    private final ByteString cookie;
    private final boolean isCritical;

    public static SimplePagedResultsControl newControl(boolean isCritical, int size, ByteString cookie) {
        Validator.ensureNotNull(cookie);
        return new SimplePagedResultsControl(isCritical, size, cookie);
    }

    private SimplePagedResultsControl(boolean isCritical, int size, ByteString cookie) {
        this.isCritical = isCritical;
        this.size = size;
        this.cookie = cookie;
    }

    public ByteString getCookie() {
        return this.cookie;
    }

    @Override
    public String getOID() {
        return OID;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            writer.writeInteger(this.size);
            writer.writeOctetString(this.cookie);
            writer.writeEndSequence();
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SimplePagedResultsControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(", size=");
        builder.append(this.size);
        builder.append(", cookie=");
        builder.append(this.cookie);
        builder.append(")");
        return builder.toString();
    }
}

