/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.Validator;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.asn1.ASN1;
import org.forgerock.opendj.asn1.ASN1Reader;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;

public final class ProxiedAuthV2RequestControl
implements Control {
    public static final String OID = "2.16.840.1.113730.3.4.18";
    private static final ProxiedAuthV2RequestControl ANONYMOUS = new ProxiedAuthV2RequestControl("");
    public static final ControlDecoder<ProxiedAuthV2RequestControl> DECODER = new ControlDecoder<ProxiedAuthV2RequestControl>(){

        @Override
        public ProxiedAuthV2RequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            String authorizationID;
            Validator.ensureNotNull(control);
            if (control instanceof ProxiedAuthV2RequestControl) {
                return (ProxiedAuthV2RequestControl)control;
            }
            if (!control.getOID().equals(ProxiedAuthV2RequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_PROXYAUTH2_CONTROL_BAD_OID.get((Object)control.getOID(), (Object)ProxiedAuthV2RequestControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.isCritical()) {
                LocalizableMessage message = CoreMessages.ERR_PROXYAUTH2_CONTROL_NOT_CRITICAL.get();
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_PROXYAUTH2_NO_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            ASN1Reader reader = ASN1.getReader(control.getValue());
            try {
                authorizationID = reader.elementAvailable() ? reader.readOctetStringAsString() : control.getValue().toString();
            }
            catch (IOException e) {
                StaticUtils.DEBUG_LOG.throwing("ProxiedAuthV2RequestControl", "decodeControl", e);
                LocalizableMessage message = CoreMessages.ERR_PROXYAUTH2_CANNOT_DECODE_VALUE.get((Object)StaticUtils.getExceptionMessage(e));
                throw DecodeException.error(message, e);
            }
            if (authorizationID.length() == 0) {
                return ANONYMOUS;
            }
            int colonIndex = authorizationID.indexOf(58);
            if (colonIndex < 0) {
                LocalizableMessage message = CoreMessages.ERR_PROXYAUTH2_INVALID_AUTHZID_TYPE.get((Object)authorizationID);
                throw DecodeException.error(message);
            }
            return new ProxiedAuthV2RequestControl(authorizationID);
        }

        @Override
        public String getOID() {
            return ProxiedAuthV2RequestControl.OID;
        }
    };
    private final String authorizationID;

    public static final ProxiedAuthV2RequestControl newControl(String authorizationID) {
        if (authorizationID.length() == 0) {
            return ANONYMOUS;
        }
        int colonIndex = authorizationID.indexOf(58);
        if (colonIndex < 0) {
            LocalizableMessage message = CoreMessages.ERR_PROXYAUTH2_INVALID_AUTHZID_TYPE.get((Object)authorizationID);
            throw new LocalizedIllegalArgumentException(message);
        }
        return new ProxiedAuthV2RequestControl(authorizationID);
    }

    private ProxiedAuthV2RequestControl(String authorizationID) {
        this.authorizationID = authorizationID;
    }

    public String getAuthorizationID() {
        return this.authorizationID;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        return ByteString.valueOf(this.authorizationID);
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProxiedAuthorizationV2Control(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(", authorizationID=\"");
        builder.append(this.authorizationID);
        builder.append("\")");
        return builder.toString();
    }
}

