/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.Validator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.asn1.ASN1;
import org.forgerock.opendj.asn1.ASN1Reader;
import org.forgerock.opendj.asn1.ASN1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;

public final class PreReadRequestControl
implements Control {
    public static final String OID = "1.3.6.1.1.13.1";
    private final List<String> attributes;
    private final boolean isCritical;
    private static final PreReadRequestControl CRITICAL_EMPTY_INSTANCE = new PreReadRequestControl(true, Collections.<String>emptyList());
    private static final PreReadRequestControl NONCRITICAL_EMPTY_INSTANCE = new PreReadRequestControl(false, Collections.<String>emptyList());
    public static final ControlDecoder<PreReadRequestControl> DECODER = new ControlDecoder<PreReadRequestControl>(){

        @Override
        public PreReadRequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            List<Object> attributes;
            Validator.ensureNotNull(control);
            if (control instanceof PreReadRequestControl) {
                return (PreReadRequestControl)control;
            }
            if (!control.getOID().equals(PreReadRequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_PREREAD_CONTROL_BAD_OID.get((Object)control.getOID(), (Object)PreReadRequestControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_PREREADREQ_NO_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            ASN1Reader reader = ASN1.getReader(control.getValue());
            try {
                reader.readStartSequence();
                if (reader.hasNextElement()) {
                    String firstAttribute = reader.readOctetStringAsString();
                    if (reader.hasNextElement()) {
                        attributes = new ArrayList();
                        attributes.add(firstAttribute);
                        do {
                            attributes.add(reader.readOctetStringAsString());
                        } while (reader.hasNextElement());
                        attributes = Collections.unmodifiableList(attributes);
                    } else {
                        attributes = Collections.singletonList(firstAttribute);
                    }
                } else {
                    attributes = Collections.emptyList();
                }
                reader.readEndSequence();
            }
            catch (Exception ae) {
                StaticUtils.DEBUG_LOG.throwing("PreReadRequestControl", "decodeControl", ae);
                LocalizableMessage message = CoreMessages.ERR_PREREADREQ_CANNOT_DECODE_VALUE.get((Object)ae.getMessage());
                throw DecodeException.error(message, ae);
            }
            if (attributes.isEmpty()) {
                return control.isCritical() ? CRITICAL_EMPTY_INSTANCE : NONCRITICAL_EMPTY_INSTANCE;
            }
            return new PreReadRequestControl(control.isCritical(), attributes);
        }

        @Override
        public String getOID() {
            return PreReadRequestControl.OID;
        }
    };

    public static PreReadRequestControl newControl(boolean isCritical, Collection<String> attributes) {
        Validator.ensureNotNull(attributes);
        if (attributes.isEmpty()) {
            return isCritical ? CRITICAL_EMPTY_INSTANCE : NONCRITICAL_EMPTY_INSTANCE;
        }
        if (attributes.size() == 1) {
            return new PreReadRequestControl(isCritical, Collections.singletonList(attributes.iterator().next()));
        }
        return new PreReadRequestControl(isCritical, Collections.unmodifiableList(new ArrayList<String>(attributes)));
    }

    public static PreReadRequestControl newControl(boolean isCritical, String ... attributes) {
        Validator.ensureNotNull(attributes);
        if (attributes.length == 0) {
            return isCritical ? CRITICAL_EMPTY_INSTANCE : NONCRITICAL_EMPTY_INSTANCE;
        }
        if (attributes.length == 1) {
            return new PreReadRequestControl(isCritical, Collections.singletonList(attributes[0]));
        }
        return new PreReadRequestControl(isCritical, Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(attributes))));
    }

    private PreReadRequestControl(boolean isCritical, List<String> attributes) {
        this.isCritical = isCritical;
        this.attributes = attributes;
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            if (this.attributes != null) {
                for (String attr : this.attributes) {
                    writer.writeOctetString(attr);
                }
            }
            writer.writeEndSequence();
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PreReadRequestControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(", attributes=");
        builder.append(this.attributes);
        builder.append(")");
        return builder.toString();
    }
}

