/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.util.Validator;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;

public final class ManageDsaITRequestControl
implements Control {
    public static final String OID = "2.16.840.1.113730.3.4.2";
    private static final ManageDsaITRequestControl CRITICAL_INSTANCE = new ManageDsaITRequestControl(true);
    private static final ManageDsaITRequestControl NONCRITICAL_INSTANCE = new ManageDsaITRequestControl(false);
    public static final ControlDecoder<ManageDsaITRequestControl> DECODER = new ControlDecoder<ManageDsaITRequestControl>(){

        @Override
        public ManageDsaITRequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Validator.ensureNotNull(control);
            if (control instanceof ManageDsaITRequestControl) {
                return (ManageDsaITRequestControl)control;
            }
            if (!control.getOID().equals(ManageDsaITRequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_MANAGEDSAIT_CONTROL_BAD_OID.get((Object)control.getOID(), (Object)ManageDsaITRequestControl.OID);
                throw DecodeException.error(message);
            }
            if (control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_MANAGEDSAIT_INVALID_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            return control.isCritical() ? CRITICAL_INSTANCE : NONCRITICAL_INSTANCE;
        }

        @Override
        public String getOID() {
            return ManageDsaITRequestControl.OID;
        }
    };
    private final boolean isCritical;

    public static ManageDsaITRequestControl newControl(boolean isCritical) {
        return isCritical ? CRITICAL_INSTANCE : NONCRITICAL_INSTANCE;
    }

    private ManageDsaITRequestControl(boolean isCritical) {
        this.isCritical = isCritical;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        return null;
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ManageDsaITRequestControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(")");
        return builder.toString();
    }
}

