/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.schema.Schema;

public final class TrustManagers {
    private static final Logger LOG = Logger.getLogger(TrustManagers.class.getName());

    public static X509TrustManager checkHostName(String hostNamePattern, X509TrustManager trustManager) {
        Validator.ensureNotNull((Object)trustManager, (Object)hostNamePattern);
        return new CheckHostName(trustManager, hostNamePattern);
    }

    public static X509TrustManager checkUsingTrustStore(String file) throws GeneralSecurityException, IOException {
        return TrustManagers.checkUsingTrustStore(file, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509TrustManager checkUsingTrustStore(String file, char[] password, String format) throws GeneralSecurityException, IOException {
        Validator.ensureNotNull(file);
        File trustStoreFile = new File(file);
        String trustStoreFormat = format != null ? format : KeyStore.getDefaultType();
        KeyStore keyStore = KeyStore.getInstance(trustStoreFormat);
        FileInputStream fos = null;
        try {
            fos = new FileInputStream(trustStoreFile);
            keyStore.load(fos, password);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ignored) {}
            }
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(keyStore);
        X509TrustManager x509tm = null;
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            x509tm = (X509TrustManager)tm;
            break;
        }
        if (x509tm == null) {
            throw new NoSuchAlgorithmException();
        }
        return x509tm;
    }

    public static X509TrustManager checkValidityDates(X509TrustManager trustManager) {
        Validator.ensureNotNull(trustManager);
        return new CheckValidatyDates(trustManager);
    }

    public static X509TrustManager distrustAll() {
        return DistrustAll.INSTANCE;
    }

    public static X509TrustManager trustAll() {
        return TrustAll.INSTANCE;
    }

    private TrustManagers() {
    }

    private static final class TrustAll
    implements X509TrustManager {
        private static final TrustAll INSTANCE = new TrustAll();

        private TrustAll() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static final class DistrustAll
    implements X509TrustManager {
        private static final DistrustAll INSTANCE = new DistrustAll();

        private DistrustAll() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            throw new CertificateException();
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static final class CheckValidatyDates
    implements X509TrustManager {
        private final X509TrustManager trustManager;

        private CheckValidatyDates(X509TrustManager trustManager) {
            this.trustManager = trustManager;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.verifyExpiration(chain);
            this.trustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.verifyExpiration(chain);
            this.trustManager.checkServerTrusted(chain, authType);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }

        private void verifyExpiration(X509Certificate[] chain) throws CertificateException {
            Date currentDate = new Date();
            for (X509Certificate c : chain) {
                try {
                    c.checkValidity(currentDate);
                }
                catch (CertificateExpiredException e) {
                    LOG.log(Level.WARNING, "Refusing to trust security certificate \"" + c.getSubjectDN().getName() + "\" because it" + " expired on " + String.valueOf(c.getNotAfter()));
                    throw e;
                }
                catch (CertificateNotYetValidException e) {
                    LOG.log(Level.WARNING, "Refusing to trust security certificate \"" + c.getSubjectDN().getName() + "\" because it" + " is not valid until " + String.valueOf(c.getNotBefore()));
                    throw e;
                }
            }
        }
    }

    private static final class CheckHostName
    implements X509TrustManager {
        private final X509TrustManager trustManager;
        private final String hostNamePattern;

        private CheckHostName(X509TrustManager trustManager, String hostNamePattern) {
            this.trustManager = trustManager;
            this.hostNamePattern = hostNamePattern;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.verifyHostName(chain);
            this.trustManager.checkClientTrusted(chain, authType);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.verifyHostName(chain);
            this.trustManager.checkServerTrusted(chain, authType);
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.trustManager.getAcceptedIssuers();
        }

        private boolean hostNameMatchesPattern(String hostName, String pattern) {
            String[] patternElements;
            String[] nameElements = hostName.split("\\.");
            boolean hostMatch = nameElements.length == (patternElements = pattern.split("\\.")).length;
            for (int i = 0; i < nameElements.length && hostMatch; ++i) {
                String ne = nameElements[i];
                String pe = patternElements[i];
                if (pe.equals("*")) continue;
                hostMatch = ne.equalsIgnoreCase(pe);
            }
            return hostMatch;
        }

        private void verifyHostName(X509Certificate[] chain) throws CertificateException {
            try {
                DN dn = DN.valueOf(chain[0].getSubjectX500Principal().getName(), Schema.getCoreSchema());
                String value = dn.iterator().next().iterator().next().getAttributeValue().toString();
                if (!this.hostNameMatchesPattern(value, this.hostNamePattern)) {
                    throw new CertificateException("The host name contained in the certificate chain subject DN '" + chain[0].getSubjectX500Principal() + "' does not match the host name '" + this.hostNamePattern + "'");
                }
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "Error parsing subject dn: " + chain[0].getSubjectX500Principal(), t);
            }
        }
    }
}

