/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class SearchScope {
    private static final SearchScope[] ELEMENTS = new SearchScope[4];
    private static final List<SearchScope> IMMUTABLE_ELEMENTS = Collections.unmodifiableList(Arrays.asList(ELEMENTS));
    public static final SearchScope BASE_OBJECT = SearchScope.register(0, "base");
    public static final SearchScope SINGLE_LEVEL = SearchScope.register(1, "one");
    public static final SearchScope WHOLE_SUBTREE = SearchScope.register(2, "sub");
    public static final SearchScope SUBORDINATES = SearchScope.register(3, "subordinates");
    private final int intValue;
    private final String name;

    public static SearchScope valueOf(int intValue) {
        if (intValue < 0 || intValue >= ELEMENTS.length) {
            return null;
        }
        return ELEMENTS[intValue];
    }

    public static SearchScope valueOf(String name) {
        for (SearchScope searchScope : ELEMENTS) {
            if (!searchScope.name.equals(name)) continue;
            return searchScope;
        }
        return null;
    }

    public static List<SearchScope> values() {
        return IMMUTABLE_ELEMENTS;
    }

    private static SearchScope register(int intValue, String name) {
        SearchScope t;
        SearchScope.ELEMENTS[intValue] = t = new SearchScope(intValue, name);
        return t;
    }

    private SearchScope(int intValue, String name) {
        this.intValue = intValue;
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SearchScope) {
            return this.intValue == ((SearchScope)obj).intValue;
        }
        return false;
    }

    public int hashCode() {
        return this.intValue;
    }

    public int intValue() {
        return this.intValue;
    }

    public String toString() {
        return this.name;
    }
}

