/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.Iterators;
import com.forgerock.opendj.util.SubstringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AVA;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;

public final class RDN
implements Iterable<AVA>,
Comparable<RDN> {
    private static final RDN MAX_VALUE = new RDN(new AVA[0], "");
    private final AVA[] avas;
    private String stringValue;

    public static RDN maxValue() {
        return MAX_VALUE;
    }

    public static RDN valueOf(String rdn) {
        return RDN.valueOf(rdn, Schema.getDefaultSchema());
    }

    public static RDN valueOf(String rdn, Schema schema) {
        SubstringReader reader = new SubstringReader(rdn);
        try {
            return RDN.decode(rdn, reader, schema);
        }
        catch (UnknownSchemaElementException e) {
            LocalizableMessage message = CoreMessages.ERR_RDN_TYPE_NOT_FOUND.get((Object)rdn, (Object)e.getMessageObject());
            throw new LocalizedIllegalArgumentException(message);
        }
    }

    static RDN decode(String rdnString, SubstringReader reader, Schema schema) {
        AVA firstAVA = AVA.decode(reader, schema);
        reader.skipWhitespaces();
        reader.mark();
        if (reader.remaining() > 0 && reader.read() == '+') {
            ArrayList<AVA> avas = new ArrayList<AVA>();
            avas.add(firstAVA);
            do {
                avas.add(AVA.decode(reader, schema));
                reader.skipWhitespaces();
                reader.mark();
            } while (reader.remaining() > 0 && reader.read() == '+');
            reader.reset();
            return new RDN(avas.toArray(new AVA[avas.size()]), null);
        }
        reader.reset();
        return new RDN(new AVA[]{firstAVA}, null);
    }

    public RDN(AttributeType attributeType, Object attributeValue) {
        this.avas = new AVA[]{new AVA(attributeType, attributeValue)};
    }

    public RDN(String attributeType, Object attributeValue) {
        this.avas = new AVA[]{new AVA(attributeType, attributeValue)};
    }

    private RDN(AVA[] avas, String stringValue) {
        this.avas = avas;
        this.stringValue = stringValue;
    }

    @Override
    public int compareTo(RDN rdn) {
        if (this == rdn) {
            return 0;
        }
        if (this == MAX_VALUE) {
            return 1;
        }
        if (rdn == MAX_VALUE) {
            return -1;
        }
        int sz1 = this.avas.length;
        int sz2 = rdn.avas.length;
        if (sz1 != sz2) {
            return sz1 - sz2 > 0 ? 1 : -1;
        }
        if (sz1 == 1) {
            return this.avas[0].compareTo(rdn.avas[0]);
        }
        Object[] a1 = new AVA[sz1];
        System.arraycopy(this.avas, 0, a1, 0, sz1);
        Arrays.sort(a1);
        Object[] a2 = new AVA[sz1];
        System.arraycopy(rdn.avas, 0, a2, 0, sz1);
        Arrays.sort(a2);
        for (int i = 0; i < sz1; ++i) {
            int result = ((AVA)a1[i]).compareTo((AVA)a2[i]);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RDN) {
            return this.compareTo((RDN)obj) == 0;
        }
        return false;
    }

    public ByteString getAttributeValue(AttributeType attributeType) {
        for (AVA ava : this.avas) {
            if (!ava.getAttributeType().equals(attributeType)) continue;
            return ava.getAttributeValue();
        }
        return null;
    }

    public AVA getFirstAVA() {
        return this.avas[0];
    }

    public int hashCode() {
        int hash = 0;
        for (AVA ava : this.avas) {
            hash += ava.hashCode();
        }
        return hash;
    }

    public boolean isMultiValued() {
        return this.avas.length > 1;
    }

    @Override
    public Iterator<AVA> iterator() {
        return Iterators.arrayIterator(this.avas);
    }

    public int size() {
        return this.avas.length;
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuilder builder = new StringBuilder();
            this.avas[0].toString(builder);
            for (int i = 1; i < this.avas.length; ++i) {
                builder.append('+');
                this.avas[i].toString(builder);
            }
            this.stringValue = builder.toString();
        }
        return this.stringValue;
    }

    StringBuilder toString(StringBuilder builder) {
        return builder.append(this.toString());
    }
}

