/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.StaticUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AVA;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.FilterVisitor;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.MatchingRuleUse;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;

public final class Matcher {
    private static final MatcherImpl FALSE = new FalseMatcherImpl();
    private static final MatcherImpl TRUE = new TrueMatcherImpl();
    private static final MatcherImpl UNDEFINED = new UndefinedMatcherImpl();
    private static final FilterVisitor<MatcherImpl, Schema> VISITOR = new Visitor();
    private final MatcherImpl impl;

    private static ConditionResult matches(Attribute a, MatchingRule rule, Assertion assertion) {
        ConditionResult r = ConditionResult.FALSE;
        if (a != null) {
            for (ByteString v : a) {
                switch (Matcher.matches(v, rule, assertion)) {
                    case TRUE: {
                        return ConditionResult.TRUE;
                    }
                    case FALSE: {
                        break;
                    }
                    case UNDEFINED: {
                        r = ConditionResult.UNDEFINED;
                    }
                }
            }
        }
        return r;
    }

    private static ConditionResult matches(ByteString v, MatchingRule rule, Assertion assertion) {
        try {
            ByteString normalizedValue = rule.normalizeAttributeValue(v);
            return assertion.matches(normalizedValue);
        }
        catch (DecodeException de) {
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                StaticUtils.DEBUG_LOG.warning("The attribute value " + v.toString() + " is " + "invalid for matching rule " + rule.getNameOrOID() + ". Possible schema error? : " + de.getMessage());
            }
            return ConditionResult.UNDEFINED;
        }
    }

    Matcher(Filter filter, Schema schema) {
        this.impl = filter.accept(VISITOR, schema);
    }

    public ConditionResult matches(Entry entry) {
        return this.impl.matches(entry);
    }

    private static final class Visitor
    implements FilterVisitor<MatcherImpl, Schema> {
        private Visitor() {
        }

        @Override
        public MatcherImpl visitAndFilter(Schema schema, List<Filter> subFilters) {
            if (subFilters.isEmpty()) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
                    StaticUtils.DEBUG_LOG.finer("Empty add filter component. Will always return TRUE");
                }
                return TRUE;
            }
            ArrayList<MatcherImpl> subMatchers = new ArrayList<MatcherImpl>(subFilters.size());
            for (Filter f : subFilters) {
                subMatchers.add(f.accept(this, schema));
            }
            return new AndMatcherImpl(subMatchers);
        }

        @Override
        public MatcherImpl visitApproxMatchFilter(Schema schema, String attributeDescription, ByteString assertionValue) {
            Assertion assertion;
            AttributeDescription ad;
            try {
                ad = AttributeDescription.valueOf(attributeDescription, schema);
            }
            catch (LocalizedIllegalArgumentException e) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                    StaticUtils.DEBUG_LOG.warning("Attribute description " + attributeDescription + " is not recognized: " + e.getMessage());
                }
                return UNDEFINED;
            }
            MatchingRule rule = ad.getAttributeType().getApproximateMatchingRule();
            if (rule == null) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                    StaticUtils.DEBUG_LOG.warning("The attribute type " + attributeDescription + " does not define an approximate matching rule");
                }
                return UNDEFINED;
            }
            try {
                assertion = rule.getAssertion(assertionValue);
            }
            catch (DecodeException de) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                    StaticUtils.DEBUG_LOG.warning("The assertion value " + assertionValue + " is invalid: " + de.getMessage());
                }
                return UNDEFINED;
            }
            return new AssertionMatcherImpl(ad, rule, null, assertion, false);
        }

        @Override
        public MatcherImpl visitEqualityMatchFilter(Schema schema, String attributeDescription, ByteString assertionValue) {
            Assertion assertion;
            AttributeDescription ad;
            try {
                ad = AttributeDescription.valueOf(attributeDescription, schema);
            }
            catch (LocalizedIllegalArgumentException e) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                    StaticUtils.DEBUG_LOG.warning("Attribute description " + attributeDescription + " is not recognized: " + e.getMessage());
                }
                return UNDEFINED;
            }
            MatchingRule rule = ad.getAttributeType().getEqualityMatchingRule();
            if (rule == null) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                    StaticUtils.DEBUG_LOG.warning("The attribute type " + attributeDescription + " does not define an equality matching rule");
                }
                return UNDEFINED;
            }
            try {
                assertion = rule.getAssertion(assertionValue);
            }
            catch (DecodeException de) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                    StaticUtils.DEBUG_LOG.warning("The assertion value " + assertionValue + " is invalid: " + de.getMessage());
                }
                return UNDEFINED;
            }
            return new AssertionMatcherImpl(ad, rule, null, assertion, false);
        }

        @Override
        public MatcherImpl visitExtensibleMatchFilter(Schema schema, String matchingRule, String attributeDescription, ByteString assertionValue, boolean dnAttributes) {
            Assertion assertion;
            AttributeDescription ad = null;
            MatchingRule rule = null;
            MatchingRuleUse ruleUse = null;
            if (matchingRule != null) {
                try {
                    rule = schema.getMatchingRule(matchingRule);
                }
                catch (UnknownSchemaElementException e) {
                    if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                        StaticUtils.DEBUG_LOG.warning("Matching rule " + matchingRule + " is not recognized: " + e.getMessage());
                    }
                    return UNDEFINED;
                }
            }
            if (attributeDescription != null) {
                try {
                    ad = AttributeDescription.valueOf(attributeDescription, schema);
                }
                catch (LocalizedIllegalArgumentException e) {
                    if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                        StaticUtils.DEBUG_LOG.warning("Attribute description " + attributeDescription + " is not recognized: " + e.getMessage());
                    }
                    return UNDEFINED;
                }
                if (rule == null) {
                    rule = ad.getAttributeType().getEqualityMatchingRule();
                    if (rule == null) {
                        if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                            StaticUtils.DEBUG_LOG.warning("The attribute type " + attributeDescription + " does not define an equality matching rule");
                        }
                        return UNDEFINED;
                    }
                } else {
                    block23: {
                        try {
                            ruleUse = schema.getMatchingRuleUse(rule);
                        }
                        catch (UnknownSchemaElementException e) {
                            if (!StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) break block23;
                            StaticUtils.DEBUG_LOG.warning("No matching rule use is defined for matching rule " + matchingRule);
                            return UNDEFINED;
                        }
                    }
                    if (!ruleUse.hasAttribute(ad.getAttributeType())) {
                        if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                            StaticUtils.DEBUG_LOG.warning("The matching rule " + matchingRule + " is not valid for attribute type " + attributeDescription);
                        }
                        return UNDEFINED;
                    }
                }
            } else {
                try {
                    ruleUse = schema.getMatchingRuleUse(rule);
                }
                catch (UnknownSchemaElementException e) {
                    if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                        StaticUtils.DEBUG_LOG.warning("No matching rule use is defined for matching rule " + matchingRule);
                    }
                    return UNDEFINED;
                }
            }
            try {
                assertion = rule.getAssertion(assertionValue);
            }
            catch (DecodeException de) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                    StaticUtils.DEBUG_LOG.warning("The assertion value " + assertionValue + " is invalid: " + de.getMessage());
                }
                return UNDEFINED;
            }
            return new AssertionMatcherImpl(ad, rule, ruleUse, assertion, dnAttributes);
        }

        @Override
        public MatcherImpl visitGreaterOrEqualFilter(Schema schema, String attributeDescription, ByteString assertionValue) {
            Assertion assertion;
            AttributeDescription ad;
            try {
                ad = AttributeDescription.valueOf(attributeDescription, schema);
            }
            catch (LocalizedIllegalArgumentException e) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                    StaticUtils.DEBUG_LOG.warning("Attribute description " + attributeDescription + " is not recognized: " + e.getMessage());
                }
                return UNDEFINED;
            }
            MatchingRule rule = ad.getAttributeType().getOrderingMatchingRule();
            if (rule == null) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                    StaticUtils.DEBUG_LOG.warning("The attribute type " + attributeDescription + " does not define an ordering matching rule");
                }
                return UNDEFINED;
            }
            try {
                assertion = rule.getGreaterOrEqualAssertion(assertionValue);
            }
            catch (DecodeException de) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                    StaticUtils.DEBUG_LOG.warning("The assertion value " + assertionValue + " is invalid: " + de.getMessage());
                }
                return UNDEFINED;
            }
            return new AssertionMatcherImpl(ad, rule, null, assertion, false);
        }

        @Override
        public MatcherImpl visitLessOrEqualFilter(Schema schema, String attributeDescription, ByteString assertionValue) {
            Assertion assertion;
            AttributeDescription ad;
            try {
                ad = AttributeDescription.valueOf(attributeDescription, schema);
            }
            catch (LocalizedIllegalArgumentException e) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                    StaticUtils.DEBUG_LOG.warning("Attribute description " + attributeDescription + " is not recognized: " + e.getMessage());
                }
                return UNDEFINED;
            }
            MatchingRule rule = ad.getAttributeType().getOrderingMatchingRule();
            if (rule == null) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                    StaticUtils.DEBUG_LOG.warning("The attribute type " + attributeDescription + " does not define an ordering matching rule");
                }
                return UNDEFINED;
            }
            try {
                assertion = rule.getLessOrEqualAssertion(assertionValue);
            }
            catch (DecodeException de) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                    StaticUtils.DEBUG_LOG.warning("The assertion value " + assertionValue + " is invalid: " + de.getMessage());
                }
                return UNDEFINED;
            }
            return new AssertionMatcherImpl(ad, rule, null, assertion, false);
        }

        @Override
        public MatcherImpl visitNotFilter(Schema schema, Filter subFilter) {
            MatcherImpl subMatcher = subFilter.accept(this, schema);
            return new NotMatcherImpl(subMatcher);
        }

        @Override
        public MatcherImpl visitOrFilter(Schema schema, List<Filter> subFilters) {
            if (subFilters.isEmpty()) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
                    StaticUtils.DEBUG_LOG.finer("Empty or filter component. Will always return FALSE");
                }
                return FALSE;
            }
            ArrayList<MatcherImpl> subMatchers = new ArrayList<MatcherImpl>(subFilters.size());
            for (Filter f : subFilters) {
                subMatchers.add(f.accept(this, schema));
            }
            return new OrMatcherImpl(subMatchers);
        }

        @Override
        public MatcherImpl visitPresentFilter(Schema schema, String attributeDescription) {
            AttributeDescription ad;
            try {
                ad = AttributeDescription.valueOf(attributeDescription, schema);
            }
            catch (LocalizedIllegalArgumentException e) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                    StaticUtils.DEBUG_LOG.warning("Attribute description " + attributeDescription + " is not recognized: " + e.getMessage());
                }
                return UNDEFINED;
            }
            return new PresentMatcherImpl(ad);
        }

        @Override
        public MatcherImpl visitSubstringsFilter(Schema schema, String attributeDescription, ByteString initialSubstring, List<ByteString> anySubstrings, ByteString finalSubstring) {
            Assertion assertion;
            AttributeDescription ad;
            try {
                ad = AttributeDescription.valueOf(attributeDescription, schema);
            }
            catch (LocalizedIllegalArgumentException e) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                    StaticUtils.DEBUG_LOG.warning("Attribute description " + attributeDescription + " is not recognized: " + e.getMessage());
                }
                return UNDEFINED;
            }
            MatchingRule rule = ad.getAttributeType().getSubstringMatchingRule();
            if (rule == null) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                    StaticUtils.DEBUG_LOG.warning("The attribute type " + attributeDescription + " does not define an substring matching rule");
                }
                return UNDEFINED;
            }
            try {
                assertion = rule.getAssertion(initialSubstring, anySubstrings, finalSubstring);
            }
            catch (DecodeException de) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                    StaticUtils.DEBUG_LOG.warning("The substring assertion values contain an invalid value: " + de.getMessage());
                }
                return UNDEFINED;
            }
            return new AssertionMatcherImpl(ad, rule, null, assertion, false);
        }

        @Override
        public MatcherImpl visitUnrecognizedFilter(Schema schema, byte filterTag, ByteString filterBytes) {
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                StaticUtils.DEBUG_LOG.warning("The type of filtering requested with tag " + StaticUtils.byteToHex(filterTag) + " is not implemented");
            }
            return UNDEFINED;
        }
    }

    private static class UndefinedMatcherImpl
    extends MatcherImpl {
        private UndefinedMatcherImpl() {
        }

        @Override
        public ConditionResult matches(Entry entry) {
            return ConditionResult.UNDEFINED;
        }
    }

    private static class TrueMatcherImpl
    extends MatcherImpl {
        private TrueMatcherImpl() {
        }

        @Override
        public ConditionResult matches(Entry entry) {
            return ConditionResult.TRUE;
        }
    }

    private static final class PresentMatcherImpl
    extends MatcherImpl {
        private final AttributeDescription attribute;

        private PresentMatcherImpl(AttributeDescription attribute) {
            this.attribute = attribute;
        }

        @Override
        public ConditionResult matches(Entry entry) {
            return entry.getAttribute(this.attribute) == null ? ConditionResult.FALSE : ConditionResult.TRUE;
        }
    }

    private static final class OrMatcherImpl
    extends MatcherImpl {
        private final List<MatcherImpl> subMatchers;

        private OrMatcherImpl(List<MatcherImpl> subMatchers) {
            this.subMatchers = subMatchers;
        }

        @Override
        public ConditionResult matches(Entry entry) {
            ConditionResult r = ConditionResult.FALSE;
            for (MatcherImpl m : this.subMatchers) {
                ConditionResult p = m.matches(entry);
                if (p == ConditionResult.TRUE) {
                    return p;
                }
                r = ConditionResult.or(r, p);
            }
            return r;
        }
    }

    private static final class NotMatcherImpl
    extends MatcherImpl {
        private final MatcherImpl subFilter;

        private NotMatcherImpl(MatcherImpl subFilter) {
            this.subFilter = subFilter;
        }

        @Override
        public ConditionResult matches(Entry entry) {
            return ConditionResult.not(this.subFilter.matches(entry));
        }
    }

    private static abstract class MatcherImpl {
        private MatcherImpl() {
        }

        public abstract ConditionResult matches(Entry var1);
    }

    private static class FalseMatcherImpl
    extends MatcherImpl {
        private FalseMatcherImpl() {
        }

        @Override
        public ConditionResult matches(Entry entry) {
            return ConditionResult.FALSE;
        }
    }

    private static final class AssertionMatcherImpl
    extends MatcherImpl {
        private final Assertion assertion;
        private final AttributeDescription attributeDescription;
        private final boolean dnAttributes;
        private final MatchingRule rule;
        private final MatchingRuleUse ruleUse;

        private AssertionMatcherImpl(AttributeDescription attributeDescription, MatchingRule rule, MatchingRuleUse ruleUse, Assertion assertion, boolean dnAttributes) {
            this.attributeDescription = attributeDescription;
            this.rule = rule;
            this.ruleUse = ruleUse;
            this.assertion = assertion;
            this.dnAttributes = dnAttributes;
        }

        @Override
        public ConditionResult matches(Entry entry) {
            ConditionResult r = ConditionResult.FALSE;
            if (this.attributeDescription != null) {
                ConditionResult p = Matcher.matches(entry.getAttribute(this.attributeDescription), this.rule, this.assertion);
                if (p == ConditionResult.TRUE) {
                    return p;
                }
                r = ConditionResult.or(r, p);
            } else {
                for (Attribute a : entry.getAllAttributes()) {
                    if (!this.ruleUse.hasAttribute(a.getAttributeDescription().getAttributeType())) continue;
                    ConditionResult p = Matcher.matches(a, this.rule, this.assertion);
                    if (p == ConditionResult.TRUE) {
                        return p;
                    }
                    r = ConditionResult.or(r, p);
                }
            }
            if (this.dnAttributes) {
                DN dn = entry.getName();
                for (RDN rdn : dn) {
                    for (AVA ava : rdn) {
                        if (!this.ruleUse.hasAttribute(ava.getAttributeType())) continue;
                        ConditionResult p = Matcher.matches(ava.getAttributeValue(), this.rule, this.assertion);
                        if (p == ConditionResult.TRUE) {
                            return p;
                        }
                        r = ConditionResult.or(r, p);
                    }
                }
            }
            return r;
        }
    }

    private static final class AndMatcherImpl
    extends MatcherImpl {
        private final List<MatcherImpl> subMatchers;

        private AndMatcherImpl(List<MatcherImpl> subMatchers) {
            this.subMatchers = subMatchers;
        }

        @Override
        public ConditionResult matches(Entry entry) {
            ConditionResult r = ConditionResult.TRUE;
            for (MatcherImpl m : this.subMatchers) {
                ConditionResult p = m.matches(entry);
                if (p == ConditionResult.FALSE) {
                    return p;
                }
                r = ConditionResult.and(r, p);
            }
            return r;
        }
    }
}

