/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.CompletedFutureResult;
import com.forgerock.opendj.util.Validator;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.LoadBalancingAlgorithm;
import org.forgerock.opendj.ldap.ResultHandler;

final class LoadBalancer
implements ConnectionFactory {
    private final LoadBalancingAlgorithm algorithm;

    LoadBalancer(LoadBalancingAlgorithm algorithm) {
        Validator.ensureNotNull(algorithm);
        this.algorithm = algorithm;
    }

    @Override
    public void close() {
        this.algorithm.close();
    }

    @Override
    public Connection getConnection() throws ErrorResultException {
        return this.algorithm.getConnectionFactory().getConnection();
    }

    @Override
    public FutureResult<Connection> getConnectionAsync(ResultHandler<? super Connection> resultHandler) {
        ConnectionFactory factory;
        try {
            factory = this.algorithm.getConnectionFactory();
        }
        catch (ErrorResultException e) {
            if (resultHandler != null) {
                resultHandler.handleErrorResult(e);
            }
            return new CompletedFutureResult<ErrorResultException>(e);
        }
        return factory.getConnectionAsync(resultHandler);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LoadBalancer(");
        builder.append(String.valueOf(this.algorithm));
        builder.append(')');
        return builder.toString();
    }
}

