/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.Validator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;

public final class LDAPOptions {
    private SSLContext sslContext;
    private boolean useStartTLS;
    private long timeoutInMillis;
    private DecodeOptions decodeOptions;
    private List<String> enabledCipherSuites = new LinkedList<String>();
    private List<String> enabledProtocols = new LinkedList<String>();
    private TCPNIOTransport transport;

    public LDAPOptions() {
        this.sslContext = null;
        this.timeoutInMillis = 0L;
        this.useStartTLS = false;
        this.decodeOptions = new DecodeOptions();
        this.transport = null;
    }

    public LDAPOptions(LDAPOptions options) {
        this.sslContext = options.sslContext;
        this.timeoutInMillis = options.timeoutInMillis;
        this.useStartTLS = options.useStartTLS;
        this.decodeOptions = new DecodeOptions(options.decodeOptions);
        this.enabledCipherSuites.addAll(options.getEnabledCipherSuites());
        this.enabledProtocols.addAll(options.getEnabledProtocols());
        this.transport = options.transport;
    }

    public final DecodeOptions getDecodeOptions() {
        return this.decodeOptions;
    }

    public final SSLContext getSSLContext() {
        return this.sslContext;
    }

    public final TCPNIOTransport getTCPNIOTransport() {
        return this.transport;
    }

    public final long getTimeout(TimeUnit unit) {
        return unit.convert(this.timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public final LDAPOptions setDecodeOptions(DecodeOptions decodeOptions) {
        Validator.ensureNotNull(decodeOptions);
        this.decodeOptions = decodeOptions;
        return this;
    }

    public final LDAPOptions setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public final LDAPOptions setTCPNIOTransport(TCPNIOTransport transport) {
        this.transport = transport;
        return this;
    }

    public final LDAPOptions setTimeout(long timeout, TimeUnit unit) {
        this.timeoutInMillis = unit.toMillis(timeout);
        return this;
    }

    public final LDAPOptions setUseStartTLS(boolean useStartTLS) {
        this.useStartTLS = useStartTLS;
        return this;
    }

    public final boolean useStartTLS() {
        return this.useStartTLS;
    }

    public final LDAPOptions addEnabledProtocol(String ... protocols) {
        for (String protocol : protocols) {
            this.enabledProtocols.add(Validator.ensureNotNull(protocol));
        }
        return this;
    }

    public final LDAPOptions addEnabledCipherSuite(String ... suites) {
        for (String suite : suites) {
            this.enabledCipherSuites.add(Validator.ensureNotNull(suite));
        }
        return this;
    }

    public final List<String> getEnabledProtocols() {
        return this.enabledProtocols;
    }

    public final List<String> getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }
}

