/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.Validator;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;

public final class LDAPListenerOptions {
    private int backlog;
    private DecodeOptions decodeOptions;
    private int maxRequestSize;
    private TCPNIOTransport transport;

    public LDAPListenerOptions() {
        this.backlog = 0;
        this.maxRequestSize = 0;
        this.decodeOptions = new DecodeOptions();
        this.transport = null;
    }

    public LDAPListenerOptions(LDAPListenerOptions options) {
        this.backlog = options.backlog;
        this.maxRequestSize = options.maxRequestSize;
        this.decodeOptions = new DecodeOptions(options.decodeOptions);
        this.transport = options.transport;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public DecodeOptions getDecodeOptions() {
        return this.decodeOptions;
    }

    public int getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public TCPNIOTransport getTCPNIOTransport() {
        return this.transport;
    }

    public LDAPListenerOptions setBacklog(int backlog) {
        this.backlog = backlog;
        return this;
    }

    public LDAPListenerOptions setDecodeOptions(DecodeOptions decodeOptions) {
        Validator.ensureNotNull(decodeOptions);
        this.decodeOptions = decodeOptions;
        return this;
    }

    public LDAPListenerOptions setMaxRequestSize(int maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
        return this;
    }

    public LDAPListenerOptions setTCPNIOTransport(TCPNIOTransport transport) {
        this.transport = transport;
        return this;
    }
}

