/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.Validator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;

public final class KeyManagers {
    public static X509KeyManager useKeyStoreFile(String file) throws GeneralSecurityException, IOException {
        return KeyManagers.useKeyStoreFile(file, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509KeyManager useKeyStoreFile(String file, char[] password, String format) throws GeneralSecurityException, IOException {
        Validator.ensureNotNull(file);
        File keyStoreFile = new File(file);
        String keyStoreFormat = format != null ? format : KeyStore.getDefaultType();
        KeyStore keyStore = KeyStore.getInstance(keyStoreFormat);
        FileInputStream fos = null;
        try {
            fos = new FileInputStream(keyStoreFile);
            keyStore.load(fos, password);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ignored) {}
            }
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, password);
        X509KeyManager x509km = null;
        for (KeyManager km : kmf.getKeyManagers()) {
            if (!(km instanceof X509KeyManager)) continue;
            x509km = (X509KeyManager)km;
            break;
        }
        if (x509km == null) {
            throw new NoSuchAlgorithmException();
        }
        return x509km;
    }

    public static X509KeyManager usePKCS11Token(char[] password) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance("PKCS11");
        keyStore.load(null, password);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, password);
        X509KeyManager x509km = null;
        for (KeyManager km : kmf.getKeyManagers()) {
            if (!(km instanceof X509KeyManager)) continue;
            x509km = (X509KeyManager)km;
            break;
        }
        if (x509km == null) {
            throw new NoSuchAlgorithmException();
        }
        return x509km;
    }

    public static X509KeyManager useSingleCertificate(String alias, X509KeyManager keyManager) {
        Validator.ensureNotNull((Object)alias, (Object)keyManager);
        return new SelectCertificate(keyManager, alias);
    }

    private KeyManagers() {
    }

    private static final class SelectCertificate
    extends X509ExtendedKeyManager {
        private final String alias;
        private final X509KeyManager keyManager;

        private SelectCertificate(X509KeyManager keyManager, String alias) {
            this.keyManager = keyManager;
            this.alias = alias;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            for (String type : keyType) {
                String[] clientAliases = this.keyManager.getClientAliases(type, issuers);
                if (clientAliases == null) continue;
                for (String clientAlias : clientAliases) {
                    if (!clientAlias.equals(this.alias)) continue;
                    return this.alias;
                }
            }
            return null;
        }

        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            for (String type : keyType) {
                String[] clientAliases = this.keyManager.getClientAliases(type, issuers);
                if (clientAliases == null) continue;
                for (String clientAlias : clientAliases) {
                    if (!clientAlias.equals(this.alias)) continue;
                    return this.alias;
                }
            }
            return null;
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            String[] serverAliases = this.keyManager.getServerAliases(keyType, issuers);
            if (serverAliases != null) {
                for (String serverAlias : serverAliases) {
                    if (!serverAlias.equalsIgnoreCase(this.alias)) continue;
                    return serverAlias;
                }
            }
            return null;
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            String[] serverAliases = this.keyManager.getServerAliases(keyType, issuers);
            if (serverAliases != null) {
                for (String serverAlias : serverAliases) {
                    if (!serverAlias.equals(this.alias)) continue;
                    return this.alias;
                }
            }
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.keyManager.getCertificateChain(alias);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getClientAliases(keyType, issuers);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.keyManager.getPrivateKey(alias);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getServerAliases(keyType, issuers);
        }
    }
}

