/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.Validator;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.CoreMessages;

public final class GeneralizedTime
implements Comparable<GeneralizedTime> {
    private static final TimeZone TIME_ZONE_UTC_OBJ = TimeZone.getTimeZone("UTC");
    private volatile Calendar calendar;
    private volatile Date date;
    private volatile String stringValue;
    private volatile long timeMS;

    public static GeneralizedTime currentTime() {
        return GeneralizedTime.valueOf(Calendar.getInstance());
    }

    public static GeneralizedTime valueOf(Calendar calendar) {
        Validator.ensureNotNull(calendar);
        return new GeneralizedTime((Calendar)calendar.clone(), null, -1L, null);
    }

    public static GeneralizedTime valueOf(Date date) {
        Validator.ensureNotNull(date);
        return new GeneralizedTime(null, (Date)date.clone(), -1L, null);
    }

    public static GeneralizedTime valueOf(long timeMS) {
        Validator.ensureTrue(timeMS >= 0L, "timeMS must be >= 0");
        return new GeneralizedTime(null, null, timeMS, null);
    }

    public static GeneralizedTime valueOf(String time) {
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        String valueString = time.toUpperCase();
        int length = valueString.length();
        if (length < 11) {
            LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_TOO_SHORT.get((Object)valueString);
            throw new LocalizedIllegalArgumentException(message);
        }
        block154: for (int i = 0; i < 4; ++i) {
            switch (valueString.charAt(i)) {
                case '0': {
                    year *= 10;
                    continue block154;
                }
                case '1': {
                    year = year * 10 + 1;
                    continue block154;
                }
                case '2': {
                    year = year * 10 + 2;
                    continue block154;
                }
                case '3': {
                    year = year * 10 + 3;
                    continue block154;
                }
                case '4': {
                    year = year * 10 + 4;
                    continue block154;
                }
                case '5': {
                    year = year * 10 + 5;
                    continue block154;
                }
                case '6': {
                    year = year * 10 + 6;
                    continue block154;
                }
                case '7': {
                    year = year * 10 + 7;
                    continue block154;
                }
                case '8': {
                    year = year * 10 + 8;
                    continue block154;
                }
                case '9': {
                    year = year * 10 + 9;
                    continue block154;
                }
                default: {
                    LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_YEAR.get((Object)valueString, (Object)String.valueOf(valueString.charAt(i)));
                    throw new LocalizedIllegalArgumentException(message);
                }
            }
        }
        char m1 = valueString.charAt(4);
        char m2 = valueString.charAt(5);
        block12 : switch (m1) {
            case '0': {
                switch (m2) {
                    case '1': {
                        month = 0;
                        break block12;
                    }
                    case '2': {
                        month = 1;
                        break block12;
                    }
                    case '3': {
                        month = 2;
                        break block12;
                    }
                    case '4': {
                        month = 3;
                        break block12;
                    }
                    case '5': {
                        month = 4;
                        break block12;
                    }
                    case '6': {
                        month = 5;
                        break block12;
                    }
                    case '7': {
                        month = 6;
                        break block12;
                    }
                    case '8': {
                        month = 7;
                        break block12;
                    }
                    case '9': {
                        month = 8;
                        break block12;
                    }
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_MONTH.get((Object)valueString, (Object)valueString.substring(4, 6));
                throw new LocalizedIllegalArgumentException(message);
            }
            case '1': {
                switch (m2) {
                    case '0': {
                        month = 9;
                        break block12;
                    }
                    case '1': {
                        month = 10;
                        break block12;
                    }
                    case '2': {
                        month = 11;
                        break block12;
                    }
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_MONTH.get((Object)valueString, (Object)valueString.substring(4, 6));
                throw new LocalizedIllegalArgumentException(message);
            }
            default: {
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_MONTH.get((Object)valueString, (Object)valueString.substring(4, 6));
                throw new LocalizedIllegalArgumentException(message);
            }
        }
        char d1 = valueString.charAt(6);
        char d2 = valueString.charAt(7);
        block32 : switch (d1) {
            case '0': {
                switch (d2) {
                    case '1': {
                        day = 1;
                        break block32;
                    }
                    case '2': {
                        day = 2;
                        break block32;
                    }
                    case '3': {
                        day = 3;
                        break block32;
                    }
                    case '4': {
                        day = 4;
                        break block32;
                    }
                    case '5': {
                        day = 5;
                        break block32;
                    }
                    case '6': {
                        day = 6;
                        break block32;
                    }
                    case '7': {
                        day = 7;
                        break block32;
                    }
                    case '8': {
                        day = 8;
                        break block32;
                    }
                    case '9': {
                        day = 9;
                        break block32;
                    }
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_DAY.get((Object)valueString, (Object)valueString.substring(6, 8));
                throw new LocalizedIllegalArgumentException(message);
            }
            case '1': {
                switch (d2) {
                    case '0': {
                        day = 10;
                        break block32;
                    }
                    case '1': {
                        day = 11;
                        break block32;
                    }
                    case '2': {
                        day = 12;
                        break block32;
                    }
                    case '3': {
                        day = 13;
                        break block32;
                    }
                    case '4': {
                        day = 14;
                        break block32;
                    }
                    case '5': {
                        day = 15;
                        break block32;
                    }
                    case '6': {
                        day = 16;
                        break block32;
                    }
                    case '7': {
                        day = 17;
                        break block32;
                    }
                    case '8': {
                        day = 18;
                        break block32;
                    }
                    case '9': {
                        day = 19;
                        break block32;
                    }
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_DAY.get((Object)valueString, (Object)valueString.substring(6, 8));
                throw new LocalizedIllegalArgumentException(message);
            }
            case '2': {
                switch (d2) {
                    case '0': {
                        day = 20;
                        break block32;
                    }
                    case '1': {
                        day = 21;
                        break block32;
                    }
                    case '2': {
                        day = 22;
                        break block32;
                    }
                    case '3': {
                        day = 23;
                        break block32;
                    }
                    case '4': {
                        day = 24;
                        break block32;
                    }
                    case '5': {
                        day = 25;
                        break block32;
                    }
                    case '6': {
                        day = 26;
                        break block32;
                    }
                    case '7': {
                        day = 27;
                        break block32;
                    }
                    case '8': {
                        day = 28;
                        break block32;
                    }
                    case '9': {
                        day = 29;
                        break block32;
                    }
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_DAY.get((Object)valueString, (Object)valueString.substring(6, 8));
                throw new LocalizedIllegalArgumentException(message);
            }
            case '3': {
                switch (d2) {
                    case '0': {
                        day = 30;
                        break block32;
                    }
                    case '1': {
                        day = 31;
                        break block32;
                    }
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_DAY.get((Object)valueString, (Object)valueString.substring(6, 8));
                throw new LocalizedIllegalArgumentException(message);
            }
            default: {
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_DAY.get((Object)valueString, (Object)valueString.substring(6, 8));
                throw new LocalizedIllegalArgumentException(message);
            }
        }
        char h1 = valueString.charAt(8);
        char h2 = valueString.charAt(9);
        block77 : switch (h1) {
            case '0': {
                switch (h2) {
                    case '0': {
                        hour = 0;
                        break block77;
                    }
                    case '1': {
                        hour = 1;
                        break block77;
                    }
                    case '2': {
                        hour = 2;
                        break block77;
                    }
                    case '3': {
                        hour = 3;
                        break block77;
                    }
                    case '4': {
                        hour = 4;
                        break block77;
                    }
                    case '5': {
                        hour = 5;
                        break block77;
                    }
                    case '6': {
                        hour = 6;
                        break block77;
                    }
                    case '7': {
                        hour = 7;
                        break block77;
                    }
                    case '8': {
                        hour = 8;
                        break block77;
                    }
                    case '9': {
                        hour = 9;
                        break block77;
                    }
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_HOUR.get((Object)valueString, (Object)valueString.substring(8, 10));
                throw new LocalizedIllegalArgumentException(message);
            }
            case '1': {
                switch (h2) {
                    case '0': {
                        hour = 10;
                        break block77;
                    }
                    case '1': {
                        hour = 11;
                        break block77;
                    }
                    case '2': {
                        hour = 12;
                        break block77;
                    }
                    case '3': {
                        hour = 13;
                        break block77;
                    }
                    case '4': {
                        hour = 14;
                        break block77;
                    }
                    case '5': {
                        hour = 15;
                        break block77;
                    }
                    case '6': {
                        hour = 16;
                        break block77;
                    }
                    case '7': {
                        hour = 17;
                        break block77;
                    }
                    case '8': {
                        hour = 18;
                        break block77;
                    }
                    case '9': {
                        hour = 19;
                        break block77;
                    }
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_HOUR.get((Object)valueString, (Object)valueString.substring(8, 10));
                throw new LocalizedIllegalArgumentException(message);
            }
            case '2': {
                switch (h2) {
                    case '0': {
                        hour = 20;
                        break block77;
                    }
                    case '1': {
                        hour = 21;
                        break block77;
                    }
                    case '2': {
                        hour = 22;
                        break block77;
                    }
                    case '3': {
                        hour = 23;
                        break block77;
                    }
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_HOUR.get((Object)valueString, (Object)valueString.substring(8, 10));
                throw new LocalizedIllegalArgumentException(message);
            }
            default: {
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_HOUR.get((Object)valueString, (Object)valueString.substring(8, 10));
                throw new LocalizedIllegalArgumentException(message);
            }
        }
        m1 = valueString.charAt(10);
        block112 : switch (m1) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                if (length < 13) {
                    LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get((Object)valueString, (Object)String.valueOf(m1), (Object)10);
                    throw new LocalizedIllegalArgumentException(message);
                }
                minute = 10 * (m1 - 48);
                switch (valueString.charAt(11)) {
                    case '0': {
                        break block112;
                    }
                    case '1': {
                        ++minute;
                        break block112;
                    }
                    case '2': {
                        minute += 2;
                        break block112;
                    }
                    case '3': {
                        minute += 3;
                        break block112;
                    }
                    case '4': {
                        minute += 4;
                        break block112;
                    }
                    case '5': {
                        minute += 5;
                        break block112;
                    }
                    case '6': {
                        minute += 6;
                        break block112;
                    }
                    case '7': {
                        minute += 7;
                        break block112;
                    }
                    case '8': {
                        minute += 8;
                        break block112;
                    }
                    case '9': {
                        minute += 9;
                        break block112;
                    }
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_MINUTE.get((Object)valueString, (Object)valueString.substring(10, 12));
                throw new LocalizedIllegalArgumentException(message);
            }
            case 'Z': {
                if (length == 11) {
                    TimeZone tz = TIME_ZONE_UTC_OBJ;
                    return GeneralizedTime.createTime(valueString, year, month, day, hour, minute, second, tz);
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get((Object)valueString, (Object)String.valueOf(m1), (Object)10);
                throw new LocalizedIllegalArgumentException(message);
            }
            case '+': 
            case '-': {
                if (length == 13 || length == 15) {
                    TimeZone tz = GeneralizedTime.getTimeZoneForOffset(valueString, 10);
                    return GeneralizedTime.createTime(valueString, year, month, day, hour, minute, second, tz);
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get((Object)valueString, (Object)String.valueOf(m1), (Object)10);
                throw new LocalizedIllegalArgumentException(message);
            }
            case ',': 
            case '.': {
                return GeneralizedTime.finishDecodingFraction(valueString, 11, year, month, day, hour, minute, second, 3600000);
            }
            default: {
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get((Object)valueString, (Object)String.valueOf(m1), (Object)10);
                throw new LocalizedIllegalArgumentException(message);
            }
        }
        char s1 = valueString.charAt(12);
        block130 : switch (s1) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': {
                if (length < 15) {
                    LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get((Object)valueString, (Object)String.valueOf(s1), (Object)12);
                    throw new LocalizedIllegalArgumentException(message);
                }
                second = 10 * (s1 - 48);
                switch (valueString.charAt(13)) {
                    case '0': {
                        break block130;
                    }
                    case '1': {
                        ++second;
                        break block130;
                    }
                    case '2': {
                        second += 2;
                        break block130;
                    }
                    case '3': {
                        second += 3;
                        break block130;
                    }
                    case '4': {
                        second += 4;
                        break block130;
                    }
                    case '5': {
                        second += 5;
                        break block130;
                    }
                    case '6': {
                        second += 6;
                        break block130;
                    }
                    case '7': {
                        second += 7;
                        break block130;
                    }
                    case '8': {
                        second += 8;
                        break block130;
                    }
                    case '9': {
                        second += 9;
                        break block130;
                    }
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_MINUTE.get((Object)valueString, (Object)valueString.substring(12, 14));
                throw new LocalizedIllegalArgumentException(message);
            }
            case '6': {
                if (length < 15) {
                    LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get((Object)valueString, (Object)String.valueOf(s1), (Object)12);
                    throw new LocalizedIllegalArgumentException(message);
                }
                if (valueString.charAt(13) != '0') {
                    LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_SECOND.get((Object)valueString, (Object)valueString.substring(12, 14));
                    throw new LocalizedIllegalArgumentException(message);
                }
                second = 60;
                break;
            }
            case 'Z': {
                if (length == 13) {
                    TimeZone tz = TIME_ZONE_UTC_OBJ;
                    return GeneralizedTime.createTime(valueString, year, month, day, hour, minute, second, tz);
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get((Object)valueString, (Object)String.valueOf(s1), (Object)12);
                throw new LocalizedIllegalArgumentException(message);
            }
            case '+': 
            case '-': {
                if (length == 15 || length == 17) {
                    TimeZone tz = GeneralizedTime.getTimeZoneForOffset(valueString, 12);
                    return GeneralizedTime.createTime(valueString, year, month, day, hour, minute, second, tz);
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get((Object)valueString, (Object)String.valueOf(s1), (Object)12);
                throw new LocalizedIllegalArgumentException(message);
            }
            case ',': 
            case '.': {
                return GeneralizedTime.finishDecodingFraction(valueString, 13, year, month, day, hour, minute, second, 60000);
            }
            default: {
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get((Object)valueString, (Object)String.valueOf(s1), (Object)12);
                throw new LocalizedIllegalArgumentException(message);
            }
        }
        switch (valueString.charAt(14)) {
            case ',': 
            case '.': {
                return GeneralizedTime.finishDecodingFraction(valueString, 15, year, month, day, hour, minute, second, 1000);
            }
            case 'Z': {
                if (length == 15) {
                    TimeZone tz = TIME_ZONE_UTC_OBJ;
                    return GeneralizedTime.createTime(valueString, year, month, day, hour, minute, second, tz);
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get((Object)valueString, (Object)String.valueOf(valueString.charAt(14)), (Object)14);
                throw new LocalizedIllegalArgumentException(message);
            }
            case '+': 
            case '-': {
                if (length == 17 || length == 19) {
                    TimeZone tz = GeneralizedTime.getTimeZoneForOffset(valueString, 14);
                    return GeneralizedTime.createTime(valueString, year, month, day, hour, minute, second, tz);
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get((Object)valueString, (Object)String.valueOf(valueString.charAt(14)), (Object)14);
                throw new LocalizedIllegalArgumentException(message);
            }
        }
        LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_CHAR.get((Object)valueString, (Object)String.valueOf(valueString.charAt(14)), (Object)14);
        throw new LocalizedIllegalArgumentException(message);
    }

    private static GeneralizedTime createTime(String value, int year, int month, int day, int hour, int minute, int second, TimeZone tz) {
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setLenient(false);
            calendar.setTimeZone(tz);
            calendar.set(year, month, day, hour, minute, second);
            calendar.set(14, 0);
            return new GeneralizedTime(calendar, null, -1L, value);
        }
        catch (Exception e) {
            LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_TIME.get((Object)value, (Object)String.valueOf(e));
            throw new LocalizedIllegalArgumentException(message, (Throwable)e);
        }
    }

    private static GeneralizedTime finishDecodingFraction(String value, int startPos, int year, int month, int day, int hour, int minute, int second, int multiplier) {
        int length = value.length();
        StringBuilder fractionBuffer = new StringBuilder(2 + length - startPos);
        fractionBuffer.append("0.");
        TimeZone timeZone = null;
        block7: for (int i = startPos; i < length; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    fractionBuffer.append(c);
                    continue block7;
                }
                case 'Z': {
                    if (i != value.length() - 1) {
                        LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_FRACTION_CHAR.get((Object)value, (Object)String.valueOf(c));
                        throw new LocalizedIllegalArgumentException(message);
                    }
                    timeZone = TIME_ZONE_UTC_OBJ;
                    break block7;
                }
                case '+': 
                case '-': {
                    timeZone = GeneralizedTime.getTimeZoneForOffset(value, i);
                    break block7;
                }
                default: {
                    LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_FRACTION_CHAR.get((Object)value, (Object)String.valueOf(c));
                    throw new LocalizedIllegalArgumentException(message);
                }
            }
        }
        if (fractionBuffer.length() == 2) {
            LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_EMPTY_FRACTION.get((Object)value);
            throw new LocalizedIllegalArgumentException(message);
        }
        if (timeZone == null) {
            LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_NO_TIME_ZONE_INFO.get((Object)value);
            throw new LocalizedIllegalArgumentException(message);
        }
        Double fractionValue = Double.parseDouble(fractionBuffer.toString());
        int additionalMilliseconds = (int)Math.round(fractionValue * (double)multiplier);
        try {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setLenient(false);
            calendar.setTimeZone(timeZone);
            calendar.set(year, month, day, hour, minute, second);
            calendar.set(14, additionalMilliseconds);
            return new GeneralizedTime(calendar, null, -1L, value);
        }
        catch (Exception e) {
            LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_ILLEGAL_TIME.get((Object)value, (Object)String.valueOf(e));
            throw new LocalizedIllegalArgumentException(message, (Throwable)e);
        }
    }

    private static TimeZone getTimeZoneForOffset(String value, int startPos) {
        String offSetStr = value.substring(startPos);
        if (offSetStr.length() != 3 && offSetStr.length() != 5) {
            LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get((Object)value, (Object)offSetStr);
            throw new LocalizedIllegalArgumentException(message);
        }
        switch (offSetStr.charAt(0)) {
            case '+': 
            case '-': {
                break;
            }
            default: {
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get((Object)value, (Object)offSetStr);
                throw new LocalizedIllegalArgumentException(message);
            }
        }
        block3 : switch (offSetStr.charAt(1)) {
            case '0': 
            case '1': {
                switch (offSetStr.charAt(2)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        break block3;
                    }
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get((Object)value, (Object)offSetStr);
                throw new LocalizedIllegalArgumentException(message);
            }
            case '2': {
                switch (offSetStr.charAt(2)) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': {
                        break block3;
                    }
                }
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get((Object)value, (Object)offSetStr);
                throw new LocalizedIllegalArgumentException(message);
            }
            default: {
                LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get((Object)value, (Object)offSetStr);
                throw new LocalizedIllegalArgumentException(message);
            }
        }
        if (offSetStr.length() == 5) {
            block13 : switch (offSetStr.charAt(3)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': {
                    switch (offSetStr.charAt(4)) {
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            break block13;
                        }
                    }
                    LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get((Object)value, (Object)offSetStr);
                    throw new LocalizedIllegalArgumentException(message);
                }
                default: {
                    LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_GENERALIZED_TIME_INVALID_OFFSET.get((Object)value, (Object)offSetStr);
                    throw new LocalizedIllegalArgumentException(message);
                }
            }
        }
        return TimeZone.getTimeZone("GMT" + offSetStr);
    }

    private GeneralizedTime(Calendar calendar, Date date, long time, String stringValue) {
        this.calendar = calendar;
        this.date = date;
        this.timeMS = time;
        this.stringValue = stringValue;
    }

    @Override
    public int compareTo(GeneralizedTime o) {
        Long timeMS1 = this.getTimeInMillis();
        Long timeMS2 = o.getTimeInMillis();
        return timeMS1.compareTo(timeMS2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GeneralizedTime) {
            return this.getTimeInMillis() == ((GeneralizedTime)obj).getTimeInMillis();
        }
        return false;
    }

    public long getTimeInMillis() {
        long tmpTimeMS = this.timeMS;
        if (tmpTimeMS == -1L) {
            tmpTimeMS = this.date != null ? this.date.getTime() : this.calendar.getTimeInMillis();
            this.timeMS = tmpTimeMS;
        }
        return tmpTimeMS;
    }

    public int hashCode() {
        return Long.valueOf(this.getTimeInMillis()).hashCode();
    }

    public Calendar toCalendar() {
        return (Calendar)this.getCalendar().clone();
    }

    public Date toDate() {
        Date tmpDate = this.date;
        if (tmpDate == null) {
            this.date = tmpDate = new Date(this.getTimeInMillis());
        }
        return (Date)tmpDate.clone();
    }

    public String toString() {
        String tmpString = this.stringValue;
        if (tmpString == null) {
            StringBuilder sb = new StringBuilder(19);
            Calendar tmpCalendar = this.getCalendar();
            int n = tmpCalendar.get(1);
            if (n < 0) {
                throw new IllegalArgumentException("Year cannot be < 0:" + n);
            }
            if (n < 10) {
                sb.append("000");
            } else if (n < 100) {
                sb.append("00");
            } else if (n < 1000) {
                sb.append("0");
            }
            sb.append(n);
            n = tmpCalendar.get(2) + 1;
            if (n < 10) {
                sb.append("0");
            }
            sb.append(n);
            n = tmpCalendar.get(5);
            if (n < 10) {
                sb.append("0");
            }
            sb.append(n);
            n = tmpCalendar.get(11);
            if (n < 10) {
                sb.append("0");
            }
            sb.append(n);
            n = tmpCalendar.get(12);
            if (n < 10) {
                sb.append("0");
            }
            sb.append(n);
            n = tmpCalendar.get(13);
            if (n < 10) {
                sb.append("0");
            }
            sb.append(n);
            n = tmpCalendar.get(14);
            if (n != 0) {
                sb.append('.');
                if (n < 10) {
                    sb.append("00");
                } else if (n < 100) {
                    sb.append("0");
                }
                sb.append(n);
            }
            if ((n = tmpCalendar.get(15) + tmpCalendar.get(16)) == 0) {
                sb.append('Z');
            } else {
                if (n < 0) {
                    sb.append('-');
                    n = -n;
                } else {
                    sb.append('+');
                }
                int h = (n /= 60000) / 60;
                if (h < 10) {
                    sb.append("0");
                }
                sb.append(h);
                int m = n % 60;
                if (m < 10) {
                    sb.append("0");
                }
                sb.append(m);
            }
            this.stringValue = tmpString = sb.toString();
        }
        return tmpString;
    }

    private Calendar getCalendar() {
        Calendar tmpCalendar = this.calendar;
        if (tmpCalendar == null) {
            tmpCalendar = new GregorianCalendar(TIME_ZONE_UTC_OBJ);
            tmpCalendar.setLenient(false);
            tmpCalendar.setTimeInMillis(this.getTimeInMillis());
            this.calendar = tmpCalendar;
        }
        return tmpCalendar;
    }
}

