/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.StaticUtils;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Function;
import org.forgerock.opendj.ldap.GeneralizedTime;
import org.forgerock.opendj.ldap.schema.Schema;

public final class Functions {
    private static final Function<ByteString, String, Void> BYTESTRING_TO_STRING = new Function<ByteString, String, Void>(){

        @Override
        public String apply(ByteString value, Void p) {
            return value.toString();
        }
    };
    private static final Function<Object, Object, Void> IDENTITY = new Function<Object, Object, Void>(){

        @Override
        public Object apply(Object value, Void p) {
            return value;
        }
    };
    private static final Function<String, String, Void> NORMALIZE_STRING = new Function<String, String, Void>(){

        @Override
        public String apply(String value, Void p) {
            return StaticUtils.toLowerCase(value).trim();
        }
    };
    private static final Function<Object, ByteString, Void> OBJECT_TO_BYTESTRING = new Function<Object, ByteString, Void>(){

        @Override
        public ByteString apply(Object value, Void p) {
            return ByteString.valueOf(value);
        }
    };
    private static final Function<String, AttributeDescription, Schema> STRING_TO_ATTRIBUTE_DESCRIPTION = new Function<String, AttributeDescription, Schema>(){

        @Override
        public AttributeDescription apply(String value, Schema p) {
            return AttributeDescription.valueOf(value, p);
        }
    };
    private static final Function<String, Boolean, Void> STRING_TO_BOOLEAN = new Function<String, Boolean, Void>(){

        @Override
        public Boolean apply(String value, Void p) {
            String valueString = StaticUtils.toLowerCase(value);
            if (valueString.equals("true") || valueString.equals("yes") || valueString.equals("on") || valueString.equals("1")) {
                return Boolean.TRUE;
            }
            if (valueString.equals("false") || valueString.equals("no") || valueString.equals("off") || valueString.equals("0")) {
                return Boolean.FALSE;
            }
            LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_ILLEGAL_BOOLEAN.get((Object)valueString);
            throw new LocalizedIllegalArgumentException(message);
        }
    };
    private static final Function<String, DN, Schema> STRING_TO_DN = new Function<String, DN, Schema>(){

        @Override
        public DN apply(String value, Schema p) {
            return DN.valueOf(value, p);
        }
    };
    private static final Function<String, GeneralizedTime, Void> STRING_TO_GENERALIZED_TIME = new Function<String, GeneralizedTime, Void>(){

        @Override
        public GeneralizedTime apply(String value, Void p) {
            return GeneralizedTime.valueOf(value);
        }
    };
    private static final Function<String, Integer, Void> STRING_TO_INTEGER = new Function<String, Integer, Void>(){

        @Override
        public Integer apply(String value, Void p) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                LocalizableMessage message = CoreMessages.FUNCTIONS_TO_INTEGER_FAIL.get((Object)value);
                throw new LocalizedIllegalArgumentException(message);
            }
        }
    };
    private static final Function<String, Long, Void> STRING_TO_LONG = new Function<String, Long, Void>(){

        @Override
        public Long apply(String value, Void p) {
            try {
                return Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                LocalizableMessage message = CoreMessages.FUNCTIONS_TO_LONG_FAIL.get((Object)value);
                throw new LocalizedIllegalArgumentException(message);
            }
        }
    };
    private static final Function<ByteString, AttributeDescription, Schema> BYTESTRING_TO_ATTRIBUTE_DESCRIPTION = Functions.composeSecondP(Functions.byteStringToString(), STRING_TO_ATTRIBUTE_DESCRIPTION);
    private static final Function<ByteString, Boolean, Void> BYTESTRING_TO_BOOLEAN = Functions.compose(Functions.byteStringToString(), STRING_TO_BOOLEAN);
    private static final Function<ByteString, DN, Schema> BYTESTRING_TO_DN = Functions.composeSecondP(Functions.byteStringToString(), STRING_TO_DN);
    private static final Function<ByteString, GeneralizedTime, Void> BYTESTRING_TO_GENERALIZED_TIME = Functions.compose(Functions.byteStringToString(), STRING_TO_GENERALIZED_TIME);
    private static final Function<ByteString, Integer, Void> BYTESTRING_TO_INTEGER = Functions.compose(Functions.byteStringToString(), STRING_TO_INTEGER);
    private static final Function<ByteString, Long, Void> BYTESTRING_TO_LONG = Functions.compose(Functions.byteStringToString(), STRING_TO_LONG);

    public static <M, X, N> Function<M, N, Void> compose(final Function<M, X, Void> first, final Function<X, N, Void> second) {
        return new Function<M, N, Void>(){

            @Override
            public N apply(M value, Void p) {
                Object tmp = first.apply(value, p);
                return second.apply(tmp, p);
            }
        };
    }

    public static <M, X, N, P> Function<M, N, P> composeFirstP(final Function<M, X, P> first, final Function<X, N, Void> second) {
        return new Function<M, N, P>(){

            @Override
            public N apply(M value, P p) {
                Object tmp = first.apply(value, p);
                return second.apply(tmp, null);
            }
        };
    }

    public static <M, X, N, P> Function<M, N, P> composeSecondP(final Function<M, X, Void> first, final Function<X, N, P> second) {
        return new Function<M, N, P>(){

            @Override
            public N apply(M value, P p) {
                Object tmp = first.apply(value, null);
                return second.apply(tmp, p);
            }
        };
    }

    public static <M, N, P> Function<M, N, Void> fixedFunction(Function<M, N, P> function, P p) {
        return new FixedFunction(function, p);
    }

    public static <M> Function<M, M, Void> identityFunction() {
        return IDENTITY;
    }

    public static Function<String, String, Void> normalizeString() {
        return NORMALIZE_STRING;
    }

    public static Function<Object, ByteString, Void> objectToByteString() {
        return OBJECT_TO_BYTESTRING;
    }

    public static Function<String, AttributeDescription, Void> stringToAttributeDescription() {
        return Functions.fixedFunction(STRING_TO_ATTRIBUTE_DESCRIPTION, Schema.getDefaultSchema());
    }

    public static Function<String, AttributeDescription, Void> stringToAttributeDescription(Schema schema) {
        return Functions.fixedFunction(STRING_TO_ATTRIBUTE_DESCRIPTION, schema);
    }

    public static Function<String, Boolean, Void> stringToBoolean() {
        return STRING_TO_BOOLEAN;
    }

    public static Function<String, DN, Void> stringToDN() {
        return Functions.fixedFunction(STRING_TO_DN, Schema.getDefaultSchema());
    }

    public static Function<String, DN, Void> stringToDN(Schema schema) {
        return Functions.fixedFunction(STRING_TO_DN, schema);
    }

    public static Function<String, GeneralizedTime, Void> stringToGeneralizedTime() {
        return STRING_TO_GENERALIZED_TIME;
    }

    public static Function<String, Integer, Void> stringToInteger() {
        return STRING_TO_INTEGER;
    }

    public static Function<String, Long, Void> stringToLong() {
        return STRING_TO_LONG;
    }

    public static Function<ByteString, AttributeDescription, Void> byteStringToAttributeDescription() {
        return Functions.fixedFunction(BYTESTRING_TO_ATTRIBUTE_DESCRIPTION, Schema.getDefaultSchema());
    }

    public static Function<ByteString, AttributeDescription, Void> byteStringToAttributeDescription(Schema schema) {
        return Functions.fixedFunction(BYTESTRING_TO_ATTRIBUTE_DESCRIPTION, schema);
    }

    public static Function<ByteString, Boolean, Void> byteStringToBoolean() {
        return BYTESTRING_TO_BOOLEAN;
    }

    public static Function<ByteString, DN, Void> byteStringToDN() {
        return Functions.fixedFunction(BYTESTRING_TO_DN, Schema.getDefaultSchema());
    }

    public static Function<ByteString, DN, Void> byteStringToDN(Schema schema) {
        return Functions.fixedFunction(BYTESTRING_TO_DN, schema);
    }

    public static Function<ByteString, GeneralizedTime, Void> byteStringToGeneralizedTime() {
        return BYTESTRING_TO_GENERALIZED_TIME;
    }

    public static Function<ByteString, Integer, Void> byteStringToInteger() {
        return BYTESTRING_TO_INTEGER;
    }

    public static Function<ByteString, Long, Void> byteStringToLong() {
        return BYTESTRING_TO_LONG;
    }

    public static Function<ByteString, String, Void> byteStringToString() {
        return BYTESTRING_TO_STRING;
    }

    private Functions() {
    }

    private static final class FixedFunction<M, N, P>
    implements Function<M, N, Void> {
        private final Function<M, N, P> function;
        private final P parameter;

        private FixedFunction(Function<M, N, P> function, P p) {
            this.function = function;
            this.parameter = p;
        }

        @Override
        public N apply(M value, Void p) {
            return this.function.apply(value, this.parameter);
        }
    }
}

