/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.concurrent.ExecutionException;
import org.forgerock.opendj.ldap.AssertionFailureException;
import org.forgerock.opendj.ldap.AuthenticationException;
import org.forgerock.opendj.ldap.AuthorizationException;
import org.forgerock.opendj.ldap.CancelledResultException;
import org.forgerock.opendj.ldap.ConnectionException;
import org.forgerock.opendj.ldap.ConstraintViolationException;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.MultipleEntriesFoundException;
import org.forgerock.opendj.ldap.ReferralException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.TimeoutResultException;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;

public class ErrorResultException
extends ExecutionException {
    private final Result result;

    public static ErrorResultException newErrorResult(ResultCode resultCode) {
        return ErrorResultException.newErrorResult(resultCode, null, null);
    }

    public static ErrorResultException newErrorResult(ResultCode resultCode, String diagnosticMessage) {
        return ErrorResultException.newErrorResult(resultCode, diagnosticMessage, null);
    }

    public static ErrorResultException newErrorResult(ResultCode resultCode, Throwable cause) {
        return ErrorResultException.newErrorResult(resultCode, null, cause);
    }

    public static ErrorResultException newErrorResult(ResultCode resultCode, String diagnosticMessage, Throwable cause) {
        Result result = Responses.newResult(resultCode);
        if (diagnosticMessage != null) {
            result.setDiagnosticMessage(diagnosticMessage);
        } else if (cause != null) {
            result.setDiagnosticMessage(cause.getLocalizedMessage());
        }
        result.setCause(cause);
        return ErrorResultException.newErrorResult(result);
    }

    public static ErrorResultException newErrorResult(Result result) {
        if (!result.getResultCode().isExceptional()) {
            throw new IllegalArgumentException("Attempted to wrap a successful result: " + result);
        }
        ResultCode rc = result.getResultCode();
        if (rc == ResultCode.ASSERTION_FAILED) {
            return new AssertionFailureException(result);
        }
        if (rc == ResultCode.AUTH_METHOD_NOT_SUPPORTED || rc == ResultCode.CLIENT_SIDE_AUTH_UNKNOWN || rc == ResultCode.INAPPROPRIATE_AUTHENTICATION || rc == ResultCode.INVALID_CREDENTIALS) {
            return new AuthenticationException(result);
        }
        if (rc == ResultCode.AUTHORIZATION_DENIED || rc == ResultCode.CONFIDENTIALITY_REQUIRED || rc == ResultCode.INSUFFICIENT_ACCESS_RIGHTS || rc == ResultCode.STRONG_AUTH_REQUIRED) {
            return new AuthorizationException(result);
        }
        if (rc == ResultCode.CLIENT_SIDE_USER_CANCELLED || rc == ResultCode.CANCELLED) {
            return new CancelledResultException(result);
        }
        if (rc == ResultCode.CLIENT_SIDE_SERVER_DOWN || rc == ResultCode.CLIENT_SIDE_CONNECT_ERROR || rc == ResultCode.CLIENT_SIDE_DECODING_ERROR || rc == ResultCode.CLIENT_SIDE_ENCODING_ERROR) {
            return new ConnectionException(result);
        }
        if (rc == ResultCode.ATTRIBUTE_OR_VALUE_EXISTS || rc == ResultCode.NO_SUCH_ATTRIBUTE || rc == ResultCode.CONSTRAINT_VIOLATION || rc == ResultCode.ENTRY_ALREADY_EXISTS || rc == ResultCode.INVALID_ATTRIBUTE_SYNTAX || rc == ResultCode.INVALID_DN_SYNTAX || rc == ResultCode.NAMING_VIOLATION || rc == ResultCode.NOT_ALLOWED_ON_NONLEAF || rc == ResultCode.NOT_ALLOWED_ON_RDN || rc == ResultCode.OBJECTCLASS_MODS_PROHIBITED || rc == ResultCode.OBJECTCLASS_VIOLATION || rc == ResultCode.UNDEFINED_ATTRIBUTE_TYPE) {
            return new ConstraintViolationException(result);
        }
        if (rc == ResultCode.REFERRAL) {
            return new ReferralException(result);
        }
        if (rc == ResultCode.NO_SUCH_OBJECT || rc == ResultCode.CLIENT_SIDE_NO_RESULTS_RETURNED) {
            return new EntryNotFoundException(result);
        }
        if (rc == ResultCode.CLIENT_SIDE_UNEXPECTED_RESULTS_RETURNED) {
            return new MultipleEntriesFoundException(result);
        }
        if (rc == ResultCode.CLIENT_SIDE_TIMEOUT || rc == ResultCode.TIME_LIMIT_EXCEEDED) {
            return new TimeoutResultException(result);
        }
        return new ErrorResultException(result);
    }

    private static String getMessage(Result result) {
        if (result.getDiagnosticMessage() == null || result.getDiagnosticMessage().isEmpty()) {
            return result.getResultCode().toString();
        }
        return result.getResultCode() + ": " + result.getDiagnosticMessage();
    }

    protected ErrorResultException(Result result) {
        super(ErrorResultException.getMessage(result), result.getCause());
        this.result = result;
    }

    public final Result getResult() {
        return this.result;
    }
}

