/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.Validator;
import org.forgerock.opendj.ldap.AttributeFactory;
import org.forgerock.opendj.ldap.EntryFactory;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.SchemaResolver;
import org.forgerock.opendj.ldap.schema.Schema;

public final class DecodeOptions {
    private SchemaResolver schemaResolver;
    private EntryFactory entryFactory;
    private AttributeFactory attributeFactory;

    public DecodeOptions() {
        this.attributeFactory = LinkedAttribute.FACTORY;
        this.entryFactory = LinkedHashMapEntry.FACTORY;
        this.schemaResolver = SchemaResolver.DEFAULT;
    }

    public DecodeOptions(DecodeOptions options) {
        this.attributeFactory = options.attributeFactory;
        this.entryFactory = options.entryFactory;
        this.schemaResolver = options.schemaResolver;
    }

    public final AttributeFactory getAttributeFactory() {
        return this.attributeFactory;
    }

    public final EntryFactory getEntryFactory() {
        return this.entryFactory;
    }

    public final SchemaResolver getSchemaResolver() {
        return this.schemaResolver;
    }

    public final DecodeOptions setAttributeFactory(AttributeFactory factory) {
        Validator.ensureNotNull(factory);
        this.attributeFactory = factory;
        return this;
    }

    public final DecodeOptions setEntryFactory(EntryFactory factory) {
        Validator.ensureNotNull(factory);
        this.entryFactory = factory;
        return this;
    }

    public final DecodeOptions setSchema(Schema schema) {
        Validator.ensureNotNull(schema);
        this.schemaResolver = new FixedSchemaResolver(schema);
        return this;
    }

    public final DecodeOptions setSchemaResolver(SchemaResolver resolver) {
        Validator.ensureNotNull(resolver);
        this.schemaResolver = resolver;
        return this;
    }

    private static final class FixedSchemaResolver
    implements SchemaResolver {
        private final Schema schema;

        private FixedSchemaResolver(Schema schema) {
            this.schema = schema;
        }

        @Override
        public Schema resolveSchema(String dn) {
            return this.schema;
        }
    }
}

