/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.logging.Level;
import org.forgerock.opendj.ldap.Base64;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteSequenceReader;
import org.forgerock.opendj.ldap.ByteStringBuilder;

public final class ByteString
implements ByteSequence {
    private static final ByteString EMPTY = ByteString.wrap(new byte[0]);
    final byte[] buffer;
    final int length;
    final int offset;

    public static ByteString empty() {
        return EMPTY;
    }

    public static ByteString valueOf(int i) {
        byte[] bytes = new byte[4];
        for (int j = 3; j >= 0; --j) {
            bytes[j] = (byte)(i & 0xFF);
            i >>>= 8;
        }
        return ByteString.wrap(bytes);
    }

    public static ByteString valueOf(long l) {
        byte[] bytes = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bytes[i] = (byte)(l & 0xFFL);
            l >>>= 8;
        }
        return ByteString.wrap(bytes);
    }

    public static ByteString valueOf(Object o) {
        if (o instanceof ByteSequence) {
            return ((ByteSequence)o).toByteString();
        }
        if (o instanceof byte[]) {
            return ByteString.valueOf((byte[])o);
        }
        if (o instanceof char[]) {
            return ByteString.valueOf((char[])o);
        }
        return ByteString.valueOf(o.toString());
    }

    public static ByteString valueOf(String s) {
        return ByteString.wrap(StaticUtils.getBytes(s));
    }

    public static ByteString valueOfBase64(String s) {
        return Base64.decode(s);
    }

    public static ByteString valueOf(byte[] bytes) {
        return ByteString.wrap(Arrays.copyOf(bytes, bytes.length));
    }

    public static ByteString valueOf(char[] chars) {
        return ByteString.wrap(StaticUtils.getBytes(chars));
    }

    public static ByteString wrap(byte[] bytes) {
        return new ByteString(bytes, 0, bytes.length);
    }

    public static ByteString wrap(byte[] bytes, int offset, int length) {
        ByteString.checkArrayBounds(bytes, offset, length);
        return new ByteString(bytes, offset, length);
    }

    static void checkArrayBounds(byte[] b, int offset, int length) {
        if (offset < 0 || offset > b.length || length < 0 || offset + length > b.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    static int compareTo(byte[] b1, int offset1, int length1, byte[] b2, int offset2, int length2) {
        int count = Math.min(length1, length2);
        int i = offset1;
        int j = offset2;
        while (count-- != 0) {
            int secondByte;
            int firstByte;
            if ((firstByte = 0xFF & b1[i++]) == (secondByte = 0xFF & b2[j++])) continue;
            return firstByte - secondByte;
        }
        return length1 - length2;
    }

    static boolean equals(byte[] b1, int offset1, int length1, byte[] b2, int offset2, int length2) {
        if (length1 != length2) {
            return false;
        }
        int i = offset1;
        int j = offset2;
        int count = length1;
        while (count-- != 0) {
            if (b1[i++] == b2[j++]) continue;
            return false;
        }
        return true;
    }

    static int hashCode(byte[] b, int offset, int length) {
        int hashCode = 1;
        int i = offset;
        int count = length;
        while (count-- != 0) {
            hashCode = 31 * hashCode + b[i++];
        }
        return hashCode;
    }

    static String toString(byte[] b, int offset, int length) {
        String stringValue;
        try {
            stringValue = new String(b, offset, length, "UTF-8");
        }
        catch (Exception e) {
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                StaticUtils.DEBUG_LOG.warning("Unable to decode ByteString bytes as UTF-8 string: " + e.toString());
            }
            stringValue = new String(b, offset, length);
        }
        return stringValue;
    }

    private ByteString(byte[] b, int offset, int length) {
        this.buffer = b;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public ByteSequenceReader asReader() {
        return new ByteSequenceReader(this);
    }

    @Override
    public byte byteAt(int index) {
        if (index >= this.length || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[this.offset + index];
    }

    @Override
    public int compareTo(byte[] bytes, int offset, int length) {
        ByteString.checkArrayBounds(bytes, offset, length);
        return ByteString.compareTo(this.buffer, this.offset, this.length, bytes, offset, length);
    }

    @Override
    public int compareTo(ByteSequence o) {
        if (this == o) {
            return 0;
        }
        return -o.compareTo(this.buffer, this.offset, this.length);
    }

    @Override
    public byte[] copyTo(byte[] bytes) {
        this.copyTo(bytes, 0);
        return bytes;
    }

    @Override
    public byte[] copyTo(byte[] bytes, int offset) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.buffer, this.offset, bytes, offset, Math.min(this.length, bytes.length - offset));
        return bytes;
    }

    @Override
    public ByteStringBuilder copyTo(ByteStringBuilder builder) {
        builder.append(this.buffer, this.offset, this.length);
        return builder;
    }

    @Override
    public OutputStream copyTo(OutputStream stream) throws IOException {
        stream.write(this.buffer, this.offset, this.length);
        return stream;
    }

    @Override
    public boolean equals(byte[] bytes, int offset, int length) {
        ByteString.checkArrayBounds(bytes, offset, length);
        return ByteString.equals(this.buffer, this.offset, this.length, bytes, offset, length);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ByteSequence) {
            ByteSequence other = (ByteSequence)o;
            return other.equals(this.buffer, this.offset, this.length);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ByteString.hashCode(this.buffer, this.offset, this.length);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public ByteString subSequence(int start, int end) {
        if (start < 0 || start > end || end > this.length) {
            throw new IndexOutOfBoundsException();
        }
        return new ByteString(this.buffer, this.offset + start, end - start);
    }

    @Override
    public String toBase64String() {
        return Base64.encode(this);
    }

    @Override
    public byte[] toByteArray() {
        return this.copyTo(new byte[this.length]);
    }

    @Override
    public ByteString toByteString() {
        return this;
    }

    public char[] toCharArray() {
        Charset utf8 = Charset.forName("UTF-8");
        CharBuffer charBuffer = utf8.decode(ByteBuffer.wrap(this.buffer, this.offset, this.length));
        char[] chars = new char[charBuffer.remaining()];
        charBuffer.get(chars);
        return chars;
    }

    public int toInt() {
        if (this.length < 4) {
            throw new IndexOutOfBoundsException();
        }
        int v = 0;
        for (int i = 0; i < 4; ++i) {
            v <<= 8;
            v |= this.buffer[this.offset + i] & 0xFF;
        }
        return v;
    }

    public long toLong() {
        if (this.length < 8) {
            throw new IndexOutOfBoundsException();
        }
        long v = 0L;
        for (int i = 0; i < 8; ++i) {
            v <<= 8;
            v |= (long)(this.buffer[this.offset + i] & 0xFF);
        }
        return v;
    }

    @Override
    public String toString() {
        return ByteString.toString(this.buffer, this.offset, this.length);
    }
}

