/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.FutureResultTransformer;
import com.forgerock.opendj.util.RecursiveFutureResult;
import org.forgerock.opendj.ldap.AbstractConnectionWrapper;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;

final class AuthenticatedConnectionFactory
implements ConnectionFactory {
    private final BindRequest request;
    private final ConnectionFactory parentFactory;

    AuthenticatedConnectionFactory(ConnectionFactory factory, BindRequest request) {
        this.parentFactory = factory;
        this.request = request;
    }

    @Override
    public void close() {
        this.parentFactory.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws ErrorResultException {
        Connection connection = this.parentFactory.getConnection();
        boolean bindSucceeded = false;
        try {
            connection.bind(this.request);
            bindSucceeded = true;
        }
        finally {
            if (!bindSucceeded) {
                connection.close();
            }
        }
        return new AuthenticatedConnection(connection);
    }

    @Override
    public FutureResult<Connection> getConnectionAsync(ResultHandler<? super Connection> handler) {
        FutureResultImpl future = new FutureResultImpl(this.request, handler);
        future.futureConnectionResult.setFutureResult(this.parentFactory.getConnectionAsync(future.futureConnectionResult));
        return future.futureBindResult;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AuthenticatedConnectionFactory(");
        builder.append(String.valueOf(this.parentFactory));
        builder.append(", ");
        builder.append(this.request);
        builder.append(')');
        return builder.toString();
    }

    private static final class FutureResultImpl {
        private final FutureResultTransformer<BindResult, Connection> futureBindResult;
        private final RecursiveFutureResult<Connection, BindResult> futureConnectionResult;
        private final BindRequest bindRequest;
        private Connection connection;

        private FutureResultImpl(BindRequest request, ResultHandler<? super Connection> handler) {
            this.bindRequest = request;
            this.futureBindResult = new FutureResultTransformer<BindResult, Connection>(handler){

                @Override
                protected ErrorResultException transformErrorResult(ErrorResultException errorResult) {
                    if (FutureResultImpl.this.connection != null) {
                        FutureResultImpl.this.connection.close();
                        FutureResultImpl.this.connection = null;
                    }
                    return errorResult;
                }

                @Override
                protected Connection transformResult(BindResult result) throws ErrorResultException {
                    return new AuthenticatedConnection(FutureResultImpl.this.connection);
                }
            };
            this.futureConnectionResult = new RecursiveFutureResult<Connection, BindResult>(this.futureBindResult){

                @Override
                protected FutureResult<? extends BindResult> chainResult(Connection innerResult, ResultHandler<? super BindResult> handler) throws ErrorResultException {
                    FutureResultImpl.this.connection = innerResult;
                    return FutureResultImpl.this.connection.bindAsync(FutureResultImpl.this.bindRequest, null, handler);
                }
            };
            this.futureBindResult.setFutureResult(this.futureConnectionResult);
        }
    }

    public static final class AuthenticatedConnection
    extends AbstractConnectionWrapper<Connection> {
        private AuthenticatedConnection(Connection connection) {
            super(connection);
        }

        @Override
        public FutureResult<BindResult> bindAsync(BindRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super BindResult> resultHandler) {
            throw new UnsupportedOperationException();
        }

        @Override
        public BindResult bind(BindRequest request) throws ErrorResultException {
            throw new UnsupportedOperationException();
        }

        @Override
        public BindResult bind(String name, char[] password) throws ErrorResultException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("AuthenticatedConnection(");
            builder.append(this.connection);
            builder.append(')');
            return builder.toString();
        }
    }
}

