/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.Validator;
import java.util.Collection;
import java.util.Map;
import org.forgerock.opendj.ldap.AbstractEntry;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;

abstract class AbstractMapEntry
extends AbstractEntry {
    private final Map<AttributeDescription, Attribute> attributes;
    private DN name;

    AbstractMapEntry(DN name, Map<AttributeDescription, Attribute> attributes) {
        this.name = name;
        this.attributes = attributes;
    }

    @Override
    public final boolean addAttribute(Attribute attribute, Collection<? super ByteString> duplicateValues) {
        AttributeDescription attributeDescription = attribute.getAttributeDescription();
        Attribute oldAttribute = this.getAttribute(attributeDescription);
        if (oldAttribute != null) {
            return oldAttribute.addAll(attribute, duplicateValues);
        }
        this.attributes.put(attributeDescription, attribute);
        return true;
    }

    @Override
    public final Entry clearAttributes() {
        this.attributes.clear();
        return this;
    }

    @Override
    public final Iterable<Attribute> getAllAttributes() {
        return this.attributes.values();
    }

    @Override
    public final Attribute getAttribute(AttributeDescription attributeDescription) {
        Attribute attribute = this.attributes.get(attributeDescription);
        if (attribute == null && attributeDescription.isPlaceHolder()) {
            return super.getAttribute(attributeDescription);
        }
        return attribute;
    }

    @Override
    public final int getAttributeCount() {
        return this.attributes.size();
    }

    @Override
    public final DN getName() {
        return this.name;
    }

    @Override
    public final boolean removeAttribute(Attribute attribute, Collection<? super ByteString> missingValues) {
        AttributeDescription attributeDescription = attribute.getAttributeDescription();
        if (attribute.isEmpty()) {
            if (this.attributes.remove(attributeDescription) != null) {
                return true;
            }
            if (attributeDescription.isPlaceHolder()) {
                return super.removeAttribute(attribute, missingValues);
            }
            return false;
        }
        Attribute oldAttribute = this.getAttribute(attributeDescription);
        if (oldAttribute != null) {
            boolean modified = oldAttribute.removeAll(attribute, missingValues);
            if (oldAttribute.isEmpty()) {
                this.attributes.remove(oldAttribute.getAttributeDescription());
                return true;
            }
            return modified;
        }
        if (missingValues != null) {
            missingValues.addAll(attribute);
        }
        return false;
    }

    @Override
    public final Entry setName(DN dn) {
        Validator.ensureNotNull(dn);
        this.name = dn;
        return this;
    }
}

