/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.Iterables;
import com.forgerock.opendj.util.Predicate;
import com.forgerock.opendj.util.Validator;
import java.util.Collection;
import java.util.Iterator;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.AttributeParser;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedAttribute;

public abstract class AbstractEntry
implements Entry {
    private static final Predicate<Attribute, AttributeDescription> FIND_ATTRIBUTES_PREDICATE = new Predicate<Attribute, AttributeDescription>(){

        @Override
        public boolean matches(Attribute value, AttributeDescription p) {
            return value.getAttributeDescription().isSubTypeOf(p);
        }
    };

    protected AbstractEntry() {
    }

    @Override
    public boolean addAttribute(Attribute attribute) {
        return this.addAttribute(attribute, null);
    }

    @Override
    public Entry addAttribute(String attributeDescription, Object ... values) {
        this.addAttribute(new LinkedAttribute(attributeDescription, values), null);
        return this;
    }

    @Override
    public boolean containsAttribute(Attribute attribute, Collection<? super ByteString> missingValues) {
        Attribute a = this.getAttribute(attribute.getAttributeDescription());
        if (a == null) {
            if (missingValues != null) {
                missingValues.addAll(attribute);
            }
            return false;
        }
        boolean result = true;
        for (ByteString value : attribute) {
            if (a.contains(value)) continue;
            if (missingValues != null) {
                missingValues.add(value);
            }
            result = false;
        }
        return result;
    }

    @Override
    public boolean containsAttribute(String attributeDescription, Object ... values) {
        return this.containsAttribute(new LinkedAttribute(attributeDescription, values), null);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Entry) {
            Entry other = (Entry)object;
            if (!this.getName().equals(other.getName())) {
                return false;
            }
            if (this.getAttributeCount() != other.getAttributeCount()) {
                return false;
            }
            for (Attribute attribute : this.getAllAttributes()) {
                Attribute otherAttribute;
                if (attribute.equals(otherAttribute = other.getAttribute(attribute.getAttributeDescription()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Iterable<Attribute> getAllAttributes(AttributeDescription attributeDescription) {
        Validator.ensureNotNull(attributeDescription);
        return Iterables.filteredIterable(this.getAllAttributes(), FIND_ATTRIBUTES_PREDICATE, attributeDescription);
    }

    @Override
    public Iterable<Attribute> getAllAttributes(String attributeDescription) {
        return this.getAllAttributes(AttributeDescription.valueOf(attributeDescription));
    }

    @Override
    public Attribute getAttribute(AttributeDescription attributeDescription) {
        for (Attribute attribute : this.getAllAttributes()) {
            AttributeDescription ad = attribute.getAttributeDescription();
            if (!this.isAssignable(attributeDescription, ad)) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public Attribute getAttribute(String attributeDescription) {
        return this.getAttribute(AttributeDescription.valueOf(attributeDescription));
    }

    @Override
    public int hashCode() {
        int hashCode = this.getName().hashCode();
        for (Attribute attribute : this.getAllAttributes()) {
            hashCode += attribute.hashCode();
        }
        return hashCode;
    }

    @Override
    public AttributeParser parseAttribute(AttributeDescription attributeDescription) {
        return AttributeParser.parseAttribute(this.getAttribute(attributeDescription));
    }

    @Override
    public AttributeParser parseAttribute(String attributeDescription) {
        return AttributeParser.parseAttribute(this.getAttribute(attributeDescription));
    }

    @Override
    public boolean removeAttribute(Attribute attribute, Collection<? super ByteString> missingValues) {
        Iterator<Attribute> i = this.getAllAttributes().iterator();
        AttributeDescription attributeDescription = attribute.getAttributeDescription();
        while (i.hasNext()) {
            Attribute oldAttribute = i.next();
            if (!this.isAssignable(attributeDescription, oldAttribute.getAttributeDescription())) continue;
            if (attribute.isEmpty()) {
                i.remove();
                return true;
            }
            boolean modified = oldAttribute.removeAll(attribute, missingValues);
            if (oldAttribute.isEmpty()) {
                i.remove();
                return true;
            }
            return modified;
        }
        if (missingValues != null) {
            missingValues.addAll(attribute);
        }
        return false;
    }

    @Override
    public boolean removeAttribute(AttributeDescription attributeDescription) {
        return this.removeAttribute(Attributes.emptyAttribute(attributeDescription), null);
    }

    @Override
    public Entry removeAttribute(String attributeDescription, Object ... values) {
        this.removeAttribute(new LinkedAttribute(attributeDescription, values), null);
        return this;
    }

    @Override
    public boolean replaceAttribute(Attribute attribute) {
        if (attribute.isEmpty()) {
            return this.removeAttribute(attribute.getAttributeDescription());
        }
        Attribute oldAttribute = this.getAttribute(attribute.getAttributeDescription());
        if (oldAttribute != null) {
            oldAttribute.clear();
            oldAttribute.addAll(attribute);
        } else {
            this.addAttribute(attribute, null);
        }
        return true;
    }

    @Override
    public Entry replaceAttribute(String attributeDescription, Object ... values) {
        this.replaceAttribute(new LinkedAttribute(attributeDescription, values));
        return this;
    }

    @Override
    public Entry setName(String dn) {
        return this.setName(DN.valueOf(dn));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('\"');
        builder.append(this.getName());
        builder.append("\":{");
        boolean firstValue = true;
        for (Attribute attribute : this.getAllAttributes()) {
            if (!firstValue) {
                builder.append(',');
            }
            builder.append(attribute);
            firstValue = false;
        }
        builder.append('}');
        return builder.toString();
    }

    private boolean isAssignable(AttributeDescription from, AttributeDescription to) {
        if (!from.isPlaceHolder()) {
            return from.equals(to);
        }
        return from.matches(to);
    }
}

