/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.Validator;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.SubtreeDeleteRequestControl;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.GenericExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ChangeRecordVisitor;
import org.forgerock.opendj.ldif.ConnectionEntryReader;

public abstract class AbstractConnection
implements Connection {
    private static final ChangeRecordVisitor<Object, Connection> SYNC_VISITOR = new ChangeRecordVisitor<Object, Connection>(){

        @Override
        public Object visitChangeRecord(Connection p, AddRequest change) {
            try {
                return p.add(change);
            }
            catch (ErrorResultException e) {
                return e;
            }
        }

        @Override
        public Object visitChangeRecord(Connection p, DeleteRequest change) {
            try {
                return p.delete(change);
            }
            catch (ErrorResultException e) {
                return e;
            }
        }

        @Override
        public Object visitChangeRecord(Connection p, ModifyRequest change) {
            try {
                return p.modify(change);
            }
            catch (ErrorResultException e) {
                return e;
            }
        }

        @Override
        public Object visitChangeRecord(Connection p, ModifyDNRequest change) {
            try {
                return p.modifyDN(change);
            }
            catch (ErrorResultException e) {
                return e;
            }
        }
    };

    protected AbstractConnection() {
    }

    @Override
    public Result add(Entry entry) throws ErrorResultException {
        return this.add(Requests.newAddRequest(entry));
    }

    @Override
    public Result add(String ... ldifLines) throws ErrorResultException {
        return this.add(Requests.newAddRequest(ldifLines));
    }

    @Override
    public Result applyChange(ChangeRecord request) throws ErrorResultException {
        Object result = request.accept(SYNC_VISITOR, this);
        if (result instanceof Result) {
            return (Result)result;
        }
        throw (ErrorResultException)result;
    }

    @Override
    public FutureResult<Result> applyChangeAsync(ChangeRecord request, final IntermediateResponseHandler intermediateResponseHandler, final ResultHandler<? super Result> resultHandler) {
        ChangeRecordVisitor<FutureResult<Result>, Connection> visitor = new ChangeRecordVisitor<FutureResult<Result>, Connection>(){

            @Override
            public FutureResult<Result> visitChangeRecord(Connection p, AddRequest change) {
                return p.addAsync(change, intermediateResponseHandler, resultHandler);
            }

            @Override
            public FutureResult<Result> visitChangeRecord(Connection p, DeleteRequest change) {
                return p.deleteAsync(change, intermediateResponseHandler, resultHandler);
            }

            @Override
            public FutureResult<Result> visitChangeRecord(Connection p, ModifyRequest change) {
                return p.modifyAsync(change, intermediateResponseHandler, resultHandler);
            }

            @Override
            public FutureResult<Result> visitChangeRecord(Connection p, ModifyDNRequest change) {
                return p.modifyDNAsync(change, intermediateResponseHandler, resultHandler);
            }
        };
        return request.accept(visitor, this);
    }

    @Override
    public BindResult bind(String name, char[] password) throws ErrorResultException {
        return this.bind(Requests.newSimpleBindRequest(name, password));
    }

    @Override
    public void close() {
        this.close(Requests.newUnbindRequest(), null);
    }

    @Override
    public CompareResult compare(String name, String attributeDescription, String assertionValue) throws ErrorResultException {
        return this.compare(Requests.newCompareRequest(name, attributeDescription, (Object)assertionValue));
    }

    @Override
    public Result delete(String name) throws ErrorResultException {
        return this.delete(Requests.newDeleteRequest(name));
    }

    @Override
    public Result deleteSubtree(String name) throws ErrorResultException {
        return this.delete(Requests.newDeleteRequest(name).addControl(SubtreeDeleteRequestControl.newControl(true)));
    }

    @Override
    public <R extends ExtendedResult> R extendedRequest(ExtendedRequest<R> request) throws ErrorResultException {
        return this.extendedRequest(request, null);
    }

    @Override
    public GenericExtendedResult extendedRequest(String requestName, ByteString requestValue) throws ErrorResultException {
        return this.extendedRequest(Requests.newGenericExtendedRequest(requestName, requestValue));
    }

    @Override
    public Result modify(String ... ldifLines) throws ErrorResultException {
        return this.modify(Requests.newModifyRequest(ldifLines));
    }

    @Override
    public Result modifyDN(String name, String newRDN) throws ErrorResultException {
        return this.modifyDN(Requests.newModifyDNRequest(name, newRDN));
    }

    @Override
    public SearchResultEntry readEntry(DN baseObject, String ... attributeDescriptions) throws ErrorResultException {
        SearchRequest request = Requests.newSearchRequest(baseObject, SearchScope.BASE_OBJECT, Filter.objectClassPresent(), attributeDescriptions);
        return this.searchSingleEntry(request);
    }

    @Override
    public SearchResultEntry readEntry(String baseObject, String ... attributeDescriptions) throws ErrorResultException {
        return this.readEntry(DN.valueOf(baseObject), attributeDescriptions);
    }

    @Override
    public FutureResult<SearchResultEntry> readEntryAsync(DN name, Collection<String> attributeDescriptions, ResultHandler<? super SearchResultEntry> handler) {
        SearchRequest request = Requests.newSearchRequest(name, SearchScope.BASE_OBJECT, Filter.objectClassPresent(), new String[0]);
        if (attributeDescriptions != null) {
            request.getAttributes().addAll(attributeDescriptions);
        }
        return this.searchSingleEntryAsync(request, handler);
    }

    @Override
    public ConnectionEntryReader search(SearchRequest request) {
        return new ConnectionEntryReader(this, request);
    }

    @Override
    public Result search(SearchRequest request, Collection<? super SearchResultEntry> entries) throws ErrorResultException {
        return this.search(request, entries, null);
    }

    @Override
    public Result search(SearchRequest request, final Collection<? super SearchResultEntry> entries, final Collection<? super SearchResultReference> references) throws ErrorResultException {
        Validator.ensureNotNull((Object)request, entries);
        SearchResultHandler handler = new SearchResultHandler(){

            @Override
            public boolean handleEntry(SearchResultEntry entry) {
                entries.add(entry);
                return true;
            }

            @Override
            public void handleErrorResult(ErrorResultException error) {
            }

            @Override
            public boolean handleReference(SearchResultReference reference) {
                if (references != null) {
                    references.add(reference);
                }
                return true;
            }

            @Override
            public void handleResult(Result result) {
            }
        };
        return this.search(request, handler);
    }

    @Override
    public ConnectionEntryReader search(String baseObject, SearchScope scope, String filter, String ... attributeDescriptions) {
        SearchRequest request = Requests.newSearchRequest(baseObject, scope, filter, attributeDescriptions);
        return this.search(request);
    }

    @Override
    public SearchResultEntry searchSingleEntry(SearchRequest request) throws ErrorResultException {
        SingleEntryHandler handler = new SingleEntryHandler();
        this.search(request, handler);
        if (handler.entryCount == 0) {
            throw ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_NO_RESULTS_RETURNED, CoreMessages.ERR_NO_SEARCH_RESULT_ENTRIES.get().toString());
        }
        if (handler.entryCount > 1) {
            throw ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_UNEXPECTED_RESULTS_RETURNED, CoreMessages.ERR_UNEXPECTED_SEARCH_RESULT_ENTRIES.get((Object)handler.entryCount).toString());
        }
        if (handler.firstReference != null) {
            throw ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_UNEXPECTED_RESULTS_RETURNED, CoreMessages.ERR_UNEXPECTED_SEARCH_RESULT_REFERENCES.get((Object)handler.firstReference.getURIs().iterator().next()).toString());
        }
        return handler.firstEntry;
    }

    @Override
    public SearchResultEntry searchSingleEntry(String baseObject, SearchScope scope, String filter, String ... attributeDescriptions) throws ErrorResultException {
        SearchRequest request = Requests.newSearchRequest(baseObject, scope, filter, attributeDescriptions);
        return this.searchSingleEntry(request);
    }

    @Override
    public FutureResult<SearchResultEntry> searchSingleEntryAsync(SearchRequest request, ResultHandler<? super SearchResultEntry> handler) {
        SingleEntryFuture innerFuture = new SingleEntryFuture(handler);
        FutureResult<Result> future = this.searchAsync(request, null, innerFuture);
        innerFuture.setResultFuture(future);
        return innerFuture;
    }

    public abstract String toString();

    private static final class SingleEntryHandler
    implements SearchResultHandler {
        private volatile SearchResultEntry firstEntry = null;
        private volatile SearchResultReference firstReference = null;
        private volatile int entryCount = 0;

        private SingleEntryHandler() {
        }

        @Override
        public boolean handleEntry(SearchResultEntry entry) {
            if (this.firstEntry == null) {
                this.firstEntry = entry;
            }
            ++this.entryCount;
            return true;
        }

        @Override
        public void handleErrorResult(ErrorResultException error) {
        }

        @Override
        public boolean handleReference(SearchResultReference reference) {
            if (this.firstReference == null) {
                this.firstReference = reference;
            }
            return true;
        }

        @Override
        public void handleResult(Result result) {
        }
    }

    private static final class SingleEntryFuture
    implements FutureResult<SearchResultEntry>,
    SearchResultHandler {
        private final ResultHandler<? super SearchResultEntry> handler;
        private volatile SearchResultEntry firstEntry = null;
        private volatile SearchResultReference firstReference = null;
        private volatile int entryCount = 0;
        private volatile FutureResult<Result> future = null;

        private SingleEntryFuture(ResultHandler<? super SearchResultEntry> handler) {
            this.handler = handler;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public SearchResultEntry get() throws ErrorResultException, InterruptedException {
            this.future.get();
            return this.get0();
        }

        @Override
        public SearchResultEntry get(long timeout, TimeUnit unit) throws ErrorResultException, TimeoutException, InterruptedException {
            this.future.get(timeout, unit);
            return this.get0();
        }

        @Override
        public int getRequestID() {
            return this.future.getRequestID();
        }

        @Override
        public boolean handleEntry(SearchResultEntry entry) {
            if (this.firstEntry == null) {
                this.firstEntry = entry;
            }
            ++this.entryCount;
            return true;
        }

        @Override
        public void handleErrorResult(ErrorResultException error) {
            if (this.handler != null) {
                this.handler.handleErrorResult(error);
            }
        }

        @Override
        public boolean handleReference(SearchResultReference reference) {
            if (this.firstReference == null) {
                this.firstReference = reference;
            }
            return true;
        }

        @Override
        public void handleResult(Result result) {
            if (this.handler != null) {
                try {
                    this.handler.handleResult(this.get0());
                }
                catch (ErrorResultException e) {
                    this.handler.handleErrorResult(e);
                }
            }
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        private SearchResultEntry get0() throws ErrorResultException {
            if (this.entryCount == 0) {
                throw ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_NO_RESULTS_RETURNED, CoreMessages.ERR_NO_SEARCH_RESULT_ENTRIES.get().toString());
            }
            if (this.entryCount > 1) {
                throw ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_UNEXPECTED_RESULTS_RETURNED, CoreMessages.ERR_UNEXPECTED_SEARCH_RESULT_ENTRIES.get((Object)this.entryCount).toString());
            }
            if (this.firstReference != null) {
                throw ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_UNEXPECTED_RESULTS_RETURNED, CoreMessages.ERR_UNEXPECTED_SEARCH_RESULT_REFERENCES.get((Object)this.firstReference.getURIs().iterator().next()).toString());
            }
            return this.firstEntry;
        }

        private void setResultFuture(FutureResult<Result> future) {
            this.future = future;
        }
    }
}

