/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.asn1;

import com.forgerock.opendj.util.SizeLimitInputStream;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.logging.Level;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.asn1.ASN1Reader;
import org.forgerock.opendj.asn1.AbstractASN1Reader;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;

final class ASN1InputStreamReader
extends AbstractASN1Reader
implements ASN1Reader {
    private int state = 0;
    private byte peekType = 0;
    private int peekLength = -1;
    private int lengthBytesNeeded = 0;
    private final int maxElementSize;
    private InputStream in;
    private final LinkedList<InputStream> streamStack;
    private byte[] buffer;

    ASN1InputStreamReader(InputStream stream, int maxElementSize) {
        this.in = stream;
        this.streamStack = new LinkedList();
        this.buffer = new byte[512];
        this.maxElementSize = maxElementSize;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.streamStack.clear();
    }

    @Override
    public boolean elementAvailable() throws IOException {
        if (this.state == 0 && !this.needTypeState(false, false)) {
            return false;
        }
        if (this.state == 1 && !this.needFirstLengthByteState(false, false)) {
            return false;
        }
        if (this.state == 2 && !this.needAdditionalLengthBytesState(false, false)) {
            return false;
        }
        return this.peekLength <= this.in.available();
    }

    @Override
    public boolean hasNextElement() throws IOException {
        if (!this.streamStack.isEmpty()) {
            SizeLimitInputStream subSq = (SizeLimitInputStream)this.in;
            return subSq.getSizeLimit() - subSq.getBytesRead() > 0;
        }
        return this.state != 0 || this.needTypeState(true, false);
    }

    @Override
    public int peekLength() throws IOException {
        this.peekType();
        switch (this.state) {
            case 1: {
                this.needFirstLengthByteState(true, true);
                break;
            }
            case 2: {
                this.needAdditionalLengthBytesState(true, true);
            }
        }
        return this.peekLength;
    }

    @Override
    public byte peekType() throws IOException {
        if (this.state == 0) {
            this.needTypeState(true, true);
        }
        return this.peekType;
    }

    @Override
    public boolean readBoolean() throws IOException {
        this.peekLength();
        if (this.peekLength != 1) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_BOOLEAN_INVALID_LENGTH.get((Object)this.peekLength);
            throw DecodeException.fatalError(message);
        }
        int readByte = this.in.read();
        if (readByte == -1) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_BOOLEAN_TRUNCATED_VALUE.get((Object)this.peekLength);
            throw DecodeException.fatalError(message);
        }
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("READ ASN.1 BOOLEAN(type=0x%x, length=%d, value=%s)", this.peekType, this.peekLength, String.valueOf(readByte != 0)));
        }
        this.state = 0;
        return readByte != 0;
    }

    @Override
    public void readEndSequence() throws IOException {
        if (this.streamStack.isEmpty()) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_SEQUENCE_READ_NOT_STARTED.get();
            throw new IllegalStateException(message.toString());
        }
        SizeLimitInputStream subSq = (SizeLimitInputStream)this.in;
        if (subSq.getSizeLimit() - subSq.getBytesRead() > 0) {
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
                StaticUtils.DEBUG_LOG.fine(String.format("Ignoring %d unused trailing bytes in ASN.1 SEQUENCE", subSq.getSizeLimit() - subSq.getBytesRead()));
            }
            subSq.skip(subSq.getSizeLimit() - subSq.getBytesRead());
        }
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("READ ASN.1 END SEQUENCE", new Object[0]));
        }
        this.in = this.streamStack.removeFirst();
        this.state = 0;
    }

    @Override
    public void readEndSet() throws IOException {
        this.readEndSequence();
    }

    @Override
    public int readEnumerated() throws IOException {
        this.peekLength();
        if (this.peekLength < 1 || this.peekLength > 4) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_INTEGER_INVALID_LENGTH.get((Object)this.peekLength);
            throw DecodeException.fatalError(message);
        }
        return (int)this.readInteger();
    }

    @Override
    public long readInteger() throws IOException {
        this.peekLength();
        if (this.peekLength < 1 || this.peekLength > 8) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_INTEGER_INVALID_LENGTH.get((Object)this.peekLength);
            throw DecodeException.fatalError(message);
        }
        if (this.peekLength > 4) {
            long longValue = 0L;
            for (int i = 0; i < this.peekLength; ++i) {
                int readByte = this.in.read();
                if (readByte == -1) {
                    LocalizableMessage message = CoreMessages.ERR_ASN1_INTEGER_TRUNCATED_VALUE.get((Object)this.peekLength);
                    throw DecodeException.fatalError(message);
                }
                if (i == 0 && (byte)readByte < 0) {
                    longValue = -1L;
                }
                longValue = longValue << 8 | (long)(readByte & 0xFF);
            }
            this.state = 0;
            return longValue;
        }
        int intValue = 0;
        for (int i = 0; i < this.peekLength; ++i) {
            int readByte = this.in.read();
            if (readByte == -1) {
                LocalizableMessage message = CoreMessages.ERR_ASN1_INTEGER_TRUNCATED_VALUE.get((Object)this.peekLength);
                throw DecodeException.fatalError(message);
            }
            if (i == 0 && (byte)readByte < 0) {
                intValue = -1;
            }
            intValue = intValue << 8 | readByte & 0xFF;
        }
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("READ ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", this.peekType, this.peekLength, intValue));
        }
        this.state = 0;
        return intValue;
    }

    @Override
    public void readNull() throws IOException {
        this.peekLength();
        if (this.peekLength != 0) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_NULL_INVALID_LENGTH.get((Object)this.peekLength);
            throw DecodeException.fatalError(message);
        }
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("READ ASN.1 NULL(type=0x%x, length=%d)", this.peekType, this.peekLength));
        }
        this.state = 0;
    }

    @Override
    public ByteString readOctetString() throws IOException {
        int bytesRead;
        this.peekLength();
        if (this.peekLength == 0) {
            this.state = 0;
            return ByteString.empty();
        }
        byte[] value = new byte[this.peekLength];
        for (int bytesNeeded = this.peekLength; bytesNeeded > 0; bytesNeeded -= bytesRead) {
            bytesRead = this.in.read(value, this.peekLength - bytesNeeded, bytesNeeded);
            if (bytesRead >= 0) continue;
            LocalizableMessage message = CoreMessages.ERR_ASN1_OCTET_STRING_TRUNCATED_VALUE.get((Object)this.peekLength);
            throw DecodeException.fatalError(message);
        }
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("READ ASN.1 OCTETSTRING(type=0x%x, length=%d)", this.peekType, this.peekLength));
        }
        this.state = 0;
        return ByteString.wrap(value);
    }

    @Override
    public ByteStringBuilder readOctetString(ByteStringBuilder builder) throws IOException {
        int bytesRead;
        this.peekLength();
        if (this.peekLength == 0) {
            this.state = 0;
            return builder;
        }
        for (int bytesNeeded = this.peekLength; bytesNeeded > 0; bytesNeeded -= bytesRead) {
            bytesRead = builder.append(this.in, bytesNeeded);
            if (bytesRead >= 0) continue;
            LocalizableMessage message = CoreMessages.ERR_ASN1_OCTET_STRING_TRUNCATED_VALUE.get((Object)this.peekLength);
            throw DecodeException.fatalError(message);
        }
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("READ ASN.1 OCTETSTRING(type=0x%x, length=%d)", this.peekType, this.peekLength));
        }
        this.state = 0;
        return builder;
    }

    @Override
    public String readOctetStringAsString() throws IOException {
        String str;
        int bytesRead;
        this.peekLength();
        if (this.peekLength == 0) {
            this.state = 0;
            return "";
        }
        if (this.peekLength > this.buffer.length) {
            this.buffer = new byte[this.peekLength];
        }
        for (int bytesNeeded = this.peekLength; bytesNeeded > 0; bytesNeeded -= bytesRead) {
            bytesRead = this.in.read(this.buffer, this.peekLength - bytesNeeded, bytesNeeded);
            if (bytesRead >= 0) continue;
            LocalizableMessage message = CoreMessages.ERR_ASN1_OCTET_STRING_TRUNCATED_VALUE.get((Object)this.peekLength);
            throw DecodeException.fatalError(message);
        }
        this.state = 0;
        try {
            str = new String(this.buffer, 0, this.peekLength, "UTF-8");
        }
        catch (Exception e) {
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                StaticUtils.DEBUG_LOG.warning("Unable to decode ASN.1 OCTETSTRING bytes as UTF-8 string: " + e.toString());
            }
            str = new String(this.buffer, 0, this.peekLength);
        }
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("READ ASN.1 OCTETSTRING(type=0x%x, length=%d, value=%s)", this.peekType, this.peekLength, str));
        }
        return str;
    }

    @Override
    public void readStartSequence() throws IOException {
        this.peekLength();
        SizeLimitInputStream subStream = new SizeLimitInputStream(this.in, this.peekLength);
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINEST)) {
            StaticUtils.DEBUG_LOG.finest(String.format("READ ASN.1 START SEQUENCE(type=0x%x, length=%d)", this.peekType, this.peekLength));
        }
        this.streamStack.addFirst(this.in);
        this.in = subStream;
        this.state = 0;
    }

    @Override
    public void readStartSet() throws IOException {
        this.readStartSequence();
    }

    @Override
    public ASN1Reader skipElement() throws IOException {
        this.peekLength();
        long bytesSkipped = this.in.skip(this.peekLength);
        if (bytesSkipped != (long)this.peekLength) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_SKIP_TRUNCATED_VALUE.get((Object)this.peekLength);
            throw DecodeException.fatalError(message);
        }
        this.state = 0;
        return this;
    }

    private boolean needAdditionalLengthBytesState(boolean isBlocking, boolean throwEofException) throws IOException {
        if (!isBlocking && this.in.available() < this.lengthBytesNeeded) {
            return false;
        }
        while (this.lengthBytesNeeded > 0) {
            int readByte = this.in.read();
            if (readByte == -1) {
                this.state = 2;
                if (throwEofException) {
                    LocalizableMessage message = CoreMessages.ERR_ASN1_TRUNCATED_LENGTH_BYTES.get((Object)this.lengthBytesNeeded);
                    throw DecodeException.fatalError(message);
                }
                return false;
            }
            this.peekLength = this.peekLength << 8 | readByte & 0xFF;
            --this.lengthBytesNeeded;
        }
        if (this.maxElementSize > 0 && this.peekLength > this.maxElementSize) {
            LocalizableMessage message = CoreMessages.ERR_LDAP_CLIENT_DECODE_MAX_REQUEST_SIZE_EXCEEDED.get((Object)this.peekLength, (Object)this.maxElementSize);
            throw DecodeException.fatalError(message);
        }
        this.state = 3;
        return true;
    }

    private boolean needFirstLengthByteState(boolean isBlocking, boolean throwEofException) throws IOException {
        if (!isBlocking && this.in.available() <= 0) {
            return false;
        }
        int readByte = this.in.read();
        if (readByte == -1) {
            if (throwEofException) {
                LocalizableMessage message = CoreMessages.ERR_ASN1_TRUNCATED_LENGTH_BYTE.get();
                throw DecodeException.fatalError(message);
            }
            return false;
        }
        this.peekLength = readByte & 0x7F;
        if (this.peekLength != readByte) {
            this.lengthBytesNeeded = this.peekLength;
            if (this.lengthBytesNeeded > 4) {
                LocalizableMessage message = CoreMessages.ERR_ASN1_INVALID_NUM_LENGTH_BYTES.get((Object)this.lengthBytesNeeded);
                throw DecodeException.fatalError(message);
            }
            this.peekLength = 0;
            if (!isBlocking && this.in.available() < this.lengthBytesNeeded) {
                this.state = 2;
                return false;
            }
            while (this.lengthBytesNeeded > 0) {
                readByte = this.in.read();
                if (readByte == -1) {
                    this.state = 2;
                    if (throwEofException) {
                        LocalizableMessage message = CoreMessages.ERR_ASN1_TRUNCATED_LENGTH_BYTES.get((Object)this.lengthBytesNeeded);
                        throw DecodeException.fatalError(message);
                    }
                    return false;
                }
                this.peekLength = this.peekLength << 8 | readByte & 0xFF;
                --this.lengthBytesNeeded;
            }
        }
        if (this.maxElementSize > 0 && this.peekLength > this.maxElementSize) {
            LocalizableMessage message = CoreMessages.ERR_LDAP_CLIENT_DECODE_MAX_REQUEST_SIZE_EXCEEDED.get((Object)this.peekLength, (Object)this.maxElementSize);
            throw DecodeException.fatalError(message);
        }
        this.state = 3;
        return true;
    }

    private boolean needTypeState(boolean isBlocking, boolean throwEofException) throws IOException {
        if (!isBlocking && this.in.available() <= 0) {
            return false;
        }
        int type = this.in.read();
        if (type == -1) {
            if (throwEofException) {
                LocalizableMessage message = CoreMessages.ERR_ASN1_TRUCATED_TYPE_BYTE.get();
                throw DecodeException.fatalError(message);
            }
            return false;
        }
        this.peekType = (byte)type;
        this.state = 1;
        return true;
    }
}

