/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import com.forgerock.opendj.util.Validator;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.HashSet;
import org.forgerock.opendj.ldap.ByteSequence;

public final class StringPrepProfile {
    private static final char SPACE_CHAR = ' ';
    public static final boolean CASE_FOLD = true;
    public static final boolean NO_CASE_FOLD = false;
    public static final boolean TRIM = true;

    public static void prepareUnicode(StringBuilder buffer, ByteSequence sequence, boolean trim, boolean foldCase) {
        int i;
        Validator.ensureNotNull(buffer);
        Validator.ensureNotNull(sequence);
        int length = sequence.length();
        block3: for (i = 0; i < length; ++i) {
            if ((sequence.byteAt(i) & 0x7F) != sequence.byteAt(i)) {
                StringPrepProfile.map(buffer, sequence.subSequence(i, length), trim, foldCase);
                String normalizedForm = Normalizer.normalize(buffer, Normalizer.Form.NFKD);
                buffer.setLength(0);
                buffer.append(normalizedForm);
                break;
            }
            int buffLen = buffer.length();
            switch (sequence.byteAt(i)) {
                case 32: {
                    if (trim && buffLen == 0 || buffLen > 0 && buffer.charAt(buffLen - 1) == ' ') continue block3;
                    buffer.append(' ');
                    continue block3;
                }
                default: {
                    byte b = sequence.byteAt(i);
                    if (b >= 9 && b < 14) {
                        buffLen = buffer.length();
                        if (trim && buffLen == 0 || buffLen > 0 && buffer.charAt(buffLen - 1) == ' ') continue block3;
                        buffer.append(' ');
                        continue block3;
                    }
                    if (b >= 0 && b <= 8 || b >= 14 && b <= 31 || b == 127) continue block3;
                    if (foldCase && b >= 65 && b <= 90) {
                        buffer.append((char)(b + 32));
                        continue block3;
                    }
                    buffer.append((char)b);
                }
            }
        }
        if (trim) {
            for (i = buffer.length() - 1; i > 0 && buffer.charAt(i) == ' '; --i) {
                buffer.delete(i, i + 1);
            }
        }
    }

    private static void map(StringBuilder buffer, ByteSequence value, boolean trim, boolean foldCase) {
        MappingTable.map(buffer, value, trim, foldCase);
    }

    private StringPrepProfile() {
    }

    private static final class MappingTable {
        private static final HashSet<Character> MAP_2_NULL;
        private static final HashSet<Character> MAP_2_SPACE;
        private static final HashMap<Character, String> CASE_MAP_TABLE;

        private static void map(StringBuilder buffer, ByteSequence sequence, boolean trim, boolean foldCase) {
            String value = sequence.toString();
            for (int i = 0; i < value.length(); ++i) {
                String mapping;
                char c = value.charAt(i);
                if (MAP_2_NULL.contains(Character.valueOf(c))) continue;
                if (MAP_2_SPACE.contains(Character.valueOf(c))) {
                    int buffLen = buffer.length();
                    if (trim && buffLen == 0 || buffLen > 0 && buffer.charAt(buffLen - 1) == ' ') continue;
                    buffer.append(' ');
                    continue;
                }
                if (foldCase && (mapping = CASE_MAP_TABLE.get(Character.valueOf(c))) != null) {
                    buffer.append(mapping);
                    continue;
                }
                buffer.append(c);
            }
        }

        private MappingTable() {
        }

        static {
            char[] mapped2Space;
            char[][] mapped2null;
            MAP_2_NULL = new HashSet();
            MAP_2_SPACE = new HashSet();
            CASE_MAP_TABLE = new HashMap();
            for (char[] element : mapped2null = new char[][]{{'\u0000', '\b'}, {'\u000e', '\u001f'}, {'\u007f', '\u0084'}, {'\u0086', '\u009f'}, {'\u00ad'}, {'\u034f'}, {'\u06dd'}, {'\u070f'}, {'\u1806'}, {'\u180b', '\u180e'}, {'\u200c', '\u200f'}, {'\u202a', '\u202e'}, {'\u2060', '\u2063'}, {'\u206a', '\u206f'}, {'\ufe00', '\ufe0f'}, {'\ufeff'}, {'\ufff9', '\ufffc'}}) {
                if (element.length == 1) {
                    MAP_2_NULL.add(Character.valueOf(element[0]));
                    continue;
                }
                for (char c = element[0]; c <= element[1]; c = (char)(c + '\u0001')) {
                    MAP_2_NULL.add(Character.valueOf(c));
                }
            }
            for (char c : mapped2Space = new char[]{'\t', '\n', '\u000b', '\f', '\r', '\u0085', '\u00a0', '\u1680', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2007', '\u2008', '\u2009', '\u200a', '\u2028', '\u2029', '\u202f', '\u205f', '\u3000'}) {
                MAP_2_SPACE.add(Character.valueOf(c));
            }
            char[] upperCaseArr = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00b5', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u0100', '\u0102', '\u0104', '\u0106', '\u0108', '\u010a', '\u010c', '\u010e', '\u0110', '\u0112', '\u0114', '\u0116', '\u0118', '\u011a', '\u011c', '\u011e', '\u0120', '\u0122', '\u0124', '\u0126', '\u0128', '\u012a', '\u012c', '\u012e', '\u0130', '\u0132', '\u0134', '\u0136', '\u0139', '\u013b', '\u013d', '\u013f', '\u0141', '\u0143', '\u0145', '\u0147', '\u0149', '\u014a', '\u014c', '\u014e', '\u0150', '\u0152', '\u0154', '\u0156', '\u0158', '\u015a', '\u015c', '\u015e', '\u0160', '\u0162', '\u0164', '\u0166', '\u0168', '\u016a', '\u016c', '\u016e', '\u0170', '\u0172', '\u0174', '\u0176', '\u0178', '\u0179', '\u017b', '\u017d', '\u017f', '\u0181', '\u0182', '\u0184', '\u0186', '\u0187', '\u0189', '\u018a', '\u018b', '\u018e', '\u018f', '\u0190', '\u0191', '\u0193', '\u0194', '\u0196', '\u0197', '\u0198', '\u019c', '\u019d', '\u019f', '\u01a0', '\u01a2', '\u01a4', '\u01a6', '\u01a7', '\u01a9', '\u01ac', '\u01ae', '\u01af', '\u01b1', '\u01b2', '\u01b3', '\u01b5', '\u01b7', '\u01b8', '\u01bc', '\u01c4', '\u01c5', '\u01c7', '\u01c8', '\u01ca', '\u01cb', '\u01cd', '\u01cf', '\u01d1', '\u01d3', '\u01d5', '\u01d7', '\u01d9', '\u01db', '\u01de', '\u01e0', '\u01e2', '\u01e4', '\u01e6', '\u01e8', '\u01ea', '\u01ec', '\u01ee', '\u01f0', '\u01f1', '\u01f2', '\u01f4', '\u01f6', '\u01f7', '\u01f8', '\u01fa', '\u01fc', '\u01fe', '\u0200', '\u0202', '\u0204', '\u0206', '\u0208', '\u020a', '\u020c', '\u020e', '\u0210', '\u0212', '\u0214', '\u0216', '\u0218', '\u021a', '\u021c', '\u021e', '\u0220', '\u0222', '\u0224', '\u0226', '\u0228', '\u022a', '\u022c', '\u022e', '\u0230', '\u0232', '\u0345', '\u037a', '\u0386', '\u0388', '\u0389', '\u038a', '\u038c', '\u038e', '\u038f', '\u0390', '\u0391', '\u0392', '\u0393', '\u0394', '\u0395', '\u0396', '\u0397', '\u0398', '\u0399', '\u039a', '\u039b', '\u039c', '\u039d', '\u039e', '\u039f', '\u03a0', '\u03a1', '\u03a3', '\u03a4', '\u03a5', '\u03a6', '\u03a7', '\u03a8', '\u03a9', '\u03aa', '\u03ab', '\u03b0', '\u03c2', '\u03d0', '\u03d1', '\u03d2', '\u03d3', '\u03d4', '\u03d5', '\u03d6', '\u03d8', '\u03da', '\u03dc', '\u03de', '\u03e0', '\u03e2', '\u03e4', '\u03e6', '\u03e8', '\u03ea', '\u03ec', '\u03ee', '\u03f0', '\u03f1', '\u03f2', '\u03f4', '\u03f5', '\u0400', '\u0401', '\u0402', '\u0403', '\u0404', '\u0405', '\u0406', '\u0407', '\u0408', '\u0409', '\u040a', '\u040b', '\u040c', '\u040d', '\u040e', '\u040f', '\u0410', '\u0411', '\u0412', '\u0413', '\u0414', '\u0415', '\u0416', '\u0417', '\u0418', '\u0419', '\u041a', '\u041b', '\u041c', '\u041d', '\u041e', '\u041f', '\u0420', '\u0421', '\u0422', '\u0423', '\u0424', '\u0425', '\u0426', '\u0427', '\u0428', '\u0429', '\u042a', '\u042b', '\u042c', '\u042d', '\u042e', '\u042f', '\u0460', '\u0462', '\u0464', '\u0466', '\u0468', '\u046a', '\u046c', '\u046e', '\u0470', '\u0472', '\u0474', '\u0476', '\u0478', '\u047a', '\u047c', '\u047e', '\u0480', '\u048a', '\u048c', '\u048e', '\u0490', '\u0492', '\u0494', '\u0496', '\u0498', '\u049a', '\u049c', '\u049e', '\u04a0', '\u04a2', '\u04a4', '\u04a6', '\u04a8', '\u04aa', '\u04ac', '\u04ae', '\u04b0', '\u04b2', '\u04b4', '\u04b6', '\u04b8', '\u04ba', '\u04bc', '\u04be', '\u04c1', '\u04c3', '\u04c5', '\u04c7', '\u04c9', '\u04cb', '\u04cd', '\u04d0', '\u04d2', '\u04d4', '\u04d6', '\u04d8', '\u04da', '\u04dc', '\u04de', '\u04e0', '\u04e2', '\u04e4', '\u04e6', '\u04e8', '\u04ea', '\u04ec', '\u04ee', '\u04f0', '\u04f2', '\u04f4', '\u04f8', '\u0500', '\u0502', '\u0504', '\u0506', '\u0508', '\u050a', '\u050c', '\u050e', '\u0531', '\u0532', '\u0533', '\u0534', '\u0535', '\u0536', '\u0537', '\u0538', '\u0539', '\u053a', '\u053b', '\u053c', '\u053d', '\u053e', '\u053f', '\u0540', '\u0541', '\u0542', '\u0543', '\u0544', '\u0545', '\u0546', '\u0547', '\u0548', '\u0549', '\u054a', '\u054b', '\u054c', '\u054d', '\u054e', '\u054f', '\u0550', '\u0551', '\u0552', '\u0553', '\u0554', '\u0555', '\u0556', '\u0587', '\u1e00', '\u1e02', '\u1e04', '\u1e06', '\u1e08', '\u1e0a', '\u1e0c', '\u1e0e', '\u1e10', '\u1e12', '\u1e14', '\u1e16', '\u1e18', '\u1e1a', '\u1e1c', '\u1e1e', '\u1e20', '\u1e22', '\u1e24', '\u1e26', '\u1e28', '\u1e2a', '\u1e2c', '\u1e2e', '\u1e30', '\u1e32', '\u1e34', '\u1e36', '\u1e38', '\u1e3a', '\u1e3c', '\u1e3e', '\u1e40', '\u1e42', '\u1e44', '\u1e46', '\u1e48', '\u1e4a', '\u1e4c', '\u1e4e', '\u1e50', '\u1e52', '\u1e54', '\u1e56', '\u1e58', '\u1e5a', '\u1e5c', '\u1e5e', '\u1e60', '\u1e62', '\u1e64', '\u1e66', '\u1e68', '\u1e6a', '\u1e6c', '\u1e6e', '\u1e70', '\u1e72', '\u1e74', '\u1e76', '\u1e78', '\u1e7a', '\u1e7c', '\u1e7e', '\u1e80', '\u1e82', '\u1e84', '\u1e86', '\u1e88', '\u1e8a', '\u1e8c', '\u1e8e', '\u1e90', '\u1e92', '\u1e94', '\u1e96', '\u1e97', '\u1e98', '\u1e99', '\u1e9a', '\u1e9b', '\u1ea0', '\u1ea2', '\u1ea4', '\u1ea6', '\u1ea8', '\u1eaa', '\u1eac', '\u1eae', '\u1eb0', '\u1eb2', '\u1eb4', '\u1eb6', '\u1eb8', '\u1eba', '\u1ebc', '\u1ebe', '\u1ec0', '\u1ec2', '\u1ec4', '\u1ec6', '\u1ec8', '\u1eca', '\u1ecc', '\u1ece', '\u1ed0', '\u1ed2', '\u1ed4', '\u1ed6', '\u1ed8', '\u1eda', '\u1edc', '\u1ede', '\u1ee0', '\u1ee2', '\u1ee4', '\u1ee6', '\u1ee8', '\u1eea', '\u1eec', '\u1eee', '\u1ef0', '\u1ef2', '\u1ef4', '\u1ef6', '\u1ef8', '\u1f08', '\u1f09', '\u1f0a', '\u1f0b', '\u1f0c', '\u1f0d', '\u1f0e', '\u1f0f', '\u1f18', '\u1f19', '\u1f1a', '\u1f1b', '\u1f1c', '\u1f1d', '\u1f28', '\u1f29', '\u1f2a', '\u1f2b', '\u1f2c', '\u1f2d', '\u1f2e', '\u1f2f', '\u1f38', '\u1f39', '\u1f3a', '\u1f3b', '\u1f3c', '\u1f3d', '\u1f3e', '\u1f3f', '\u1f48', '\u1f49', '\u1f4a', '\u1f4b', '\u1f4c', '\u1f4d', '\u1f50', '\u1f52', '\u1f54', '\u1f56', '\u1f59', '\u1f5b', '\u1f5d', '\u1f5f', '\u1f68', '\u1f69', '\u1f6a', '\u1f6b', '\u1f6c', '\u1f6d', '\u1f6e', '\u1f6f', '\u1f80', '\u1f81', '\u1f82', '\u1f83', '\u1f84', '\u1f85', '\u1f86', '\u1f87', '\u1f88', '\u1f89', '\u1f8a', '\u1f8b', '\u1f8c', '\u1f8d', '\u1f8e', '\u1f8f', '\u1f90', '\u1f91', '\u1f92', '\u1f93', '\u1f94', '\u1f95', '\u1f96', '\u1f97', '\u1f98', '\u1f99', '\u1f9a', '\u1f9b', '\u1f9c', '\u1f9d', '\u1f9e', '\u1f9f', '\u1fa0', '\u1fa1', '\u1fa2', '\u1fa3', '\u1fa4', '\u1fa5', '\u1fa6', '\u1fa7', '\u1fa8', '\u1fa9', '\u1faa', '\u1fab', '\u1fac', '\u1fad', '\u1fae', '\u1faf', '\u1fb2', '\u1fb3', '\u1fb4', '\u1fb6', '\u1fb7', '\u1fb8', '\u1fb9', '\u1fba', '\u1fbb', '\u1fbc', '\u1fbe', '\u1fc2', '\u1fc3', '\u1fc4', '\u1fc6', '\u1fc7', '\u1fc8', '\u1fc9', '\u1fca', '\u1fcb', '\u1fcc', '\u1fd2', '\u1fd3', '\u1fd6', '\u1fd7', '\u1fd8', '\u1fd9', '\u1fda', '\u1fdb', '\u1fe2', '\u1fe3', '\u1fe4', '\u1fe6', '\u1fe7', '\u1fe8', '\u1fe9', '\u1fea', '\u1feb', '\u1fec', '\u1ff2', '\u1ff3', '\u1ff4', '\u1ff6', '\u1ff7', '\u1ff8', '\u1ff9', '\u1ffa', '\u1ffb', '\u1ffc', '\u20a8', '\u2102', '\u2103', '\u2107', '\u2109', '\u210b', '\u210c', '\u210d', '\u2110', '\u2111', '\u2112', '\u2115', '\u2116', '\u2119', '\u211a', '\u211b', '\u211c', '\u211d', '\u2120', '\u2121', '\u2122', '\u2124', '\u2126', '\u2128', '\u212a', '\u212b', '\u212c', '\u212d', '\u2130', '\u2131', '\u2133', '\u213e', '\u213f', '\u2145', '\u2160', '\u2161', '\u2162', '\u2163', '\u2164', '\u2165', '\u2166', '\u2167', '\u2168', '\u2169', '\u216a', '\u216b', '\u216c', '\u216d', '\u216e', '\u216f', '\u24b6', '\u24b7', '\u24b8', '\u24b9', '\u24ba', '\u24bb', '\u24bc', '\u24bd', '\u24be', '\u24bf', '\u24c0', '\u24c1', '\u24c2', '\u24c3', '\u24c4', '\u24c5', '\u24c6', '\u24c7', '\u24c8', '\u24c9', '\u24ca', '\u24cb', '\u24cc', '\u24cd', '\u24ce', '\u24cf', '\u3371', '\u3373', '\u3375', '\u3380', '\u3381', '\u3382', '\u3383', '\u3384', '\u3385', '\u3386', '\u3387', '\u338a', '\u338b', '\u338c', '\u3390', '\u3391', '\u3392', '\u3393', '\u3394', '\u33a9', '\u33aa', '\u33ab', '\u33ac', '\u33b4', '\u33b5', '\u33b6', '\u33b7', '\u33b8', '\u33b9', '\u33ba', '\u33bb', '\u33bc', '\u33bd', '\u33be', '\u33bf', '\u33c0', '\u33c1', '\u33c3', '\u33c6', '\u33c7', '\u33c8', '\u33c9', '\u33cb', '\u33cd', '\u33ce', '\u33d7', '\u33d9', '\u33da', '\u33dc', '\u33dd', '\ufb00', '\ufb01', '\ufb02', '\ufb03', '\ufb04', '\ufb05', '\ufb06', '\ufb13', '\ufb14', '\ufb15', '\ufb16', '\ufb17', '\uff21', '\uff22', '\uff23', '\uff24', '\uff25', '\uff26', '\uff27', '\uff28', '\uff29', '\uff2a', '\uff2b', '\uff2c', '\uff2d', '\uff2e', '\uff2f', '\uff30', '\uff31', '\uff32', '\uff33', '\uff34', '\uff35', '\uff36', '\uff37', '\uff38', '\uff39', '\uff3a'};
            String[] lowerCaseFoldedArr = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "\u03bc", "\u00e0", "\u00e1", "\u00e2", "\u00e3", "\u00e4", "\u00e5", "\u00e6", "\u00e7", "\u00e8", "\u00e9", "\u00ea", "\u00eb", "\u00ec", "\u00ed", "\u00ee", "\u00ef", "\u00f0", "\u00f1", "\u00f2", "\u00f3", "\u00f4", "\u00f5", "\u00f6", "\u00f8", "\u00f9", "\u00fa", "\u00fb", "\u00fc", "\u00fd", "\u00fe", "ss", "\u0101", "\u0103", "\u0105", "\u0107", "\u0109", "\u010b", "\u010d", "\u010f", "\u0111", "\u0113", "\u0115", "\u0117", "\u0119", "\u011b", "\u011d", "\u011f", "\u0121", "\u0123", "\u0125", "\u0127", "\u0129", "\u012b", "\u012d", "\u012f", "i\u0307", "\u0133", "\u0135", "\u0137", "\u013a", "\u013c", "\u013e", "\u0140", "\u0142", "\u0144", "\u0146", "\u0148", "\u02bcn", "\u014b", "\u014d", "\u014f", "\u0151", "\u0153", "\u0155", "\u0157", "\u0159", "\u015b", "\u015d", "\u015f", "\u0161", "\u0163", "\u0165", "\u0167", "\u0169", "\u016b", "\u016d", "\u016f", "\u0171", "\u0173", "\u0175", "\u0177", "\u00ff", "\u017a", "\u017c", "\u017e", "s", "\u0253", "\u0183", "\u0185", "\u0254", "\u0188", "\u0256", "\u0257", "\u018c", "\u01dd", "\u0259", "\u025b", "\u0192", "\u0260", "\u0263", "\u0269", "\u0268", "\u0199", "\u026f", "\u0272", "\u0275", "\u01a1", "\u01a3", "\u01a5", "\u0280", "\u01a8", "\u0283", "\u01ad", "\u0288", "\u01b0", "\u028a", "\u028b", "\u01b4", "\u01b6", "\u0292", "\u01b9", "\u01bd", "\u01c6", "\u01c6", "\u01c9", "\u01c9", "\u01cc", "\u01cc", "\u01ce", "\u01d0", "\u01d2", "\u01d4", "\u01d6", "\u01d8", "\u01da", "\u01dc", "\u01df", "\u01e1", "\u01e3", "\u01e5", "\u01e7", "\u01e9", "\u01eb", "\u01ed", "\u01ef", "j\u030c", "\u01f3", "\u01f3", "\u01f5", "\u0195", "\u01bf", "\u01f9", "\u01fb", "\u01fd", "\u01ff", "\u0201", "\u0203", "\u0205", "\u0207", "\u0209", "\u020b", "\u020d", "\u020f", "\u0211", "\u0213", "\u0215", "\u0217", "\u0219", "\u021b", "\u021d", "\u021f", "\u019e", "\u0223", "\u0225", "\u0227", "\u0229", "\u022b", "\u022d", "\u022f", "\u0231", "\u0233", "\u03b9", " \u03b9", "\u03ac", "\u03ad", "\u03ae", "\u03af", "\u03cc", "\u03cd", "\u03ce", "\u03b9\u0308\u0301", "\u03b1", "\u03b2", "\u03b3", "\u03b4", "\u03b5", "\u03b6", "\u03b7", "\u03b8", "\u03b9", "\u03ba", "\u03bb", "\u03bc", "\u03bd", "\u03be", "\u03bf", "\u03c0", "\u03c1", "\u03c3", "\u03c4", "\u03c5", "\u03c6", "\u03c7", "\u03c8", "\u03c9", "\u03ca", "\u03cb", "\u03c5\u0308\u0301", "\u03c3", "\u03b2", "\u03b8", "\u03c5", "\u03cd", "\u03cb", "\u03c6", "\u03c0", "\u03d9", "\u03db", "\u03dd", "\u03df", "\u03e1", "\u03e3", "\u03e5", "\u03e7", "\u03e9", "\u03eb", "\u03ed", "\u03ef", "\u03ba", "\u03c1", "\u03c3", "\u03b8", "\u03b5", "\u0450", "\u0451", "\u0452", "\u0453", "\u0454", "\u0455", "\u0456", "\u0457", "\u0458", "\u0459", "\u045a", "\u045b", "\u045c", "\u045d", "\u045e", "\u045f", "\u0430", "\u0431", "\u0432", "\u0433", "\u0434", "\u0435", "\u0436", "\u0437", "\u0438", "\u0439", "\u043a", "\u043b", "\u043c", "\u043d", "\u043e", "\u043f", "\u0440", "\u0441", "\u0442", "\u0443", "\u0444", "\u0445", "\u0446", "\u0447", "\u0448", "\u0449", "\u044a", "\u044b", "\u044c", "\u044d", "\u044e", "\u044f", "\u0461", "\u0463", "\u0465", "\u0467", "\u0469", "\u046b", "\u046d", "\u046f", "\u0471", "\u0473", "\u0475", "\u0477", "\u0479", "\u047b", "\u047d", "\u047f", "\u0481", "\u048b", "\u048d", "\u048f", "\u0491", "\u0493", "\u0495", "\u0497", "\u0499", "\u049b", "\u049d", "\u049f", "\u04a1", "\u04a3", "\u04a5", "\u04a7", "\u04a9", "\u04ab", "\u04ad", "\u04af", "\u04b1", "\u04b3", "\u04b5", "\u04b7", "\u04b9", "\u04bb", "\u04bd", "\u04bf", "\u04c2", "\u04c4", "\u04c6", "\u04c8", "\u04ca", "\u04cc", "\u04ce", "\u04d1", "\u04d3", "\u04d5", "\u04d7", "\u04d9", "\u04db", "\u04dd", "\u04df", "\u04e1", "\u04e3", "\u04e5", "\u04e7", "\u04e9", "\u04eb", "\u04ed", "\u04ef", "\u04f1", "\u04f3", "\u04f5", "\u04f9", "\u0501", "\u0503", "\u0505", "\u0507", "\u0509", "\u050b", "\u050d", "\u050f", "\u0561", "\u0562", "\u0563", "\u0564", "\u0565", "\u0566", "\u0567", "\u0568", "\u0569", "\u056a", "\u056b", "\u056c", "\u056d", "\u056e", "\u056f", "\u0570", "\u0571", "\u0572", "\u0573", "\u0574", "\u0575", "\u0576", "\u0577", "\u0578", "\u0579", "\u057a", "\u057b", "\u057c", "\u057d", "\u057e", "\u057f", "\u0580", "\u0581", "\u0582", "\u0583", "\u0584", "\u0585", "\u0586", "\u0565\u0582", "\u1e01", "\u1e03", "\u1e05", "\u1e07", "\u1e09", "\u1e0b", "\u1e0d", "\u1e0f", "\u1e11", "\u1e13", "\u1e15", "\u1e17", "\u1e19", "\u1e1b", "\u1e1d", "\u1e1f", "\u1e21", "\u1e23", "\u1e25", "\u1e27", "\u1e29", "\u1e2b", "\u1e2d", "\u1e2f", "\u1e31", "\u1e33", "\u1e35", "\u1e37", "\u1e39", "\u1e3b", "\u1e3d", "\u1e3f", "\u1e41", "\u1e43", "\u1e45", "\u1e47", "\u1e49", "\u1e4b", "\u1e4d", "\u1e4f", "\u1e51", "\u1e53", "\u1e55", "\u1e57", "\u1e59", "\u1e5b", "\u1e5d", "\u1e5f", "\u1e61", "\u1e63", "\u1e65", "\u1e67", "\u1e69", "\u1e6b", "\u1e6d", "\u1e6f", "\u1e71", "\u1e73", "\u1e75", "\u1e77", "\u1e79", "\u1e7b", "\u1e7d", "\u1e7f", "\u1e81", "\u1e83", "\u1e85", "\u1e87", "\u1e89", "\u1e8b", "\u1e8d", "\u1e8f", "\u1e91", "\u1e93", "\u1e95", "h\u0331", "t\u0308", "w\u030a", "y\u030a", "a\u02be", "\u1e61", "\u1ea1", "\u1ea3", "\u1ea5", "\u1ea7", "\u1ea9", "\u1eab", "\u1ead", "\u1eaf", "\u1eb1", "\u1eb3", "\u1eb5", "\u1eb7", "\u1eb9", "\u1ebb", "\u1ebd", "\u1ebf", "\u1ec1", "\u1ec3", "\u1ec5", "\u1ec7", "\u1ec9", "\u1ecb", "\u1ecd", "\u1ecf", "\u1ed1", "\u1ed3", "\u1ed5", "\u1ed7", "\u1ed9", "\u1edb", "\u1edd", "\u1edf", "\u1ee1", "\u1ee3", "\u1ee5", "\u1ee7", "\u1ee9", "\u1eeb", "\u1eed", "\u1eef", "\u1ef1", "\u1ef3", "\u1ef5", "\u1ef7", "\u1ef9", "\u1f00", "\u1f01", "\u1f02", "\u1f03", "\u1f04", "\u1f05", "\u1f06", "\u1f07", "\u1f10", "\u1f11", "\u1f12", "\u1f13", "\u1f14", "\u1f15", "\u1f20", "\u1f21", "\u1f22", "\u1f23", "\u1f24", "\u1f25", "\u1f26", "\u1f27", "\u1f30", "\u1f31", "\u1f32", "\u1f33", "\u1f34", "\u1f35", "\u1f36", "\u1f37", "\u1f40", "\u1f41", "\u1f42", "\u1f43", "\u1f44", "\u1f45", "\u03c5\u0313", "\u03c5\u0313\u0300", "\u03c5\u0313\u0301", "\u03c5\u0313\u0342", "\u1f51", "\u1f53", "\u1f55", "\u1f57", "\u1f60", "\u1f61", "\u1f62", "\u1f63", "\u1f64", "\u1f65", "\u1f66", "\u1f67", "\u1f00\u03b9", "\u1f01\u03b9", "\u1f02\u03b9", "\u1f03\u03b9", "\u1f04\u03b9", "\u1f05\u03b9", "\u1f06\u03b9", "\u1f07\u03b9", "\u1f00\u03b9", "\u1f01\u03b9", "\u1f02\u03b9", "\u1f03\u03b9", "\u1f04\u03b9", "\u1f05\u03b9", "\u1f06\u03b9", "\u1f07\u03b9", "\u1f20\u03b9", "\u1f21\u03b9", "\u1f22\u03b9", "\u1f23\u03b9", "\u1f24\u03b9", "\u1f25\u03b9", "\u1f26\u03b9", "\u1f27\u03b9", "\u1f20\u03b9", "\u1f21\u03b9", "\u1f22\u03b9", "\u1f23\u03b9", "\u1f24\u03b9", "\u1f25\u03b9", "\u1f26\u03b9", "\u1f27\u03b9", "\u1f60\u03b9", "\u1f61\u03b9", "\u1f62\u03b9", "\u1f63\u03b9", "\u1f64\u03b9", "\u1f65\u03b9", "\u1f66\u03b9", "\u1f67\u03b9", "\u1f60\u03b9", "\u1f61\u03b9", "\u1f62\u03b9", "\u1f63\u03b9", "\u1f64\u03b9", "\u1f65\u03b9", "\u1f66\u03b9", "\u1f67\u03b9", "\u1f70\u03b9", "\u03b1\u03b9", "\u03ac\u03b9", "\u03b1\u0342", "\u03b1\u0342\u03b9", "\u1fb0", "\u1fb1", "\u1f70", "\u1f71", "\u03b1\u03b9", "\u03b9", "\u1f74\u03b9", "\u03b7\u03b9", "\u03ae\u03b9", "\u03b7\u0342", "\u03b7\u0342\u03b9", "\u1f72", "\u1f73", "\u1f74", "\u1f75", "\u03b7\u03b9", "\u03b9\u0308\u0300", "\u03b9\u0308\u0301", "\u03b9\u0342", "\u03b9\u0308\u0342", "\u1fd0", "\u1fd1", "\u1f76", "\u1f77", "\u03c5\u0308\u0300", "\u03c5\u0308\u0301", "\u03c1\u0313", "\u03c5\u0342", "\u03c5\u0308\u0342", "\u1fe0", "\u1fe1", "\u1f7a", "\u1f7b", "\u1fe5", "\u1f7c\u03b9", "\u03c9\u03b9", "\u03ce\u03b9", "\u03c9\u0342", "\u03c9\u0342\u03b9", "\u1f78", "\u1f79", "\u1f7c", "\u1f7d", "\u03c9\u03b9", "rs", "c", "\u00b0c", "\u025b", "\u00b0f", "h", "h", "h", "i", "i", "l", "n", "no", "p", "q", "r", "r", "r", "sm", "tel", "tm", "z", "\u03c9", "z", "k", "\u00e5", "b", "c", "e", "f", "m", "\u03b3", "\u03c0", "d", "\u2170", "\u2171", "\u2172", "\u2173", "\u2174", "\u2175", "\u2176", "\u2177", "\u2178", "\u2179", "\u217a", "\u217b", "\u217c", "\u217d", "\u217e", "\u217f", "\u24d0", "\u24d1", "\u24d2", "\u24d3", "\u24d4", "\u24d5", "\u24d6", "\u24d7", "\u24d8", "\u24d9", "\u24da", "\u24db", "\u24dc", "\u24dd", "\u24de", "\u24df", "\u24e0", "\u24e1", "\u24e2", "\u24e3", "\u24e4", "\u24e5", "\u24e6", "\u24e7", "\u24e8", "\u24e9", "hpa", "au", "ov", "pa", "na", "\u03bca", "ma", "ka", "kb", "mb", "gb", "pf", "nf", "\u03bcf", "hz", "khz", "mhz", "ghz", "thz", "pa", "kpa", "mpa", "gpa", "pv", "nv", "\u03bcv", "mv", "kv", "mv", "pw", "nw", "\u03bcw", "mw", "kw", "mw", "k\u03c9", "m\u03c9", "bq", "c\u2215kg", "co.", "db", "gy", "hp", "kk", "km", "ph", "ppm", "pr", "sv", "wb", "ff", "fi", "fl", "ffi", "ffl", "st", "st", "\u0574\u0576", "\u0574\u0565", "\u0574\u056b", "\u057e\u0576", "\u0574\u056d", "\uff41", "\uff42", "\uff43", "\uff44", "\uff45", "\uff46", "\uff47", "\uff48", "\uff49", "\uff4a", "\uff4b", "\uff4c", "\uff4d", "\uff4e", "\uff4f", "\uff50", "\uff51", "\uff52", "\uff53", "\uff54", "\uff55", "\uff56", "\uff57", "\uff58", "\uff59", "\uff5a"};
            for (int count = 0; count < upperCaseArr.length; ++count) {
                CASE_MAP_TABLE.put(Character.valueOf(upperCaseArr[count]), lowerCaseFoldedArr[count]);
            }
        }
    }
}

