/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

public abstract class ReferenceCountedObject<T> {
    private T instance = null;
    private final Object lock = new Object();
    private int refCount = 0;

    protected ReferenceCountedObject() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Reference acquire() {
        Object object = this.lock;
        synchronized (object) {
            if (this.refCount++ == 0) {
                assert (this.instance == null);
                this.instance = this.newInstance();
            }
            assert (this.instance != null);
            return new Reference(this.instance);
        }
    }

    public final Reference acquireIfNull(T value) {
        return value != null ? new Reference(value) : this.acquire();
    }

    protected abstract void destroyInstance(T var1);

    protected abstract T newInstance();

    public final class Reference {
        private volatile T value;

        private Reference(T value) {
            this.value = value;
        }

        public T get() {
            if (this.value == null) {
                throw new NullPointerException();
            }
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() {
            Object instanceToRelease = null;
            Object object = ReferenceCountedObject.this.lock;
            synchronized (object) {
                if (this.value != null && ReferenceCountedObject.this.instance == this.value && --ReferenceCountedObject.this.refCount == 0) {
                    instanceToRelease = this.value;
                    ReferenceCountedObject.this.instance = null;
                    this.value = null;
                }
            }
            if (instanceToRelease != null) {
                ReferenceCountedObject.this.destroyInstance(instanceToRelease);
            }
        }

        protected void finalize() {
            this.release();
        }
    }
}

