/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import com.forgerock.opendj.util.Iterators;
import com.forgerock.opendj.util.Predicate;
import java.util.Collection;
import java.util.Iterator;
import org.forgerock.opendj.ldap.Function;

public final class Iterables {
    private static final Iterable<Object> EMPTY_ITERABLE = new EmptyIterable<Object>();

    public static <M> Iterable<M> arrayIterable(M[] a) {
        return new ArrayIterable(a);
    }

    public static <M> Iterable<M> emptyIterable() {
        return EMPTY_ITERABLE;
    }

    public static <M, P> Iterable<M> filteredIterable(Iterable<M> iterable, Predicate<? super M, P> predicate, P p) {
        return new FilteredIterable(iterable, predicate, p);
    }

    public static <M> Iterable<M> filteredIterable(Iterable<M> iterable, Predicate<? super M, Void> predicate) {
        return new FilteredIterable(iterable, predicate, null);
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        return !iterable.iterator().hasNext();
    }

    public static <M> Iterable<M> singletonIterable(M value) {
        return new SingletonIterable(value);
    }

    public static int size(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        Iterator<?> i = iterable.iterator();
        int sz = 0;
        while (i.hasNext()) {
            i.next();
            ++sz;
        }
        return sz;
    }

    public static String toString(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).toString();
        }
        StringBuilder builder = new StringBuilder();
        boolean firstValue = true;
        builder.append('[');
        for (Object value : iterable) {
            if (!firstValue) {
                builder.append(", ");
            }
            builder.append(String.valueOf(value));
            firstValue = false;
        }
        builder.append(']');
        return builder.toString();
    }

    public static <M, N, P> Iterable<N> transformedIterable(Iterable<M> iterable, Function<? super M, ? extends N, P> function, P p) {
        return new TransformedIterable(iterable, function, p);
    }

    public static <M, N> Iterable<N> transformedIterable(Iterable<M> iterable, Function<? super M, ? extends N, Void> function) {
        return new TransformedIterable(iterable, function, null);
    }

    public static <M> Iterable<M> unmodifiableIterable(Iterable<M> iterable) {
        return new UnmodifiableIterable(iterable);
    }

    private Iterables() {
    }

    private static final class UnmodifiableIterable<M>
    extends AbstractIterable<M> {
        private final Iterable<M> iterable;

        private UnmodifiableIterable(Iterable<M> iterable) {
            this.iterable = iterable;
        }

        @Override
        public Iterator<M> iterator() {
            return Iterators.unmodifiableIterator(this.iterable.iterator());
        }
    }

    private static final class TransformedIterable<M, N, P>
    extends AbstractIterable<N> {
        private final Function<? super M, ? extends N, P> function;
        private final Iterable<M> iterable;
        private final P parameter;

        private TransformedIterable(Iterable<M> iterable, Function<? super M, ? extends N, P> function, P p) {
            this.iterable = iterable;
            this.function = function;
            this.parameter = p;
        }

        @Override
        public Iterator<N> iterator() {
            return Iterators.transformedIterator(this.iterable.iterator(), this.function, this.parameter);
        }
    }

    private static final class SingletonIterable<M>
    extends AbstractIterable<M> {
        private final M value;

        private SingletonIterable(M value) {
            this.value = value;
        }

        @Override
        public Iterator<M> iterator() {
            return Iterators.singletonIterator(this.value);
        }
    }

    private static final class FilteredIterable<M, P>
    extends AbstractIterable<M> {
        private final Iterable<M> iterable;
        private final P parameter;
        private final Predicate<? super M, P> predicate;

        private FilteredIterable(Iterable<M> iterable, Predicate<? super M, P> predicate, P p) {
            this.iterable = iterable;
            this.predicate = predicate;
            this.parameter = p;
        }

        @Override
        public Iterator<M> iterator() {
            return Iterators.filteredIterator(this.iterable.iterator(), this.predicate, this.parameter);
        }
    }

    private static final class EmptyIterable<M>
    extends AbstractIterable<M> {
        private EmptyIterable() {
        }

        @Override
        public Iterator<M> iterator() {
            return Iterators.emptyIterator();
        }
    }

    private static final class ArrayIterable<M>
    extends AbstractIterable<M> {
        private final M[] a;

        private ArrayIterable(M[] a) {
            this.a = a;
        }

        @Override
        public Iterator<M> iterator() {
            return Iterators.arrayIterator(this.a);
        }
    }

    private static abstract class AbstractIterable<M>
    implements Iterable<M> {
        private AbstractIterable() {
        }

        public String toString() {
            return Iterables.toString(this);
        }
    }
}

