/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.ResultHandler;

public abstract class FutureResultTransformer<M, N>
implements FutureResult<N>,
ResultHandler<M> {
    private final ResultHandler<? super N> handler;
    private volatile FutureResult<? extends M> future = null;
    private N transformedResult = null;
    private ErrorResultException transformedErrorResult = null;

    protected FutureResultTransformer(ResultHandler<? super N> handler) {
        this.handler = handler;
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public final N get() throws ErrorResultException, InterruptedException {
        this.future.get();
        return this.get0();
    }

    @Override
    public final N get(long timeout, TimeUnit unit) throws ErrorResultException, TimeoutException, InterruptedException {
        this.future.get(timeout, unit);
        return this.get0();
    }

    @Override
    public final int getRequestID() {
        return this.future.getRequestID();
    }

    @Override
    public final void handleErrorResult(ErrorResultException error) {
        this.transformedErrorResult = this.transformErrorResult(error);
        if (this.handler != null) {
            this.handler.handleErrorResult(this.transformedErrorResult);
        }
    }

    @Override
    public final void handleResult(M result) {
        block3: {
            try {
                this.transformedResult = this.transformResult(result);
                if (this.handler != null) {
                    this.handler.handleResult(this.transformedResult);
                }
            }
            catch (ErrorResultException e) {
                this.transformedErrorResult = e;
                if (this.handler == null) break block3;
                this.handler.handleErrorResult(this.transformedErrorResult);
            }
        }
    }

    @Override
    public final boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.future.isDone();
    }

    public final void setFutureResult(FutureResult<? extends M> future) {
        this.future = future;
    }

    protected ErrorResultException transformErrorResult(ErrorResultException errorResult) {
        return errorResult;
    }

    protected abstract N transformResult(M var1) throws ErrorResultException;

    private N get0() throws ErrorResultException {
        if (this.transformedErrorResult != null) {
            throw this.transformedErrorResult;
        }
        return this.transformedResult;
    }
}

