/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import com.forgerock.opendj.util.Validator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;

public final class CompletedFutureResult<S>
implements FutureResult<S> {
    private final S result;
    private final ErrorResultException errorResult;
    private final int requestID;

    public CompletedFutureResult(ErrorResultException errorResult) {
        this(errorResult, -1);
    }

    public CompletedFutureResult(ErrorResultException errorResult, int requestID) {
        Validator.ensureNotNull(errorResult);
        this.result = null;
        this.errorResult = errorResult;
        this.requestID = requestID;
    }

    public CompletedFutureResult(S result) {
        this(result, -1);
    }

    public CompletedFutureResult(S result, int requestID) {
        this.result = result;
        this.errorResult = null;
        this.requestID = requestID;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public S get() throws ErrorResultException, InterruptedException {
        if (this.errorResult == null) {
            return this.result;
        }
        throw this.errorResult;
    }

    @Override
    public S get(long timeout, TimeUnit unit) throws ErrorResultException, TimeoutException, InterruptedException {
        return this.get();
    }

    @Override
    public int getRequestID() {
        return this.requestID;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return true;
    }
}

