/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import com.forgerock.opendj.util.Iterators;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.forgerock.opendj.ldap.Function;

public final class Collections2 {
    public static <M, N, P> Collection<N> transformedCollection(Collection<M> collection, Function<? super M, ? extends N, P> funcMtoN, Function<? super N, ? extends M, P> funcNtoM, P p) {
        return new TransformedCollection<M, N, P, Collection<M>>(collection, funcMtoN, funcNtoM, p);
    }

    public static <M, N> Collection<N> transformedCollection(Collection<M> collection, Function<? super M, ? extends N, Void> funcMtoN, Function<? super N, ? extends M, Void> funcNtoM) {
        return new TransformedCollection<M, N, Object, Collection<M>>(collection, funcMtoN, funcNtoM, null);
    }

    public static <M, N, P> List<N> transformedList(List<M> list, Function<? super M, ? extends N, P> funcMtoN, Function<? super N, ? extends M, P> funcNtoM, P p) {
        return new TransformedList(list, funcMtoN, funcNtoM, p);
    }

    public static <M, N> List<N> transformedList(List<M> list, Function<? super M, ? extends N, Void> funcMtoN, Function<? super N, ? extends M, Void> funcNtoM) {
        return new TransformedList(list, funcMtoN, funcNtoM, null);
    }

    private Collections2() {
    }

    private static final class TransformedList<M, N, P>
    extends TransformedCollection<M, N, P, List<M>>
    implements List<N> {
        private TransformedList(List<M> list, Function<? super M, ? extends N, P> funcMtoN, Function<? super N, ? extends M, P> funcNtoM, P p) {
            super(list, funcMtoN, funcNtoM, p);
        }

        @Override
        public void add(int index, N element) {
            ((List)this.collection).add(index, this.funcNtoM.apply(element, this.p));
        }

        @Override
        public boolean addAll(int index, Collection<? extends N> c) {
            boolean result = false;
            for (N e : c) {
                result |= this.add(e);
            }
            return result;
        }

        @Override
        public N get(int index) {
            return this.funcMtoN.apply(((List)this.collection).get(index), this.p);
        }

        @Override
        public int indexOf(Object o) {
            Object tmp = o;
            return ((List)this.collection).indexOf(this.funcNtoM.apply(tmp, this.p));
        }

        @Override
        public int lastIndexOf(Object o) {
            Object tmp = o;
            return ((List)this.collection).lastIndexOf(this.funcNtoM.apply(tmp, this.p));
        }

        @Override
        public ListIterator<N> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<N> listIterator(int index) {
            final ListIterator iterator = ((List)this.collection).listIterator(index);
            return new ListIterator<N>(){

                @Override
                public void add(N e) {
                    iterator.add(TransformedList.this.funcNtoM.apply(e, TransformedList.this.p));
                }

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public boolean hasPrevious() {
                    return iterator.hasPrevious();
                }

                @Override
                public N next() {
                    return TransformedList.this.funcMtoN.apply(iterator.next(), TransformedList.this.p);
                }

                @Override
                public int nextIndex() {
                    return iterator.nextIndex();
                }

                @Override
                public N previous() {
                    return TransformedList.this.funcMtoN.apply(iterator.previous(), TransformedList.this.p);
                }

                @Override
                public int previousIndex() {
                    return iterator.previousIndex();
                }

                @Override
                public void remove() {
                    iterator.remove();
                }

                @Override
                public void set(N e) {
                    iterator.set(TransformedList.this.funcNtoM.apply(e, TransformedList.this.p));
                }
            };
        }

        @Override
        public N remove(int index) {
            return this.funcMtoN.apply(((List)this.collection).remove(index), this.p);
        }

        @Override
        public N set(int index, N element) {
            Object result = ((List)this.collection).set(index, this.funcNtoM.apply(element, this.p));
            return this.funcMtoN.apply(result, this.p);
        }

        @Override
        public List<N> subList(int fromIndex, int toIndex) {
            List subList = ((List)this.collection).subList(fromIndex, toIndex);
            return new TransformedList(subList, this.funcMtoN, this.funcNtoM, this.p);
        }
    }

    private static class TransformedCollection<M, N, P, C extends Collection<M>>
    extends AbstractCollection<N>
    implements Collection<N> {
        protected final C collection;
        protected final Function<? super M, ? extends N, P> funcMtoN;
        protected final Function<? super N, ? extends M, P> funcNtoM;
        protected final P p;

        protected TransformedCollection(C collection, Function<? super M, ? extends N, P> funcMtoN, Function<? super N, ? extends M, P> funcNtoM, P p) {
            this.collection = collection;
            this.funcMtoN = funcMtoN;
            this.funcNtoM = funcNtoM;
            this.p = p;
        }

        @Override
        public boolean add(N e) {
            return this.collection.add(this.funcNtoM.apply(e, this.p));
        }

        @Override
        public void clear() {
            this.collection.clear();
        }

        @Override
        public boolean contains(Object o) {
            Object tmp = o;
            return this.collection.contains(this.funcNtoM.apply(tmp, this.p));
        }

        @Override
        public boolean isEmpty() {
            return this.collection.isEmpty();
        }

        @Override
        public Iterator<N> iterator() {
            return Iterators.transformedIterator(this.collection.iterator(), this.funcMtoN, this.p);
        }

        @Override
        public boolean remove(Object o) {
            Object tmp = o;
            return this.collection.remove(this.funcNtoM.apply(tmp, this.p));
        }

        @Override
        public int size() {
            return this.collection.size();
        }
    }
}

