/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.LDAPConnection;
import com.forgerock.opendj.util.ReferenceCountedObject;
import com.forgerock.opendj.util.StaticUtils;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

final class TimeoutChecker {
    static final ReferenceCountedObject<TimeoutChecker> TIMEOUT_CHECKER = new ReferenceCountedObject<TimeoutChecker>(){

        @Override
        protected void destroyInstance(TimeoutChecker instance) {
            instance.shutdown();
        }

        @Override
        protected TimeoutChecker newInstance() {
            return new TimeoutChecker();
        }
    };
    private final Object available = new Object();
    private final Set<LDAPConnection> connections = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile boolean shutdownRequested = false;

    private TimeoutChecker() {
        Thread checkerThread = new Thread("OpenDJ LDAP SDK Connection Timeout Checker"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StaticUtils.DEBUG_LOG.fine("Timeout Checker Starting");
                while (!TimeoutChecker.this.shutdownRequested) {
                    long currentTime = System.currentTimeMillis();
                    long delay = 0L;
                    for (LDAPConnection connection : TimeoutChecker.this.connections) {
                        long newDelay;
                        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
                            StaticUtils.DEBUG_LOG.finer("Checking connection " + connection + " delay = " + delay);
                        }
                        if ((newDelay = connection.cancelExpiredRequests(currentTime)) <= 0L) continue;
                        if (delay > 0L) {
                            delay = Math.min(newDelay, delay);
                            continue;
                        }
                        delay = newDelay;
                    }
                    try {
                        Object i$ = TimeoutChecker.this.available;
                        synchronized (i$) {
                            if (delay <= 0L) {
                                TimeoutChecker.this.available.wait();
                            } else {
                                TimeoutChecker.this.available.wait(delay);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        TimeoutChecker.this.shutdownRequested = true;
                    }
                }
            }
        };
        checkerThread.setDaemon(true);
        checkerThread.start();
    }

    void addConnection(LDAPConnection connection) {
        this.connections.add(connection);
        this.signal();
    }

    void removeConnection(LDAPConnection connection) {
        this.connections.remove(connection);
    }

    private void shutdown() {
        this.shutdownRequested = true;
        this.signal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signal() {
        Object object = this.available;
        synchronized (object) {
            this.available.notifyAll();
        }
    }
}

