/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.LDAPReader;
import com.forgerock.opendj.ldap.LDAPWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.opendj.asn1.ASN1Reader;
import org.forgerock.opendj.asn1.ASN1Writer;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.FilterVisitor;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;

public final class LDAPUtils {
    private static final FilterVisitor<IOException, ASN1Writer> ASN1_ENCODER = new FilterVisitor<IOException, ASN1Writer>(){

        @Override
        public IOException visitAndFilter(ASN1Writer writer, List<Filter> subFilters) {
            try {
                writer.writeStartSequence((byte)-96);
                for (Filter subFilter : subFilters) {
                    IOException e = subFilter.accept(this, writer);
                    if (e == null) continue;
                    return e;
                }
                writer.writeEndSequence();
                return null;
            }
            catch (IOException e) {
                return e;
            }
        }

        @Override
        public IOException visitApproxMatchFilter(ASN1Writer writer, String attributeDescription, ByteString assertionValue) {
            try {
                writer.writeStartSequence((byte)-88);
                writer.writeOctetString(attributeDescription);
                writer.writeOctetString(assertionValue);
                writer.writeEndSequence();
                return null;
            }
            catch (IOException e) {
                return e;
            }
        }

        @Override
        public IOException visitEqualityMatchFilter(ASN1Writer writer, String attributeDescription, ByteString assertionValue) {
            try {
                writer.writeStartSequence((byte)-93);
                writer.writeOctetString(attributeDescription);
                writer.writeOctetString(assertionValue);
                writer.writeEndSequence();
                return null;
            }
            catch (IOException e) {
                return e;
            }
        }

        @Override
        public IOException visitExtensibleMatchFilter(ASN1Writer writer, String matchingRule, String attributeDescription, ByteString assertionValue, boolean dnAttributes) {
            try {
                writer.writeStartSequence((byte)-87);
                if (matchingRule != null) {
                    writer.writeOctetString((byte)-127, matchingRule);
                }
                if (attributeDescription != null) {
                    writer.writeOctetString((byte)-126, attributeDescription);
                }
                writer.writeOctetString((byte)-125, assertionValue);
                if (dnAttributes) {
                    writer.writeBoolean((byte)-124, true);
                }
                writer.writeEndSequence();
                return null;
            }
            catch (IOException e) {
                return e;
            }
        }

        @Override
        public IOException visitGreaterOrEqualFilter(ASN1Writer writer, String attributeDescription, ByteString assertionValue) {
            try {
                writer.writeStartSequence((byte)-91);
                writer.writeOctetString(attributeDescription);
                writer.writeOctetString(assertionValue);
                writer.writeEndSequence();
                return null;
            }
            catch (IOException e) {
                return e;
            }
        }

        @Override
        public IOException visitLessOrEqualFilter(ASN1Writer writer, String attributeDescription, ByteString assertionValue) {
            try {
                writer.writeStartSequence((byte)-90);
                writer.writeOctetString(attributeDescription);
                writer.writeOctetString(assertionValue);
                writer.writeEndSequence();
                return null;
            }
            catch (IOException e) {
                return e;
            }
        }

        @Override
        public IOException visitNotFilter(ASN1Writer writer, Filter subFilter) {
            try {
                writer.writeStartSequence((byte)-94);
                IOException e = subFilter.accept(this, writer);
                if (e != null) {
                    return e;
                }
                writer.writeEndSequence();
                return null;
            }
            catch (IOException e) {
                return e;
            }
        }

        @Override
        public IOException visitOrFilter(ASN1Writer writer, List<Filter> subFilters) {
            try {
                writer.writeStartSequence((byte)-95);
                for (Filter subFilter : subFilters) {
                    IOException e = subFilter.accept(this, writer);
                    if (e == null) continue;
                    return e;
                }
                writer.writeEndSequence();
                return null;
            }
            catch (IOException e) {
                return e;
            }
        }

        @Override
        public IOException visitPresentFilter(ASN1Writer writer, String attributeDescription) {
            try {
                writer.writeOctetString((byte)-121, attributeDescription);
                return null;
            }
            catch (IOException e) {
                return e;
            }
        }

        @Override
        public IOException visitSubstringsFilter(ASN1Writer writer, String attributeDescription, ByteString initialSubstring, List<ByteString> anySubstrings, ByteString finalSubstring) {
            try {
                writer.writeStartSequence((byte)-92);
                writer.writeOctetString(attributeDescription);
                writer.writeStartSequence();
                if (initialSubstring != null) {
                    writer.writeOctetString((byte)-128, initialSubstring);
                }
                for (ByteSequence byteSequence : anySubstrings) {
                    writer.writeOctetString((byte)-127, byteSequence);
                }
                if (finalSubstring != null) {
                    writer.writeOctetString((byte)-126, finalSubstring);
                }
                writer.writeEndSequence();
                writer.writeEndSequence();
                return null;
            }
            catch (IOException e) {
                return e;
            }
        }

        @Override
        public IOException visitUnrecognizedFilter(ASN1Writer writer, byte filterTag, ByteString filterBytes) {
            try {
                writer.writeOctetString(filterTag, filterBytes);
                return null;
            }
            catch (IOException e) {
                return e;
            }
        }
    };

    public static Filter decodeFilter(ASN1Reader reader) throws IOException {
        byte type = reader.peekType();
        switch (type) {
            case -96: {
                return LDAPUtils.decodeAndFilter(reader);
            }
            case -95: {
                return LDAPUtils.decodeOrFilter(reader);
            }
            case -94: {
                return LDAPUtils.decodeNotFilter(reader);
            }
            case -93: {
                return LDAPUtils.decodeEqualityMatchFilter(reader);
            }
            case -91: {
                return LDAPUtils.decodeGreaterOrEqualMatchFilter(reader);
            }
            case -90: {
                return LDAPUtils.decodeLessOrEqualMatchFilter(reader);
            }
            case -88: {
                return LDAPUtils.decodeApproxMatchFilter(reader);
            }
            case -92: {
                return LDAPUtils.decodeSubstringsFilter(reader);
            }
            case -121: {
                return Filter.present(reader.readOctetStringAsString(type));
            }
            case -87: {
                return LDAPUtils.decodeExtensibleMatchFilter(reader);
            }
        }
        return Filter.unrecognized(type, reader.readOctetString(type));
    }

    public static SearchResultEntry decodeSearchResultEntry(ASN1Reader reader, DecodeOptions options) throws IOException {
        return LDAPReader.decodeEntry(reader, options);
    }

    public static ASN1Writer encodeFilter(ASN1Writer writer, Filter filter) throws IOException {
        IOException e = filter.accept(ASN1_ENCODER, writer);
        if (e != null) {
            throw e;
        }
        return writer;
    }

    public static ASN1Writer encodeSearchResultEntry(ASN1Writer writer, SearchResultEntry entry) throws IOException {
        LDAPWriter.encodeEntry(writer, entry);
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Filter decodeAndFilter(ASN1Reader reader) throws IOException {
        Filter filter;
        reader.readStartSequence((byte)-96);
        try {
            if (reader.hasNextElement()) {
                LinkedList<Filter> subFilters = new LinkedList<Filter>();
                do {
                    subFilters.add(LDAPUtils.decodeFilter(reader));
                } while (reader.hasNextElement());
                filter = Filter.and(subFilters);
            } else {
                filter = Filter.alwaysTrue();
            }
        }
        finally {
            reader.readEndSequence();
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Filter decodeApproxMatchFilter(ASN1Reader reader) throws IOException {
        ByteString assertionValue;
        String attributeDescription;
        reader.readStartSequence((byte)-88);
        try {
            attributeDescription = reader.readOctetStringAsString();
            assertionValue = reader.readOctetString();
        }
        finally {
            reader.readEndSequence();
        }
        return Filter.approx(attributeDescription, assertionValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Filter decodeEqualityMatchFilter(ASN1Reader reader) throws IOException {
        ByteString assertionValue;
        String attributeDescription;
        reader.readStartSequence((byte)-93);
        try {
            attributeDescription = reader.readOctetStringAsString();
            assertionValue = reader.readOctetString();
        }
        finally {
            reader.readEndSequence();
        }
        return Filter.equality(attributeDescription, assertionValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Filter decodeExtensibleMatchFilter(ASN1Reader reader) throws IOException {
        ByteString assertionValue;
        boolean dnAttributes;
        String attributeDescription;
        String matchingRule;
        reader.readStartSequence((byte)-87);
        try {
            matchingRule = null;
            if (reader.peekType() == -127) {
                matchingRule = reader.readOctetStringAsString((byte)-127);
            }
            attributeDescription = null;
            if (reader.peekType() == -126) {
                attributeDescription = reader.readOctetStringAsString((byte)-126);
            }
            dnAttributes = false;
            if (reader.hasNextElement() && reader.peekType() == -124) {
                dnAttributes = reader.readBoolean();
            }
            assertionValue = reader.readOctetString((byte)-125);
        }
        finally {
            reader.readEndSequence();
        }
        return Filter.extensible(matchingRule, attributeDescription, assertionValue, dnAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Filter decodeGreaterOrEqualMatchFilter(ASN1Reader reader) throws IOException {
        ByteString assertionValue;
        String attributeDescription;
        reader.readStartSequence((byte)-91);
        try {
            attributeDescription = reader.readOctetStringAsString();
            assertionValue = reader.readOctetString();
        }
        finally {
            reader.readEndSequence();
        }
        return Filter.greaterOrEqual(attributeDescription, assertionValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Filter decodeLessOrEqualMatchFilter(ASN1Reader reader) throws IOException {
        ByteString assertionValue;
        String attributeDescription;
        reader.readStartSequence((byte)-90);
        try {
            attributeDescription = reader.readOctetStringAsString();
            assertionValue = reader.readOctetString();
        }
        finally {
            reader.readEndSequence();
        }
        return Filter.lessOrEqual(attributeDescription, assertionValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Filter decodeNotFilter(ASN1Reader reader) throws IOException {
        Filter subFilter;
        reader.readStartSequence((byte)-94);
        try {
            subFilter = LDAPUtils.decodeFilter(reader);
        }
        finally {
            reader.readEndSequence();
        }
        return Filter.not(subFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Filter decodeOrFilter(ASN1Reader reader) throws IOException {
        Filter filter;
        reader.readStartSequence((byte)-95);
        try {
            if (reader.hasNextElement()) {
                LinkedList<Filter> subFilters = new LinkedList<Filter>();
                do {
                    subFilters.add(LDAPUtils.decodeFilter(reader));
                } while (reader.hasNextElement());
                filter = Filter.or(subFilters);
            } else {
                filter = Filter.alwaysFalse();
            }
        }
        finally {
            reader.readEndSequence();
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Filter decodeSubstringsFilter(ASN1Reader reader) throws IOException {
        String attributeDescription;
        ByteString initialSubstring = null;
        List<ByteString> anySubstrings = null;
        ByteString finalSubstring = null;
        reader.readStartSequence((byte)-92);
        try {
            attributeDescription = reader.readOctetStringAsString();
            reader.readStartSequence();
            try {
                if (reader.peekType() == -128) {
                    initialSubstring = reader.readOctetString((byte)-128);
                }
                if (reader.hasNextElement() && reader.peekType() == -127) {
                    anySubstrings = new LinkedList<ByteString>();
                    do {
                        anySubstrings.add(reader.readOctetString((byte)-127));
                    } while (reader.hasNextElement() && reader.peekType() == -127);
                }
                if (reader.hasNextElement() && reader.peekType() == -126) {
                    finalSubstring = reader.readOctetString((byte)-126);
                }
            }
            finally {
                reader.readEndSequence();
            }
        }
        finally {
            reader.readEndSequence();
        }
        if (anySubstrings == null) {
            anySubstrings = Collections.emptyList();
        }
        return Filter.substrings(attributeDescription, initialSubstring, anySubstrings, finalSubstring);
    }

    private LDAPUtils() {
    }
}

