/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.UnexpectedRequestException;
import com.forgerock.opendj.ldap.UnexpectedResponseException;
import com.forgerock.opendj.ldap.UnsupportedMessageException;
import java.io.IOException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.IntermediateResponse;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;

interface LDAPMessageHandler<P> {
    public void abandonRequest(P var1, int var2, AbandonRequest var3) throws UnexpectedRequestException, IOException;

    public void addRequest(P var1, int var2, AddRequest var3) throws UnexpectedRequestException, IOException;

    public void addResult(P var1, int var2, Result var3) throws UnexpectedResponseException, IOException;

    public void bindRequest(P var1, int var2, int var3, GenericBindRequest var4) throws UnexpectedRequestException, IOException;

    public void bindResult(P var1, int var2, BindResult var3) throws UnexpectedResponseException, IOException;

    public void compareRequest(P var1, int var2, CompareRequest var3) throws UnexpectedRequestException, IOException;

    public void compareResult(P var1, int var2, CompareResult var3) throws UnexpectedResponseException, IOException;

    public void deleteRequest(P var1, int var2, DeleteRequest var3) throws UnexpectedRequestException, IOException;

    public void deleteResult(P var1, int var2, Result var3) throws UnexpectedResponseException, IOException;

    public <R extends ExtendedResult> void extendedRequest(P var1, int var2, ExtendedRequest<R> var3) throws UnexpectedRequestException, IOException;

    public void extendedResult(P var1, int var2, ExtendedResult var3) throws UnexpectedResponseException, IOException;

    public void intermediateResponse(P var1, int var2, IntermediateResponse var3) throws UnexpectedResponseException, IOException;

    public void modifyDNRequest(P var1, int var2, ModifyDNRequest var3) throws UnexpectedRequestException, IOException;

    public void modifyDNResult(P var1, int var2, Result var3) throws UnexpectedResponseException, IOException;

    public void modifyRequest(P var1, int var2, ModifyRequest var3) throws UnexpectedRequestException, IOException;

    public void modifyResult(P var1, int var2, Result var3) throws UnexpectedResponseException, IOException;

    public void searchRequest(P var1, int var2, SearchRequest var3) throws UnexpectedRequestException, IOException;

    public void searchResult(P var1, int var2, Result var3) throws UnexpectedResponseException, IOException;

    public void searchResultEntry(P var1, int var2, SearchResultEntry var3) throws UnexpectedResponseException, IOException;

    public void searchResultReference(P var1, int var2, SearchResultReference var3) throws UnexpectedResponseException, IOException;

    public void unbindRequest(P var1, int var2, UnbindRequest var3) throws UnexpectedRequestException, IOException;

    public void unrecognizedMessage(P var1, int var2, byte var3, ByteString var4) throws UnsupportedMessageException, IOException;
}

