/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.DefaultTCPNIOTransport;
import com.forgerock.opendj.ldap.LDAPClientFilter;
import com.forgerock.opendj.ldap.LDAPConnection;
import com.forgerock.opendj.ldap.LDAPReader;
import com.forgerock.opendj.ldap.TimeoutChecker;
import com.forgerock.opendj.util.AsynchronousFutureResult;
import com.forgerock.opendj.util.ReferenceCountedObject;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLEngine;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.LDAPOptions;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.StartTLSExtendedRequest;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOConnectorHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;

public final class LDAPConnectionFactoryImpl
implements ConnectionFactory {
    private final LDAPClientFilter clientFilter;
    private final FilterChain defaultFilterChain;
    private final LDAPOptions options;
    private final SocketAddress socketAddress;
    private final ReferenceCountedObject.Reference transport;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final ReferenceCountedObject.Reference timeoutChecker = TimeoutChecker.TIMEOUT_CHECKER.acquire();

    public LDAPConnectionFactoryImpl(SocketAddress address, LDAPOptions options) {
        this.transport = DefaultTCPNIOTransport.DEFAULT_TRANSPORT.acquireIfNull(options.getTCPNIOTransport());
        this.socketAddress = address;
        this.options = new LDAPOptions(options);
        this.clientFilter = new LDAPClientFilter(new LDAPReader(this.options.getDecodeOptions()), 0);
        this.defaultFilterChain = FilterChainBuilder.stateless().add((Filter)new TransportFilter()).add((Filter)this.clientFilter).build();
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.transport.release();
            this.timeoutChecker.release();
        }
    }

    @Override
    public org.forgerock.opendj.ldap.Connection getConnection() throws ErrorResultException {
        try {
            return this.getConnectionAsync(null).get();
        }
        catch (InterruptedException e) {
            throw ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_USER_CANCELLED, e);
        }
    }

    @Override
    public FutureResult<org.forgerock.opendj.ldap.Connection> getConnectionAsync(ResultHandler<? super org.forgerock.opendj.ldap.Connection> handler) {
        TCPNIOConnectorHandler connectorHandler = ((TCPNIOConnectorHandler.Builder)TCPNIOConnectorHandler.builder((TCPNIOTransport)((TCPNIOTransport)this.transport.get())).processor((Processor)this.defaultFilterChain)).build();
        AsynchronousFutureResult future = new AsynchronousFutureResult(handler);
        CompletionHandlerAdapter cha = new CompletionHandlerAdapter(future);
        connectorHandler.connect((Object)this.socketAddress, (CompletionHandler)cha);
        return future;
    }

    public SocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    TimeoutChecker getTimeoutChecker() {
        return (TimeoutChecker)this.timeoutChecker.get();
    }

    LDAPOptions getLDAPOptions() {
        return this.options;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LDAPConnectionFactory(");
        builder.append(this.getSocketAddress().toString());
        builder.append(')');
        return builder.toString();
    }

    private final class CompletionHandlerAdapter
    implements CompletionHandler<Connection> {
        private final AsynchronousFutureResult<org.forgerock.opendj.ldap.Connection, ResultHandler<? super org.forgerock.opendj.ldap.Connection>> future;

        private CompletionHandlerAdapter(AsynchronousFutureResult<org.forgerock.opendj.ldap.Connection, ResultHandler<? super org.forgerock.opendj.ldap.Connection>> future) {
            this.future = future;
        }

        public void cancelled() {
        }

        public void completed(Connection result) {
            final LDAPConnection connection = this.adaptConnection(result);
            if (LDAPConnectionFactoryImpl.this.options.getSSLContext() == null) {
                this.onSuccess(connection);
                return;
            }
            if (this.future.isCancelled()) {
                connection.close();
                return;
            }
            if (LDAPConnectionFactoryImpl.this.options.useStartTLS()) {
                StartTLSExtendedRequest startTLS = Requests.newStartTLSExtendedRequest(LDAPConnectionFactoryImpl.this.options.getSSLContext());
                startTLS.addEnabledCipherSuite(LDAPConnectionFactoryImpl.this.options.getEnabledCipherSuites().toArray(new String[LDAPConnectionFactoryImpl.this.options.getEnabledCipherSuites().size()]));
                startTLS.addEnabledProtocol(LDAPConnectionFactoryImpl.this.options.getEnabledProtocols().toArray(new String[LDAPConnectionFactoryImpl.this.options.getEnabledProtocols().size()]));
                ResultHandler<ExtendedResult> handler = new ResultHandler<ExtendedResult>(){

                    @Override
                    public void handleErrorResult(ErrorResultException error) {
                        CompletionHandlerAdapter.this.onFailure(connection, error);
                    }

                    @Override
                    public void handleResult(ExtendedResult result) {
                        CompletionHandlerAdapter.this.onSuccess(connection);
                    }
                };
                connection.extendedRequestAsync(startTLS, null, handler);
            } else {
                try {
                    connection.startTLS(LDAPConnectionFactoryImpl.this.options.getSSLContext(), LDAPConnectionFactoryImpl.this.options.getEnabledProtocols(), LDAPConnectionFactoryImpl.this.options.getEnabledCipherSuites(), (CompletionHandler<SSLEngine>)new EmptyCompletionHandler<SSLEngine>(){

                        public void completed(SSLEngine result) {
                            CompletionHandlerAdapter.this.onSuccess(connection);
                        }

                        public void failed(Throwable throwable) {
                            CompletionHandlerAdapter.this.onFailure(connection, throwable);
                        }
                    });
                }
                catch (IOException e) {
                    this.onFailure(connection, e);
                }
            }
        }

        public void failed(Throwable throwable) {
            this.future.handleErrorResult(this.adaptConnectionException(throwable));
        }

        public void updated(Connection result) {
        }

        private LDAPConnection adaptConnection(Connection<?> connection) {
            connection.configureBlocking(true);
            LDAPConnection ldapConnection = new LDAPConnection(connection, LDAPConnectionFactoryImpl.this);
            ((TimeoutChecker)LDAPConnectionFactoryImpl.this.timeoutChecker.get()).addConnection(ldapConnection);
            LDAPConnectionFactoryImpl.this.clientFilter.registerConnection(connection, ldapConnection);
            return ldapConnection;
        }

        private ErrorResultException adaptConnectionException(Throwable t) {
            if (!(t instanceof ErrorResultException) && t instanceof ExecutionException) {
                Throwable throwable = t = t.getCause() != null ? t.getCause() : t;
            }
            if (t instanceof ErrorResultException) {
                return (ErrorResultException)t;
            }
            return ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_CONNECT_ERROR, t.getMessage(), t);
        }

        private void onFailure(LDAPConnection connection, Throwable t) {
            connection.close();
            this.future.handleErrorResult(this.adaptConnectionException(t));
        }

        private void onSuccess(LDAPConnection connection) {
            this.future.handleResult(connection);
            if (this.future.isCancelled()) {
                connection.close();
            }
        }
    }
}

