/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap;

import org.forgerock.opendj.ldap.ConnectionSecurityLayer;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.glassfish.grizzly.AbstractTransformer;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.TransformationResult;
import org.glassfish.grizzly.Transformer;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.AbstractCodecFilter;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;

final class ConnectionSecurityLayerFilter
extends AbstractCodecFilter<Buffer, Buffer> {
    ConnectionSecurityLayerFilter(ConnectionSecurityLayer layer, MemoryManager<?> memoryManager) {
        super((Transformer)new Decoder(layer, memoryManager), (Transformer)new Encoder(layer, memoryManager));
    }

    private static final class Encoder
    extends AbstractTransformer<Buffer, Buffer> {
        private static final int BUFFER_SIZE = 4096;
        private final byte[] buffer = new byte[4096];
        private final ConnectionSecurityLayer layer;

        private Encoder(ConnectionSecurityLayer layer, MemoryManager<?> memoryManager) {
            this.layer = layer;
            this.setMemoryManager(memoryManager);
        }

        public String getName() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public boolean hasInputRemaining(AttributeStorage storage, Buffer input) {
            return input != null && input.hasRemaining();
        }

        public TransformationResult<Buffer, Buffer> transformImpl(AttributeStorage storage, Buffer input) {
            MemoryManager memoryManager = this.obtainMemoryManager(storage);
            int len = Math.min(this.buffer.length, input.remaining());
            input.get(this.buffer, 0, len);
            try {
                Buffer output = Buffers.wrap((MemoryManager)memoryManager, (byte[])this.layer.wrap(this.buffer, 0, len));
                return TransformationResult.createCompletedResult((Object)output, (Object)input);
            }
            catch (ErrorResultException e) {
                return TransformationResult.createErrorResult((int)e.getResult().getResultCode().intValue(), (String)e.getMessage());
            }
        }
    }

    private static final class Decoder
    extends AbstractTransformer<Buffer, Buffer> {
        private static final int BUFFER_SIZE = 4096;
        private final byte[] buffer = new byte[4096];
        private final ConnectionSecurityLayer layer;

        public Decoder(ConnectionSecurityLayer layer, MemoryManager<?> memoryManager) {
            this.layer = layer;
            this.setMemoryManager(memoryManager);
        }

        public String getName() {
            return ((Object)((Object)this)).getClass().getName();
        }

        public boolean hasInputRemaining(AttributeStorage storage, Buffer input) {
            return input != null && input.hasRemaining();
        }

        public TransformationResult<Buffer, Buffer> transformImpl(AttributeStorage storage, Buffer input) {
            MemoryManager memoryManager = this.obtainMemoryManager(storage);
            int len = Math.min(this.buffer.length, input.remaining());
            input.get(this.buffer, 0, len);
            try {
                Buffer output = Buffers.wrap((MemoryManager)memoryManager, (byte[])this.layer.unwrap(this.buffer, 0, len));
                return TransformationResult.createCompletedResult((Object)output, (Object)input);
            }
            catch (ErrorResultException e) {
                return TransformationResult.createErrorResult((int)e.getResult().getResultCode().intValue(), (String)e.getMessage());
            }
        }
    }
}

