/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.LDAPMessageHandler;
import com.forgerock.opendj.ldap.UnexpectedRequestException;
import com.forgerock.opendj.ldap.UnexpectedResponseException;
import com.forgerock.opendj.ldap.UnsupportedMessageException;
import java.io.IOException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.IntermediateResponse;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;

abstract class AbstractLDAPMessageHandler<P>
implements LDAPMessageHandler<P> {
    AbstractLDAPMessageHandler() {
    }

    @Override
    public void abandonRequest(P param, int messageID, AbandonRequest request) throws UnexpectedRequestException, IOException {
        throw new UnexpectedRequestException(messageID, request);
    }

    @Override
    public void addRequest(P param, int messageID, AddRequest request) throws UnexpectedRequestException, IOException {
        throw new UnexpectedRequestException(messageID, request);
    }

    @Override
    public void addResult(P param, int messageID, Result result) throws UnexpectedResponseException, IOException {
        throw new UnexpectedResponseException(messageID, result);
    }

    @Override
    public void bindRequest(P param, int messageID, int version, GenericBindRequest request) throws UnexpectedRequestException, IOException {
        throw new UnexpectedRequestException(messageID, request);
    }

    @Override
    public void bindResult(P param, int messageID, BindResult result) throws UnexpectedResponseException, IOException {
        throw new UnexpectedResponseException(messageID, result);
    }

    @Override
    public void compareRequest(P param, int messageID, CompareRequest request) throws UnexpectedRequestException, IOException {
        throw new UnexpectedRequestException(messageID, request);
    }

    @Override
    public void compareResult(P param, int messageID, CompareResult result) throws UnexpectedResponseException, IOException {
        throw new UnexpectedResponseException(messageID, result);
    }

    @Override
    public void deleteRequest(P param, int messageID, DeleteRequest request) throws UnexpectedRequestException, IOException {
        throw new UnexpectedRequestException(messageID, request);
    }

    @Override
    public void deleteResult(P param, int messageID, Result result) throws UnexpectedResponseException, IOException {
        throw new UnexpectedResponseException(messageID, result);
    }

    @Override
    public <R extends ExtendedResult> void extendedRequest(P param, int messageID, ExtendedRequest<R> request) throws UnexpectedRequestException, IOException {
        throw new UnexpectedRequestException(messageID, request);
    }

    @Override
    public void extendedResult(P param, int messageID, ExtendedResult result) throws UnexpectedResponseException, IOException {
        throw new UnexpectedResponseException(messageID, result);
    }

    @Override
    public void intermediateResponse(P param, int messageID, IntermediateResponse response) throws UnexpectedResponseException, IOException {
        throw new UnexpectedResponseException(messageID, response);
    }

    @Override
    public void modifyDNRequest(P param, int messageID, ModifyDNRequest request) throws UnexpectedRequestException, IOException {
        throw new UnexpectedRequestException(messageID, request);
    }

    @Override
    public void modifyDNResult(P param, int messageID, Result result) throws UnexpectedResponseException, IOException {
        throw new UnexpectedResponseException(messageID, result);
    }

    @Override
    public void modifyRequest(P param, int messageID, ModifyRequest request) throws UnexpectedRequestException, IOException {
        throw new UnexpectedRequestException(messageID, request);
    }

    @Override
    public void modifyResult(P param, int messageID, Result result) throws UnexpectedResponseException, IOException {
        throw new UnexpectedResponseException(messageID, result);
    }

    @Override
    public void searchRequest(P param, int messageID, SearchRequest request) throws UnexpectedRequestException, IOException {
        throw new UnexpectedRequestException(messageID, request);
    }

    @Override
    public void searchResult(P param, int messageID, Result result) throws UnexpectedResponseException, IOException {
        throw new UnexpectedResponseException(messageID, result);
    }

    @Override
    public void searchResultEntry(P param, int messageID, SearchResultEntry entry) throws UnexpectedResponseException, IOException {
        throw new UnexpectedResponseException(messageID, entry);
    }

    @Override
    public void searchResultReference(P param, int messageID, SearchResultReference reference) throws UnexpectedResponseException, IOException {
        throw new UnexpectedResponseException(messageID, reference);
    }

    @Override
    public void unbindRequest(P param, int messageID, UnbindRequest request) throws UnexpectedRequestException, IOException {
        throw new UnexpectedRequestException(messageID, request);
    }

    @Override
    public void unrecognizedMessage(P param, int messageID, byte messageTag, ByteString messageBytes) throws UnsupportedMessageException, IOException {
        throw new UnsupportedMessageException(messageID, messageTag, messageBytes);
    }
}

