/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.Connection;
import org.forgerock.json.resource.Context;
import org.forgerock.json.resource.PersistenceConfig;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.Resources;

public class ServerContext
extends Context {
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_CONNECTION_ID = "connection-id";
    private final Connection connection;

    public static final ServerContext loadFromJson(JsonValue savedContext, PersistenceConfig config) throws ResourceException {
        String className = savedContext.get(ATTR_CLASS).required().asString();
        try {
            Class<ServerContext> clazz = Class.forName(className, true, config.getClassLoader()).asSubclass(ServerContext.class);
            Constructor<ServerContext> constructor = clazz.getDeclaredConstructor(JsonValue.class, PersistenceConfig.class);
            return constructor.newInstance(savedContext, config);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to instantiate ServerContext implementation class '" + className + "'", e);
        }
    }

    public static final JsonValue saveToJson(ServerContext context, PersistenceConfig config) throws ResourceException {
        JsonValue savedContext = new JsonValue(new LinkedHashMap(4));
        context.saveToJson(savedContext, config);
        return savedContext;
    }

    public ServerContext(Context parent) {
        this(parent, null);
    }

    public ServerContext(Context parent, Connection connection) {
        super(Resources.checkNotNull(parent));
        this.connection = connection;
        this.getConnection();
    }

    public ServerContext(String id, Context parent) {
        this(id, parent, null);
    }

    public ServerContext(String id, Context parent, Connection connection) {
        super(id, Resources.checkNotNull(parent));
        this.connection = connection;
        this.getConnection();
    }

    protected ServerContext(JsonValue savedContext, PersistenceConfig config) throws ResourceException {
        super(savedContext, config);
        JsonValue connectionId = savedContext.get(ATTR_CONNECTION_ID);
        this.connection = connectionId.isNull() ? null : config.getConnectionProvider().getConnection(connectionId.asString());
    }

    public Connection getConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        return this.getParent().asContext(ServerContext.class).getConnection();
    }

    @Override
    protected void saveToJson(JsonValue savedContext, PersistenceConfig config) throws ResourceException {
        super.saveToJson(savedContext, config);
        if (this.connection != null) {
            savedContext.put(ATTR_CONNECTION_ID, (Object)config.getConnectionProvider().getConnectionId(this.connection));
        }
    }
}

