/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.Context;
import org.forgerock.json.resource.PersistenceConfig;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.Resources;

public final class SecurityContext
extends Context {
    public static final String AUTHZID_COMPONENT = "component";
    public static final String AUTHZID_DN = "dn";
    public static final String AUTHZID_GROUPS = "groups";
    public static final String AUTHZID_ID = "id";
    public static final String AUTHZID_REALM = "realm";
    public static final String AUTHZID_ROLES = "roles";
    private static final String ATTR_AUTHCID = "authcid";
    private static final String ATTR_AUTHZID = "authzid";
    private final String authcid;
    private final Map<String, Object> authzid;

    public SecurityContext(Context parent, String authcid, Map<String, Object> authzid) {
        super(Resources.checkNotNull(parent));
        this.authcid = authcid != null ? authcid : "";
        this.authzid = authzid != null ? Collections.unmodifiableMap(new LinkedHashMap<String, Object>(authzid)) : Collections.emptyMap();
    }

    public SecurityContext(String id, Context parent, String authcid, Map<String, Object> authzid) {
        super(id, Resources.checkNotNull(parent));
        this.authcid = authcid != null ? authcid : "";
        this.authzid = authzid != null ? Collections.unmodifiableMap(new LinkedHashMap<String, Object>(authzid)) : Collections.emptyMap();
    }

    SecurityContext(JsonValue savedContext, PersistenceConfig config) throws ResourceException {
        super(savedContext, config);
        this.authcid = savedContext.get(ATTR_AUTHCID).required().asString();
        this.authzid = savedContext.get(ATTR_AUTHZID).required().asMap();
    }

    public String getAuthenticationId() {
        return this.authcid;
    }

    public Map<String, Object> getAuthorizationId() {
        return this.authzid;
    }

    @Override
    protected void saveToJson(JsonValue savedContext, PersistenceConfig config) throws ResourceException {
        super.saveToJson(savedContext, config);
        savedContext.put(ATTR_AUTHCID, (Object)this.authcid);
        savedContext.put(ATTR_AUTHZID, this.authzid);
    }
}

