/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.Context;
import org.forgerock.json.resource.PersistenceConfig;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.Resources;
import org.forgerock.json.resource.ServerContext;

public final class RouterContext
extends ServerContext {
    private static final String ATTR_MATCHED_URI = "matched-uri";
    private static final String ATTR_URI_TEMPLATE_VARIABLES = "uri-template-variables";
    private final String matchedUri;
    private final Map<String, String> uriTemplateVariables;

    RouterContext(JsonValue savedContext, PersistenceConfig config) throws ResourceException {
        super(savedContext, config);
        this.matchedUri = savedContext.get(ATTR_MATCHED_URI).required().asString();
        Map savedMap = savedContext.get(ATTR_URI_TEMPLATE_VARIABLES).required().asMap();
        LinkedHashMap newMap = new LinkedHashMap(savedMap.size());
        for (Map.Entry e : savedMap.entrySet()) {
            newMap.put(e.getKey(), String.valueOf(e.getValue()));
        }
        this.uriTemplateVariables = Collections.unmodifiableMap(newMap);
    }

    RouterContext(ServerContext parent, String matchedUri, Map<String, String> uriTemplateVariables) {
        super(Resources.checkNotNull(parent));
        this.matchedUri = matchedUri;
        this.uriTemplateVariables = Collections.unmodifiableMap(uriTemplateVariables);
    }

    public String getBaseUri() {
        String baseUri;
        Context parent = this.getParent();
        StringBuilder builder = new StringBuilder();
        if (parent.containsContext(RouterContext.class) && (baseUri = parent.asContext(RouterContext.class).getBaseUri()).length() > 1) {
            builder.append(baseUri);
        }
        if (builder.length() == 0 || this.matchedUri.length() > 1) {
            builder.append(this.matchedUri);
        }
        return builder.toString();
    }

    public String getMatchedUri() {
        return this.matchedUri;
    }

    public Map<String, String> getUriTemplateVariables() {
        return this.uriTemplateVariables;
    }

    @Override
    protected void saveToJson(JsonValue savedContext, PersistenceConfig config) throws ResourceException {
        super.saveToJson(savedContext, config);
        savedContext.put(ATTR_MATCHED_URI, (Object)this.matchedUri);
        savedContext.put(ATTR_URI_TEMPLATE_VARIABLES, this.uriTemplateVariables);
    }
}

