/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.forgerock.json.fluent.JsonPointer;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.resource.AbstractAsynchronousConnection;
import org.forgerock.json.resource.AbstractConnectionWrapper;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.CollectionResourceProvider;
import org.forgerock.json.resource.CompletedFutureResult;
import org.forgerock.json.resource.Connection;
import org.forgerock.json.resource.ConnectionFactory;
import org.forgerock.json.resource.Context;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.FutureResult;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResult;
import org.forgerock.json.resource.QueryResultHandler;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.Resource;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResultHandler;
import org.forgerock.json.resource.Router;
import org.forgerock.json.resource.RouterContext;
import org.forgerock.json.resource.RoutingMode;
import org.forgerock.json.resource.ServerContext;
import org.forgerock.json.resource.SingletonResourceProvider;
import org.forgerock.json.resource.UpdateRequest;

public final class Resources {
    public static JsonValue filterResource(JsonValue resource, Collection<JsonPointer> fields) {
        if (fields.isEmpty() || resource.isNull() || resource.size() == 0) {
            return resource;
        }
        LinkedHashMap<String, Object> filtered = new LinkedHashMap<String, Object>(fields.size());
        for (JsonPointer field : fields) {
            if (field.isEmpty()) {
                filtered.putAll(resource.asMap());
                continue;
            }
            JsonValue value = resource.get(field);
            if (value == null) continue;
            String key = field.leaf();
            filtered.put(key, value.getObject());
        }
        return new JsonValue(filtered);
    }

    public static Resource filterResource(Resource resource, Collection<JsonPointer> fields) {
        JsonValue unfiltered = resource.getContent();
        JsonValue filtered = Resources.filterResource(unfiltered, fields);
        if (filtered == unfiltered) {
            return resource;
        }
        return new Resource(resource.getId(), resource.getRevision(), filtered);
    }

    public static RequestHandler newCollection(CollectionResourceProvider provider) {
        Router router = new Router();
        CollectionHandler collectionHandler = new CollectionHandler(provider);
        router.addRoute(RoutingMode.EQUALS, "/", collectionHandler);
        CollectionInstance instanceHandler = new CollectionInstance(provider);
        router.addRoute(RoutingMode.EQUALS, "/{id}", instanceHandler);
        return router;
    }

    public static Connection newInternalConnection(RequestHandler handler) {
        return new InternalConnection(handler);
    }

    public static ConnectionFactory newInternalConnectionFactory(RequestHandler handler) {
        return new InternalConnectionFactory(handler);
    }

    public static RequestHandler newSingleton(SingletonResourceProvider provider) {
        return new SingletonHandler(provider);
    }

    public static Connection uncloseable(Connection connection) {
        return new AbstractConnectionWrapper<Connection>(connection){

            @Override
            public void close() {
            }
        };
    }

    public static ConnectionFactory uncloseable(final ConnectionFactory factory) {
        return new ConnectionFactory(){

            @Override
            public FutureResult<Connection> getConnectionAsync(ResultHandler<? super Connection> handler) {
                return factory.getConnectionAsync(handler);
            }

            @Override
            public Connection getConnection() throws ResourceException {
                return factory.getConnection();
            }

            @Override
            public void close() {
            }
        };
    }

    static <T> T checkNotNull(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    static String normalizeUri(String uri) {
        return uri.endsWith("/") ? uri : uri + "/";
    }

    static String removeUriLeadingSlash(String uri) {
        return uri.length() > 1 && uri.startsWith("/") ? uri.substring(1, uri.length()) : uri;
    }

    static String removeUriTrailingSlash(String uri) {
        return uri.length() > 1 && uri.endsWith("/") ? uri.substring(0, uri.length() - 1) : uri;
    }

    private static String idOf(ServerContext context) {
        return context.asContext(RouterContext.class).getUriTemplateVariables().get("id");
    }

    private static ResourceException newBadRequestException(String fs, Object ... args) {
        String msg = String.format(fs, args);
        return new BadRequestException(msg);
    }

    private static ServerContext parentOf(ServerContext context) {
        assert (context instanceof RouterContext);
        return (ServerContext)context.getParent();
    }

    private Resources() {
    }

    private static final class SingletonHandler
    implements RequestHandler {
        private final SingletonResourceProvider provider;

        private SingletonHandler(SingletonResourceProvider provider) {
            this.provider = provider;
        }

        @Override
        public void handleAction(ServerContext context, ActionRequest request, ResultHandler<JsonValue> handler) {
            this.provider.actionInstance(context, request, handler);
        }

        @Override
        public void handleCreate(ServerContext context, CreateRequest request, ResultHandler<Resource> handler) {
            handler.handleError(Resources.newBadRequestException("The singleton resource %s cannot be created", new Object[]{request.getResourceName()}));
        }

        @Override
        public void handleDelete(ServerContext context, DeleteRequest request, ResultHandler<Resource> handler) {
            handler.handleError(Resources.newBadRequestException("The singleton resource %s cannot be deleted", new Object[]{request.getResourceName()}));
        }

        @Override
        public void handlePatch(ServerContext context, PatchRequest request, ResultHandler<Resource> handler) {
            this.provider.patchInstance(context, request, handler);
        }

        @Override
        public void handleQuery(ServerContext context, QueryRequest request, QueryResultHandler handler) {
            handler.handleError(Resources.newBadRequestException("The singleton resource %s cannot be queried", new Object[]{request.getResourceName()}));
        }

        @Override
        public void handleRead(ServerContext context, ReadRequest request, ResultHandler<Resource> handler) {
            this.provider.readInstance(context, request, handler);
        }

        @Override
        public void handleUpdate(ServerContext context, UpdateRequest request, ResultHandler<Resource> handler) {
            this.provider.updateInstance(context, request, handler);
        }
    }

    private static final class InternalConnectionFactory
    implements ConnectionFactory {
        private final RequestHandler handler;

        private InternalConnectionFactory(RequestHandler handler) {
            this.handler = handler;
        }

        @Override
        public void close() {
        }

        @Override
        public Connection getConnection() {
            return Resources.newInternalConnection(this.handler);
        }

        @Override
        public FutureResult<Connection> getConnectionAsync(ResultHandler<? super Connection> handler) {
            Connection connection = this.getConnection();
            CompletedFutureResult<Connection> future = new CompletedFutureResult<Connection>(connection);
            if (handler != null) {
                handler.handleResult(connection);
            }
            return future;
        }
    }

    private static final class InternalConnection
    extends AbstractAsynchronousConnection {
        private final RequestHandler requestHandler;

        private InternalConnection(RequestHandler handler) {
            this.requestHandler = handler;
        }

        @Override
        public FutureResult<JsonValue> actionAsync(Context context, ActionRequest request, ResultHandler<? super JsonValue> handler) {
            FutureJsonValueHandler future = new FutureJsonValueHandler(handler);
            this.requestHandler.handleAction(this.getServerContext(context), request, future);
            return future;
        }

        @Override
        public void close() {
        }

        @Override
        public FutureResult<Resource> createAsync(Context context, CreateRequest request, ResultHandler<? super Resource> handler) {
            FutureResourceHandler future = new FutureResourceHandler(request, handler);
            this.requestHandler.handleCreate(this.getServerContext(context), request, future);
            return future;
        }

        @Override
        public FutureResult<Resource> deleteAsync(Context context, DeleteRequest request, ResultHandler<? super Resource> handler) {
            FutureResourceHandler future = new FutureResourceHandler(request, handler);
            this.requestHandler.handleDelete(this.getServerContext(context), request, future);
            return future;
        }

        @Override
        public boolean isClosed() {
            return false;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public FutureResult<Resource> patchAsync(Context context, PatchRequest request, ResultHandler<? super Resource> handler) {
            FutureResourceHandler future = new FutureResourceHandler(request, handler);
            this.requestHandler.handlePatch(this.getServerContext(context), request, future);
            return future;
        }

        @Override
        public FutureResult<QueryResult> queryAsync(Context context, QueryRequest request, QueryResultHandler handler) {
            FutureQueryResultHandler future = new FutureQueryResultHandler(request, handler);
            this.requestHandler.handleQuery(this.getServerContext(context), request, future);
            return future;
        }

        @Override
        public FutureResult<Resource> readAsync(Context context, ReadRequest request, ResultHandler<? super Resource> handler) {
            FutureResourceHandler future = new FutureResourceHandler(request, handler);
            this.requestHandler.handleRead(this.getServerContext(context), request, future);
            return future;
        }

        @Override
        public FutureResult<Resource> updateAsync(Context context, UpdateRequest request, ResultHandler<? super Resource> handler) {
            FutureResourceHandler future = new FutureResourceHandler(request, handler);
            this.requestHandler.handleUpdate(this.getServerContext(context), request, future);
            return future;
        }

        private ServerContext getServerContext(Context context) {
            if (context instanceof ServerContext) {
                return (ServerContext)context;
            }
            Connection connection = context.containsContext(ServerContext.class) ? context.asContext(ServerContext.class).getConnection() : this;
            return new ServerContext(context, connection);
        }
    }

    private static final class FutureResourceHandler
    extends AbstractFutureResultHandler<Resource, ResultHandler<? super Resource>> {
        private final Request request;

        private FutureResourceHandler(Request request, ResultHandler<? super Resource> handler) {
            super(handler, null);
            this.request = request;
        }

        @Override
        protected Resource transform(Resource result) {
            return Resources.filterResource(result, this.request.getFields());
        }
    }

    private static final class FutureQueryResultHandler
    extends AbstractFutureResultHandler<QueryResult, QueryResultHandler>
    implements QueryResultHandler {
        private final QueryRequest request;

        private FutureQueryResultHandler(QueryRequest request, QueryResultHandler handler) {
            super(handler, null);
            this.request = request;
        }

        @Override
        public boolean handleResource(Resource resource) {
            QueryResultHandler handler = (QueryResultHandler)this.getInnerHandler();
            if (handler != null) {
                return handler.handleResource(Resources.filterResource(resource, this.request.getFields()));
            }
            return true;
        }
    }

    private static final class FutureJsonValueHandler
    extends AbstractFutureResultHandler<JsonValue, ResultHandler<? super JsonValue>> {
        private FutureJsonValueHandler(ResultHandler<? super JsonValue> handler) {
            super(handler, null);
        }
    }

    private static final class CollectionInstance
    implements RequestHandler {
        private final CollectionResourceProvider provider;

        private CollectionInstance(CollectionResourceProvider provider) {
            this.provider = provider;
        }

        @Override
        public void handleAction(ServerContext context, ActionRequest request, ResultHandler<JsonValue> handler) {
            this.provider.actionInstance(Resources.parentOf(context), Resources.idOf(context), request, handler);
        }

        @Override
        public void handleCreate(ServerContext context, CreateRequest request, ResultHandler<Resource> handler) {
            handler.handleError(Resources.newBadRequestException("The resource instance %s cannot be created", new Object[]{request.getResourceName()}));
        }

        @Override
        public void handleDelete(ServerContext context, DeleteRequest request, ResultHandler<Resource> handler) {
            this.provider.deleteInstance(Resources.parentOf(context), Resources.idOf(context), request, handler);
        }

        @Override
        public void handlePatch(ServerContext context, PatchRequest request, ResultHandler<Resource> handler) {
            this.provider.patchInstance(Resources.parentOf(context), Resources.idOf(context), request, handler);
        }

        @Override
        public void handleQuery(ServerContext context, QueryRequest request, QueryResultHandler handler) {
            handler.handleError(Resources.newBadRequestException("The resource instance %s cannot be queried", new Object[]{request.getResourceName()}));
        }

        @Override
        public void handleRead(ServerContext context, ReadRequest request, ResultHandler<Resource> handler) {
            this.provider.readInstance(Resources.parentOf(context), Resources.idOf(context), request, handler);
        }

        @Override
        public void handleUpdate(ServerContext context, UpdateRequest request, ResultHandler<Resource> handler) {
            this.provider.updateInstance(Resources.parentOf(context), Resources.idOf(context), request, handler);
        }
    }

    private static final class CollectionHandler
    implements RequestHandler {
        private final CollectionResourceProvider provider;

        private CollectionHandler(CollectionResourceProvider provider) {
            this.provider = provider;
        }

        @Override
        public void handleAction(ServerContext context, ActionRequest request, ResultHandler<JsonValue> handler) {
            this.provider.actionCollection(Resources.parentOf(context), request, handler);
        }

        @Override
        public void handleCreate(ServerContext context, CreateRequest request, ResultHandler<Resource> handler) {
            this.provider.createInstance(Resources.parentOf(context), request, handler);
        }

        @Override
        public void handleDelete(ServerContext context, DeleteRequest request, ResultHandler<Resource> handler) {
            handler.handleError(Resources.newBadRequestException("The resource collection %s cannot be deleted", new Object[]{request.getResourceName()}));
        }

        @Override
        public void handlePatch(ServerContext context, PatchRequest request, ResultHandler<Resource> handler) {
            handler.handleError(Resources.newBadRequestException("The resource collection %s cannot be patched", new Object[]{request.getResourceName()}));
        }

        @Override
        public void handleQuery(ServerContext context, QueryRequest request, QueryResultHandler handler) {
            this.provider.queryCollection(Resources.parentOf(context), request, handler);
        }

        @Override
        public void handleRead(ServerContext context, ReadRequest request, ResultHandler<Resource> handler) {
            handler.handleError(Resources.newBadRequestException("The resource collection %s cannot be read", new Object[]{request.getResourceName()}));
        }

        @Override
        public void handleUpdate(ServerContext context, UpdateRequest request, ResultHandler<Resource> handler) {
            handler.handleError(Resources.newBadRequestException("The resource collection %s cannot be updated", new Object[]{request.getResourceName()}));
        }
    }

    private static abstract class AbstractFutureResultHandler<V, H extends ResultHandler<? super V>>
    implements FutureResult<V>,
    ResultHandler<V> {
        private ResourceException error = null;
        private final H innerHandler;
        private final CountDownLatch latch = new CountDownLatch(1);
        private V result = null;

        private AbstractFutureResultHandler(H innerHandler) {
            this.innerHandler = innerHandler;
        }

        @Override
        public final boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public final V get() throws ResourceException, InterruptedException {
            this.latch.await();
            return this.get0();
        }

        @Override
        public final V get(long timeout, TimeUnit unit) throws ResourceException, TimeoutException, InterruptedException {
            if (this.latch.await(timeout, unit)) {
                return this.get0();
            }
            throw new TimeoutException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void handleError(ResourceException error) {
            try {
                if (this.innerHandler != null) {
                    this.innerHandler.handleError(error);
                }
            }
            finally {
                this.error = error;
                this.latch.countDown();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void handleResult(V result) {
            V transformedResult = this.transform(result);
            try {
                if (this.innerHandler != null) {
                    this.innerHandler.handleResult(transformedResult);
                }
            }
            finally {
                this.result = transformedResult;
                this.latch.countDown();
            }
        }

        @Override
        public final boolean isCancelled() {
            return false;
        }

        @Override
        public final boolean isDone() {
            return this.latch.getCount() == 0L;
        }

        final H getInnerHandler() {
            return this.innerHandler;
        }

        V transform(V result) {
            return result;
        }

        private V get0() throws ResourceException {
            if (this.error == null) {
                return this.result;
            }
            throw this.error;
        }

        /* synthetic */ AbstractFutureResultHandler(ResultHandler x0, 1 x1) {
            this(x0);
        }
    }
}

