/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.LinkedHashMap;
import org.forgerock.json.fluent.JsonValue;

public final class Resource {
    public static final String FIELD_ID = "id";
    public static final String FIELD_REVISION = "revision";
    public static final String FIELD_CONTENT_ID = "_id";
    public static final String FIELD_CONTENT_REVISION = "_rev";
    public static final String FIELD_CONTENT = "content";
    private final JsonValue content;
    private final String id;
    private final String revision;

    public Resource(String id, String revision, JsonValue content) {
        this.id = id;
        this.revision = revision;
        this.content = content;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Resource) {
            Resource that = (Resource)obj;
            return this.isEqual(this.id, that.id) && this.isEqual(this.revision, that.revision);
        }
        return false;
    }

    public JsonValue getContent() {
        return this.content;
    }

    public String getId() {
        return this.id;
    }

    public String getRevision() {
        return this.revision;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + this.id != null ? this.id.hashCode() : 0;
        hash = hash * 31 + this.revision != null ? this.revision.hashCode() : 0;
        return hash;
    }

    public String toString() {
        JsonValue wrapper = new JsonValue(new LinkedHashMap(3));
        wrapper.add(FIELD_ID, (Object)this.id);
        wrapper.add("rev", (Object)this.revision);
        wrapper.add(FIELD_CONTENT, (Object)this.content);
        return wrapper.toString();
    }

    private boolean isEqual(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }
}

