/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import org.forgerock.json.resource.ConnectionProvider;

public final class PersistenceConfig {
    private final ClassLoader classLoader;
    private final ConnectionProvider connectionProvider;

    public static Builder builder() {
        return new Builder();
    }

    private PersistenceConfig(ConnectionProvider provider, ClassLoader classLoader) {
        this.connectionProvider = provider;
        this.classLoader = classLoader != null ? classLoader : PersistenceConfig.class.getClassLoader();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    public static final class Builder {
        private ClassLoader classLoader;
        private ConnectionProvider connectionProvider;

        private Builder() {
        }

        public PersistenceConfig build() {
            if (this.connectionProvider == null) {
                throw new IllegalStateException("No ConnectionProvider specified");
            }
            return new PersistenceConfig(this.connectionProvider, this.classLoader);
        }

        public Builder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public Builder connectionProvider(ConnectionProvider provider) {
            this.connectionProvider = provider;
            return this;
        }
    }
}

