/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.forgerock.json.fluent.JsonPointer;
import org.forgerock.json.fluent.JsonValue;
import org.forgerock.json.fluent.JsonValueException;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.CollectionResourceProvider;
import org.forgerock.json.resource.ConflictException;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.NotFoundException;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.PreconditionFailedException;
import org.forgerock.json.resource.QueryFilter;
import org.forgerock.json.resource.QueryFilterVisitor;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResult;
import org.forgerock.json.resource.QueryResultHandler;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Resource;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResultHandler;
import org.forgerock.json.resource.ServerContext;
import org.forgerock.json.resource.SortKey;
import org.forgerock.json.resource.UpdateRequest;

public final class MemoryBackend
implements CollectionResourceProvider {
    private static final QueryFilterVisitor<FilterResult, Resource> RESOURCE_FILTER = new QueryFilterVisitor<FilterResult, Resource>(){

        @Override
        public FilterResult visitAndFilter(Resource p, List<QueryFilter> subFilters) {
            FilterResult result = FilterResult.TRUE;
            for (QueryFilter subFilter : subFilters) {
                FilterResult r = subFilter.accept(this, p);
                if (r.ordinal() < result.ordinal()) {
                    result = r;
                }
                if (result != FilterResult.FALSE) continue;
                break;
            }
            return result;
        }

        @Override
        public FilterResult visitBooleanLiteralFilter(Resource p, boolean value) {
            return FilterResult.valueOf(value);
        }

        @Override
        public FilterResult visitContainsFilter(Resource p, JsonPointer field, Object valueAssertion) {
            for (Object value : this.getValues(p, field)) {
                if (!MemoryBackend.isCompatible(valueAssertion, value)) continue;
                if (valueAssertion instanceof String) {
                    String s1 = ((String)valueAssertion).toLowerCase(Locale.ENGLISH);
                    String s2 = ((String)value).toLowerCase(Locale.ENGLISH);
                    if (!s2.contains(s1)) continue;
                    return FilterResult.TRUE;
                }
                if (MemoryBackend.compareValues(valueAssertion, value) != 0) continue;
                return FilterResult.TRUE;
            }
            return FilterResult.FALSE;
        }

        @Override
        public FilterResult visitEqualsFilter(Resource p, JsonPointer field, Object valueAssertion) {
            for (Object value : this.getValues(p, field)) {
                if (!MemoryBackend.isCompatible(valueAssertion, value) || MemoryBackend.compareValues(valueAssertion, value) != 0) continue;
                return FilterResult.TRUE;
            }
            return FilterResult.FALSE;
        }

        @Override
        public FilterResult visitExtendedMatchFilter(Resource p, JsonPointer field, String matchingRuleId, Object valueAssertion) {
            return FilterResult.UNDEFINED;
        }

        @Override
        public FilterResult visitGreaterThanFilter(Resource p, JsonPointer field, Object valueAssertion) {
            for (Object value : this.getValues(p, field)) {
                if (!MemoryBackend.isCompatible(valueAssertion, value) || MemoryBackend.compareValues(valueAssertion, value) >= 0) continue;
                return FilterResult.TRUE;
            }
            return FilterResult.FALSE;
        }

        @Override
        public FilterResult visitGreaterThanOrEqualToFilter(Resource p, JsonPointer field, Object valueAssertion) {
            for (Object value : this.getValues(p, field)) {
                if (!MemoryBackend.isCompatible(valueAssertion, value) || MemoryBackend.compareValues(valueAssertion, value) > 0) continue;
                return FilterResult.TRUE;
            }
            return FilterResult.FALSE;
        }

        @Override
        public FilterResult visitLessThanFilter(Resource p, JsonPointer field, Object valueAssertion) {
            for (Object value : this.getValues(p, field)) {
                if (!MemoryBackend.isCompatible(valueAssertion, value) || MemoryBackend.compareValues(valueAssertion, value) <= 0) continue;
                return FilterResult.TRUE;
            }
            return FilterResult.FALSE;
        }

        @Override
        public FilterResult visitLessThanOrEqualToFilter(Resource p, JsonPointer field, Object valueAssertion) {
            for (Object value : this.getValues(p, field)) {
                if (!MemoryBackend.isCompatible(valueAssertion, value) || MemoryBackend.compareValues(valueAssertion, value) < 0) continue;
                return FilterResult.TRUE;
            }
            return FilterResult.FALSE;
        }

        @Override
        public FilterResult visitNotFilter(Resource p, QueryFilter subFilter) {
            switch (subFilter.accept(this, p)) {
                case FALSE: {
                    return FilterResult.TRUE;
                }
                case UNDEFINED: {
                    return FilterResult.UNDEFINED;
                }
            }
            return FilterResult.FALSE;
        }

        @Override
        public FilterResult visitOrFilter(Resource p, List<QueryFilter> subFilters) {
            FilterResult result = FilterResult.FALSE;
            for (QueryFilter subFilter : subFilters) {
                FilterResult r = subFilter.accept(this, p);
                if (r.ordinal() > result.ordinal()) {
                    result = r;
                }
                if (result != FilterResult.TRUE) continue;
                break;
            }
            return result;
        }

        @Override
        public FilterResult visitPresentFilter(Resource p, JsonPointer field) {
            JsonValue value = p.getContent().get(field);
            return FilterResult.valueOf(value != null);
        }

        @Override
        public FilterResult visitStartsWithFilter(Resource p, JsonPointer field, Object valueAssertion) {
            for (Object value : this.getValues(p, field)) {
                if (!MemoryBackend.isCompatible(valueAssertion, value)) continue;
                if (valueAssertion instanceof String) {
                    String s1 = ((String)valueAssertion).toLowerCase(Locale.ENGLISH);
                    String s2 = ((String)value).toLowerCase(Locale.ENGLISH);
                    if (!s2.startsWith(s1)) continue;
                    return FilterResult.TRUE;
                }
                if (MemoryBackend.compareValues(valueAssertion, value) != 0) continue;
                return FilterResult.TRUE;
            }
            return FilterResult.FALSE;
        }

        private List<Object> getValues(Resource resource, JsonPointer field) {
            JsonValue value = resource.getContent().get(field);
            if (value == null) {
                return Collections.emptyList();
            }
            if (value.isList()) {
                return value.asList();
            }
            return Collections.singletonList(value.getObject());
        }
    };
    private static final Comparator<Object> VALUE_COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return MemoryBackend.compareValues(o1, o2);
        }
    };
    private final AtomicLong nextResourceId = new AtomicLong();
    private final Map<String, Resource> resources = new ConcurrentHashMap<String, Resource>();
    private final Object writeLock = new Object();

    private static int compareValues(Object v1, Object v2) {
        if (v1 instanceof String && v2 instanceof String) {
            String s1 = (String)v1;
            String s2 = (String)v2;
            return s1.compareToIgnoreCase(s2);
        }
        if (v1 instanceof Number && v2 instanceof Number) {
            Double n1 = ((Number)v1).doubleValue();
            Double n2 = ((Number)v2).doubleValue();
            return n1.compareTo(n2);
        }
        if (v1 instanceof Boolean && v2 instanceof Boolean) {
            Boolean b1 = (Boolean)v1;
            Boolean b2 = (Boolean)v2;
            return b1.compareTo(b2);
        }
        return v1.getClass().getName().compareTo(v2.getClass().getName());
    }

    private static boolean isCompatible(Object v1, Object v2) {
        return v1 instanceof String && v2 instanceof String || v1 instanceof Number && v2 instanceof Number || v1 instanceof Boolean && v2 instanceof Boolean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCollection(ServerContext context, ActionRequest request, ResultHandler<JsonValue> handler) {
        try {
            int size;
            if (request.getAction().equals("clear")) {
                Object object = this.writeLock;
                synchronized (object) {
                    size = this.resources.size();
                    this.resources.clear();
                }
            } else {
                throw new NotSupportedException("Unrecognized action ID '" + request.getAction() + "'. Supported action IDs: clear");
            }
            JsonValue result = new JsonValue(new LinkedHashMap(1));
            result.put("cleared", (Object)size);
            handler.handleResult(result);
        }
        catch (ResourceException e) {
            handler.handleError(e);
        }
    }

    @Override
    public void actionInstance(ServerContext context, String id, ActionRequest request, ResultHandler<JsonValue> handler) {
        NotSupportedException e = new NotSupportedException("Actions are not supported for resource instances");
        handler.handleError(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createInstance(ServerContext context, CreateRequest request, ResultHandler<Resource> handler) {
        JsonValue value = request.getContent();
        String id = request.getNewResourceId();
        String rev = "0";
        try {
            Resource resource;
            while (true) {
                String eid = id != null ? id : String.valueOf(this.nextResourceId.getAndIncrement());
                Resource tmp = new Resource(eid, "0", value);
                Object object = this.writeLock;
                synchronized (object) {
                    Resource existingResource = this.resources.put(eid, tmp);
                    if (existingResource == null) {
                        this.addIdAndRevision(tmp);
                        resource = tmp;
                        break;
                    }
                    if (id != null) {
                        this.resources.put(id, existingResource);
                        throw new PreconditionFailedException("The resource with ID '" + id + "' could not be created because " + "there is already another resource with the same ID");
                    }
                }
            }
            handler.handleResult(resource);
        }
        catch (ResourceException e) {
            handler.handleError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteInstance(ServerContext context, String id, DeleteRequest request, ResultHandler<Resource> handler) {
        String rev = request.getRevision();
        try {
            Resource resource;
            Object object = this.writeLock;
            synchronized (object) {
                resource = this.getResourceForUpdate(id, rev);
                this.resources.remove(id);
            }
            handler.handleResult(resource);
        }
        catch (ResourceException e) {
            handler.handleError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void patchInstance(ServerContext context, String id, PatchRequest request, ResultHandler<Resource> handler) {
        String rev = request.getRevision();
        try {
            Resource resource;
            Object object = this.writeLock;
            synchronized (object) {
                Resource existingResource = this.getResourceForUpdate(id, rev);
                String newRev = this.getNextRevision(existingResource.getRevision());
                JsonValue newContent = existingResource.getContent().copy();
                for (PatchOperation operation : request.getPatchOperations()) {
                    try {
                        JsonValue value;
                        if (operation.isAdd()) {
                            newContent.putPermissive(operation.getField(), operation.getValue().getObject());
                            continue;
                        }
                        if (operation.isRemove()) {
                            Object valueToBeRemoved;
                            if (operation.getValue().isNull()) {
                                newContent.remove(operation.getField());
                                continue;
                            }
                            value = newContent.get(operation.getField());
                            if (value == null) continue;
                            if (value.isList()) {
                                valueToBeRemoved = operation.getValue().getObject();
                                Iterator iterator = value.asList().iterator();
                                while (iterator.hasNext()) {
                                    if (!valueToBeRemoved.equals(iterator.next())) continue;
                                    iterator.remove();
                                }
                                continue;
                            }
                            valueToBeRemoved = operation.getValue().getObject();
                            if (!valueToBeRemoved.equals(value.getObject())) continue;
                            newContent.remove(operation.getField());
                            continue;
                        }
                        if (operation.isReplace()) {
                            newContent.remove(operation.getField());
                            if (operation.getValue().isNull()) continue;
                            newContent.putPermissive(operation.getField(), operation.getValue().getObject());
                            continue;
                        }
                        if (!operation.isIncrement()) continue;
                        value = newContent.get(operation.getField());
                        Number amount = operation.getValue().asNumber();
                        if (value == null) {
                            throw new BadRequestException("The field '" + operation.getField() + "' does not exist");
                        }
                        if (value.isList()) {
                            List elements = value.asList();
                            for (int i = 0; i < elements.size(); ++i) {
                                elements.set(i, this.increment(operation, elements.get(i), amount));
                            }
                            continue;
                        }
                        newContent.put(operation.getField(), this.increment(operation, value.getObject(), amount));
                    }
                    catch (JsonValueException e) {
                        throw new ConflictException("The field '" + operation.getField() + "' does not exist");
                    }
                }
                resource = new Resource(id, newRev, newContent);
                this.addIdAndRevision(resource);
                this.resources.put(id, resource);
            }
            handler.handleResult(resource);
        }
        catch (ResourceException e) {
            handler.handleError(e);
        }
    }

    @Override
    public void queryCollection(ServerContext context, QueryRequest request, QueryResultHandler handler) {
        int firstResultIndex;
        boolean pagedResultsRequested;
        if (request.getQueryId() != null) {
            handler.handleError(new NotSupportedException("Query by ID not supported"));
            return;
        }
        if (request.getQueryExpression() != null) {
            handler.handleError(new NotSupportedException("Query by expression not supported"));
            return;
        }
        QueryFilter filter = request.getQueryFilter();
        int pageSize = request.getPageSize();
        String pagedResultsCookie = request.getPagedResultsCookie();
        boolean bl = pagedResultsRequested = pageSize > 0;
        if (!pagedResultsRequested || pagedResultsCookie == null || pagedResultsCookie.isEmpty() || request.getPagedResultsOffset() > 0) {
            firstResultIndex = Math.max(0, request.getPagedResultsOffset() - 1);
        } else {
            try {
                firstResultIndex = Integer.parseInt(pagedResultsCookie);
            }
            catch (NumberFormatException e) {
                handler.handleError(new BadRequestException("Invalid paged results cookie"));
                return;
            }
        }
        int lastResultIndex = pagedResultsRequested ? firstResultIndex + pageSize : Integer.MAX_VALUE;
        int resultIndex = 0;
        if (request.getSortKeys().isEmpty()) {
            for (Resource resource : this.resources.values()) {
                if (filter != null && !filter.accept(RESOURCE_FILTER, resource).toBoolean()) continue;
                if (resultIndex >= firstResultIndex && resultIndex < lastResultIndex) {
                    handler.handleResource(resource);
                }
                ++resultIndex;
            }
        } else {
            ArrayList<Resource> results = new ArrayList<Resource>();
            for (Resource resource : this.resources.values()) {
                if (filter != null && !filter.accept(RESOURCE_FILTER, resource).toBoolean()) continue;
                results.add(resource);
            }
            Collections.sort(results, new ResourceComparator(request.getSortKeys()));
            for (Resource resource : results) {
                if (resultIndex >= firstResultIndex && resultIndex < lastResultIndex) {
                    handler.handleResource(resource);
                }
                ++resultIndex;
            }
        }
        if (pagedResultsRequested) {
            String nextCookie = resultIndex > lastResultIndex ? String.valueOf(lastResultIndex) : null;
            int remaining = Math.max(resultIndex - lastResultIndex, 0);
            handler.handleResult(new QueryResult(nextCookie, remaining));
        } else {
            handler.handleResult(new QueryResult());
        }
    }

    @Override
    public void readInstance(ServerContext context, String id, ReadRequest request, ResultHandler<Resource> handler) {
        try {
            Resource resource = this.resources.get(id);
            if (resource == null) {
                throw new NotFoundException("The resource with ID '" + id + "' could not be read because it does not exist");
            }
            handler.handleResult(resource);
        }
        catch (ResourceException e) {
            handler.handleError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateInstance(ServerContext context, String id, UpdateRequest request, ResultHandler<Resource> handler) {
        String rev = request.getRevision();
        try {
            Resource resource;
            Object object = this.writeLock;
            synchronized (object) {
                Resource existingResource = this.getResourceForUpdate(id, rev);
                String newRev = this.getNextRevision(existingResource.getRevision());
                resource = new Resource(id, newRev, request.getNewContent());
                this.addIdAndRevision(resource);
                this.resources.put(id, resource);
            }
            handler.handleResult(resource);
        }
        catch (ResourceException e) {
            handler.handleError(e);
        }
    }

    private void addIdAndRevision(Resource resource) throws ResourceException {
        JsonValue content = resource.getContent();
        try {
            content.asMap().put("_id", resource.getId());
            content.asMap().put("_rev", resource.getRevision());
        }
        catch (JsonValueException e) {
            throw new BadRequestException("The request could not be processed because the provided content is not a JSON object");
        }
    }

    private String getNextRevision(String rev) throws ResourceException {
        try {
            return String.valueOf(Integer.parseInt(rev) + 1);
        }
        catch (NumberFormatException e) {
            throw new InternalServerErrorException("Malformed revision number '" + rev + "' encountered while updating a resource");
        }
    }

    private Resource getResourceForUpdate(String id, String rev) throws NotFoundException, PreconditionFailedException {
        Resource existingResource = this.resources.get(id);
        if (existingResource == null) {
            throw new NotFoundException("The resource with ID '" + id + "' could not be updated because it does not exist");
        }
        if (rev != null && !existingResource.getRevision().equals(rev)) {
            throw new PreconditionFailedException("The resource with ID '" + id + "' could not be updated because " + "it does not have the required version");
        }
        return existingResource;
    }

    private Object increment(PatchOperation operation, Object object, Number amount) throws BadRequestException {
        if (object instanceof Long) {
            return (Long)object + amount.longValue();
        }
        if (object instanceof Integer) {
            return (Integer)object + amount.intValue();
        }
        if (object instanceof Float) {
            return Float.valueOf(((Float)object).floatValue() + amount.floatValue());
        }
        if (object instanceof Double) {
            return (Double)object + amount.doubleValue();
        }
        throw new BadRequestException("The field '" + operation.getField() + "' is not a number");
    }

    private static final class ResourceComparator
    implements Comparator<Resource> {
        private final List<SortKey> sortKeys;

        private ResourceComparator(List<SortKey> sortKeys) {
            this.sortKeys = sortKeys;
        }

        @Override
        public int compare(Resource r1, Resource r2) {
            for (SortKey sortKey : this.sortKeys) {
                int result = this.compare(r1, r2, sortKey);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        private int compare(Resource r1, Resource r2, SortKey sortKey) {
            List<Object> vs1 = this.getValuesSorted(r1, sortKey.getField());
            List<Object> vs2 = this.getValuesSorted(r2, sortKey.getField());
            if (vs1.isEmpty() && vs2.isEmpty()) {
                return 0;
            }
            if (vs1.isEmpty()) {
                return 1;
            }
            if (vs2.isEmpty()) {
                return -1;
            }
            Object v1 = vs1.get(0);
            Object v2 = vs2.get(0);
            return sortKey.isAscendingOrder() ? MemoryBackend.compareValues(v1, v2) : -MemoryBackend.compareValues(v1, v2);
        }

        private List<Object> getValuesSorted(Resource resource, JsonPointer field) {
            JsonValue value = resource.getContent().get(field);
            if (value == null) {
                return Collections.emptyList();
            }
            if (value.isList()) {
                ArrayList results = value.asList();
                if (results.size() > 1) {
                    results = new ArrayList(results);
                    Collections.sort(results, VALUE_COMPARATOR);
                }
                return results;
            }
            return Collections.singletonList(value.getObject());
        }
    }

    private static enum FilterResult {
        FALSE,
        TRUE,
        UNDEFINED;


        static FilterResult valueOf(boolean b) {
            return b ? TRUE : FALSE;
        }

        boolean toBoolean() {
            return this == TRUE;
        }
    }
}

